/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DesktopTabbedPane;

public class ScrollableTabHandler {
    private DesktopTabbedPane _tabbedPane;
    private boolean _useScrollableTabbedPanesForSessionTabs;

    public ScrollableTabHandler(IApplication app, DesktopTabbedPane tabbedPane) {
        this._useScrollableTabbedPanesForSessionTabs = app.getSquirrelPreferences().getUseScrollableTabbedPanesForSessionTabs();
        if (!this._useScrollableTabbedPanesForSessionTabs) {
            return;
        }
        this._tabbedPane = tabbedPane;
        this._tabbedPane.setTabLayoutPolicy(1);
    }

    public void tabAdded() {
        if (!this._useScrollableTabbedPanesForSessionTabs) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Action action = ScrollableTabHandler.this._tabbedPane.getActionMap().get("scrollTabsForwardAction");
                action.actionPerformed(new ActionEvent(ScrollableTabHandler.this._tabbedPane, 1001, ""));
            }
        });
    }

    public void tabRemoved() {
        if (!this._useScrollableTabbedPanesForSessionTabs) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Action action = ScrollableTabHandler.this._tabbedPane.getActionMap().get("scrollTabsBackwardAction");
                action.actionPerformed(new ActionEvent(ScrollableTabHandler.this._tabbedPane, 1001, ""));
            }
        });
    }
}

