/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class MaxColumnAdjustLengthCtrl
extends Component {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MaxColumnAdjustLengthCtrl.class);
    private final JPanel _pnl = new JPanel(new GridBagLayout());
    private final JCheckBox _chkSetMaxAdjustLen;
    private final JTextField _txtMaxAdjustLen;

    public MaxColumnAdjustLengthCtrl() {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JLabel lblDesc = new JLabel(s_stringMgr.getString("GeneralPreferencesPanel.maxColumnAdjustLength.description"));
        this._pnl.add((Component)lblDesc, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._chkSetMaxAdjustLen = new JCheckBox(s_stringMgr.getString("GeneralPreferencesPanel.maxColumnAdjustLength.check"));
        this._pnl.add((Component)this._chkSetMaxAdjustLen, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._txtMaxAdjustLen = new JTextField();
        this._txtMaxAdjustLen.setColumns(6);
        this._pnl.add((Component)this._txtMaxAdjustLen, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this._pnl.add((Component)new JPanel(), gbc);
        this._pnl.setBorder(BorderFactory.createEtchedBorder());
        this._chkSetMaxAdjustLen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaxColumnAdjustLengthCtrl.this.onSetMaxAdjustLen();
            }
        });
    }

    private void onSetMaxAdjustLen() {
        this._txtMaxAdjustLen.setEnabled(this._chkSetMaxAdjustLen.isSelected());
    }

    public JPanel getPanel() {
        return this._pnl;
    }

    public boolean isMaxColumnAdjustLengthDefined() {
        this.enforceValid();
        return this._chkSetMaxAdjustLen.isSelected();
    }

    public int getMaxColumnAdjustLength() {
        if (StringUtilities.isEmpty(this._txtMaxAdjustLen.getText(), true)) {
            return -1;
        }
        try {
            int ret = Integer.parseInt(this._txtMaxAdjustLen.getText());
            if (0 < ret) {
                return ret;
            }
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void enforceValid() {
        if (0 < this.getMaxColumnAdjustLength()) {
            return;
        }
        this._txtMaxAdjustLen.setText(null);
        this._chkSetMaxAdjustLen.setSelected(false);
        this.onSetMaxAdjustLen();
    }

    public void init(boolean maxColumnAdjustLengthDefined, int maxColumnAdjustLength) {
        if (0 < maxColumnAdjustLength) {
            this._txtMaxAdjustLen.setText("" + maxColumnAdjustLength);
            this._chkSetMaxAdjustLen.setSelected(maxColumnAdjustLengthDefined);
        } else {
            this._chkSetMaxAdjustLen.setSelected(false);
        }
        this.onSetMaxAdjustLen();
    }
}

