/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.event.ActionEvent;
import java.util.List;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.action.DeleteTablesCommand;
import net.sourceforge.squirrel_sql.client.session.action.IObjectTreeAction;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DeleteSelectedTablesAction
extends SquirrelAction
implements IObjectTreeAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DeleteSelectedTablesAction.class);
    private static String TITLE = s_stringMgr.getString("DeleteSelectedTablesAction.title");
    private static String MSG = s_stringMgr.getString("DeleteSelectedTablesAction.message");
    private IObjectTreeAPI _tree;

    public DeleteSelectedTablesAction(IApplication app) {
        super(app);
    }

    @Override
    public void setObjectTree(IObjectTreeAPI tree) {
        this._tree = tree;
        this.setEnabled(null != this._tree);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<ITableInfo> tables;
        if (this._tree != null && (tables = this._tree.getSelectedTables()).size() > 0 && Dialogs.showYesNo(this.getApplication().getMainFrame(), MSG, TITLE)) {
            DeleteTablesCommand command = new DeleteTablesCommand(this._tree, tables);
            command.execute();
        }
    }
}

