/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

class DataScaleLayout
extends GridLayout {
    private Dimension buf = new Dimension();
    private double[] _renormedWeights;

    public DataScaleLayout(double[] weights) {
        super(1, weights.length);
        this.createRenormedWeights(weights);
    }

    private void createRenormedWeights(double[] weights) {
        int i;
        double[] buf = new double[weights.length];
        double sumRenormed = 0.0;
        for (i = 0; i < weights.length; ++i) {
            buf[i] = Math.max(weights[i], 0.016666666666666666);
            sumRenormed += buf[i];
        }
        this._renormedWeights = new double[buf.length];
        for (i = 0; i < buf.length; ++i) {
            this._renormedWeights[i] = buf[i] / sumRenormed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            if (this._renormedWeights.length == 0) {
                return;
            }
            Dimension pSize = parent.getSize(this.buf);
            int pw = pSize.width - (insets.left + insets.right);
            int h = pSize.height - (insets.top + insets.bottom);
            int y = insets.top;
            int x = insets.left;
            int pwLeftOver = pw;
            for (int i = 0; i < this._renormedWeights.length; ++i) {
                if (i < this._renormedWeights.length - 1) {
                    int width = (int)(this._renormedWeights[i] * (double)pw + 0.5);
                    parent.getComponent(i).setBounds(x, y, width, h);
                    x += width;
                    pwLeftOver -= width;
                    continue;
                }
                parent.getComponent(i).setBounds(x, y, pwLeftOver, h);
            }
        }
    }
}

