/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.completion.util;

class CompletionUtils {
    private static final char[] SEPARATORS = new char[]{' ', '\t', '\n', ',', '(', '\'', '\"', '=', '>', '<'};

    CompletionUtils() {
    }

    static String getStringToParse(String textTillCaret) {
        int lastIndexOfLineFeed = textTillCaret.lastIndexOf(10);
        String lineTillCaret = -1 == lastIndexOfLineFeed ? textTillCaret : textTillCaret.substring(lastIndexOfLineFeed);
        String beginning = "";
        if (0 != lineTillCaret.trim().length() && !Character.isWhitespace(lineTillCaret.charAt(lineTillCaret.length() - 1))) {
            String trimmedLineTillCaret = lineTillCaret.trim();
            int lastSeparatorIndex = CompletionUtils.getLastSeparatorIndex(trimmedLineTillCaret);
            beginning = -1 == lastSeparatorIndex ? trimmedLineTillCaret : trimmedLineTillCaret.substring(lastSeparatorIndex + 1, trimmedLineTillCaret.length());
        }
        return beginning;
    }

    static int getLastSeparatorIndex(String str) {
        int lastSeparatorIndex = -1;
        for (char separator : SEPARATORS) {
            int buf = str.lastIndexOf(separator);
            if (buf <= lastSeparatorIndex) continue;
            lastSeparatorIndex = buf;
        }
        return lastSeparatorIndex;
    }

    static int getStringToParsePosition(String textTillCaret) {
        int lastSeparatorIndex;
        int lastIndexOfLineFeed = textTillCaret.lastIndexOf(10);
        String lineTillCaret = -1 == lastIndexOfLineFeed ? textTillCaret : textTillCaret.substring(lastIndexOfLineFeed);
        int pos = lastIndexOfLineFeed + 1;
        if (0 != lineTillCaret.length() && !Character.isWhitespace(lineTillCaret.charAt(lineTillCaret.length() - 1)) && -1 != (lastSeparatorIndex = CompletionUtils.getLastSeparatorIndex(lineTillCaret))) {
            pos += lastSeparatorIndex;
        }
        return pos;
    }
}

