/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.dialect.DB2Dialect;

public class DB2DialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private final DB2DialectHelper _dialect = new DB2DialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database")) {
            result = false;
        }
        return result;
    }

    @Override
    public String getLengthFunction(int dataType) {
        return "length";
    }

    @Override
    public String getMaxFunction() {
        return "max";
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 8 || dataType == 6) {
            return 53;
        }
        return 31;
    }

    @Override
    public int getMaxScale(int dataType) {
        if (dataType == 8 || dataType == 6) {
            return 0;
        }
        return this.getMaxPrecision(dataType);
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "DB2";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("DB2");
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        String qualifedTableName = DialectUtils.shapeQualifiableIdentifier(info.getTableName(), qualifier, prefs, this);
        String shapedColumnName = DialectUtils.shapeIdentifier(info.getColumnName(), prefs, this);
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer addColumn = new StringBuffer();
        addColumn.append("ALTER TABLE ");
        addColumn.append(qualifedTableName);
        addColumn.append(" ADD ");
        addColumn.append(shapedColumnName);
        addColumn.append(" ");
        addColumn.append(this.getTypeName(info.getDataType(), info.getColumnSize(), info.getColumnSize(), info.getDecimalDigits()));
        if (info.getDefaultValue() != null) {
            addColumn.append(" WITH DEFAULT ");
            if (JDBCTypeMapper.isNumberType(info.getDataType())) {
                addColumn.append(info.getDefaultValue());
            } else {
                addColumn.append("'");
                addColumn.append(info.getDefaultValue());
                addColumn.append("'");
            }
        }
        result.add(addColumn.toString());
        if (info.isNullable() == "NO") {
            StringBuffer notnull = new StringBuffer();
            notnull.append("ALTER TABLE ");
            notnull.append(qualifedTableName);
            notnull.append(" ADD CONSTRAINT ");
            notnull.append(shapedColumnName);
            notnull.append(" CHECK (");
            notnull.append(shapedColumnName);
            notnull.append(" IS NOT NULL)");
            result.add(notnull.toString());
        }
        if (info.getRemarks() != null && !"".equals(info.getRemarks())) {
            result.add(this.getColumnCommentAlterSQL(info, qualifier, prefs));
        }
        return result.toArray(new String[result.size()]);
    }

    public String getColumnCommentAlterSQL(String tableName, String columnName, String comment, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs, HibernateDialect dialect) throws UnsupportedOperationException {
        return DialectUtils.getColumnCommentAlterSQL(tableName, columnName, comment, qualifier, prefs, dialect);
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, false, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddPrimaryKeySQL(ti, pkName, columns, false, qualifier, prefs, this)};
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        return DialectUtils.getColumnCommentAlterSQL(info, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean nullable = info.isNullable().equalsIgnoreCase("yes");
        result.addAll(Arrays.asList(this.getColumnNullableAlterSQL(info, nullable, qualifier, prefs)));
        StringBuilder reorgSql = new StringBuilder();
        reorgSql.append("CALL SYSPROC.ADMIN_CMD('REORG TABLE ");
        reorgSql.append(DialectUtils.shapeQualifiableIdentifier(info.getTableName(), qualifier, prefs, this));
        reorgSql.append("')");
        result.add(reorgSql.toString());
        return result.toArray(new String[result.size()]);
    }

    private String[] getColumnNullableAlterSQL(TableColumnInfo info, boolean nullable, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> sql = new ArrayList<String>();
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ");
        result.append(DialectUtils.shapeQualifiableIdentifier(info.getTableName(), qualifier, prefs, this));
        result.append(" ");
        result.append("ALTER COLUMN");
        result.append(" ");
        result.append(DialectUtils.shapeIdentifier(info.getColumnName(), prefs, this));
        result.append(" SET ");
        if (nullable) {
            result.append("NULL");
        } else {
            result.append("NOT NULL");
        }
        sql.add(result.toString());
        sql.add(this.getTableReorgSql(info.getTableName(), qualifier, prefs));
        return sql.toArray(new String[sql.size()]);
    }

    @Override
    public boolean supportsRenameColumn() {
        return false;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 3;
        String msg = DialectUtils.getUnsupportedMessage(this, 3);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        String templateString = "ALTER TABLE $tableName$ ALTER $columnName$ SET DATA TYPE $dataType$";
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ALTER $columnName$ SET DATA TYPE $dataType$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", from.getTableName());
        valuesMap.put("columnName", from.getColumnName());
        valuesMap.put("dataType", DialectUtils.getTypeName(to, this));
        ArrayList<String> result = new ArrayList<String>();
        result.add(DialectUtils.bindAttributes(this, st, valuesMap, qualifier, prefs));
        return result;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        String defaultClause = "SET DEFAULT";
        return DialectUtils.getColumnDefaultAlterSQL(this, info, "ALTER COLUMN", false, "SET DEFAULT", qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, false, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.DB2;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return new String[0];
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        String tableName = column.getTableName();
        String columnName = column.getColumnName();
        result.add(this.getCreateSequenceSQL(sequenceName, "1", "1", null, "1", null, false, qualifier, prefs));
        StringBuilder triggerSql = new StringBuilder();
        triggerSql.append("CREATE TRIGGER ");
        triggerSql.append(columnName);
        triggerSql.append("_trigger \n");
        triggerSql.append("NO CASCADE BEFORE INSERT ON ");
        triggerSql.append(tableName);
        triggerSql.append(" REFERENCING NEW AS n \n");
        triggerSql.append("FOR EACH ROW \n");
        triggerSql.append("SET n.");
        triggerSql.append(columnName);
        triggerSql.append(" = NEXTVAL FOR ");
        triggerSql.append(sequenceName);
        result.add(triggerSql.toString());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String tableName = column.getTableName();
        String columnName = column.getColumnName();
        StringBuilder sequenceName = new StringBuilder();
        sequenceName.append(tableName.toUpperCase()).append("_");
        sequenceName.append(columnName.toUpperCase()).append("_SEQ");
        return this.getAddAutoIncrementSQL(column, sequenceName.toString(), qualifier, prefs);
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean deferrableNotSupported = null;
        Boolean initiallyDeferredNotSupported = null;
        Boolean matchFullNotSupported = null;
        if (onUpdateAction != null && !onUpdateAction.equalsIgnoreCase("no action") && !onUpdateAction.equalsIgnoreCase("restrict")) {
            onUpdateAction = "";
        }
        if (onDeleteAction != null && onDeleteAction.equalsIgnoreCase("set default")) {
            onDeleteAction = "";
        }
        return DialectUtils.getAddForeignKeyConstraintSQL(localTableName, refTableName, constraintName, deferrableNotSupported, initiallyDeferredNotSupported, matchFullNotSupported, autoFKIndex, fkIndexName, localRefColumns, onUpdateAction, onDeleteAction, qualifier, prefs, this);
    }

    private String getTableReorgSql(String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder reorgSql = new StringBuilder();
        reorgSql.append("CALL SYSPROC.ADMIN_CMD('REORG TABLE ");
        reorgSql.append(DialectUtils.shapeQualifiableIdentifier(tableName, qualifier, prefs, this));
        reorgSql.append("')");
        return reorgSql.toString();
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        for (TableColumnInfo column : columns) {
            if (!column.isNullable().equalsIgnoreCase("YES")) continue;
            result.addAll(Arrays.asList(this.getColumnNullableAlterSQL(column, false, qualifier, prefs)));
        }
        result.add(DialectUtils.getAddUniqueConstraintSQL(tableName, constraintName, columns, qualifier, prefs, (HibernateDialect)this));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cycleClause = "NO CYCLE";
        if (cycle) {
            cycleClause = "CYCLE";
        }
        return new String[]{DialectUtils.getAlterSequenceSQL(sequenceName, increment, minimum, maximum, restart, cache, cycleClause, qualifier, prefs, this)};
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateIndexSQL(indexName, tableName, accessMethod, columns, unique, tablespace, constraints, qualifier, prefs, this);
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateSequenceSQL(sequenceName, increment, minimum, maximum, start, cache, null, qualifier, prefs, this);
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateViewSQL(viewName, definition, checkOption, qualifier, prefs, this);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropConstraintSQL(tableName, constraintName, qualifier, prefs, this);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropIndexSQL(indexName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropSequenceSQL(sequenceName, false, qualifier, prefs, this);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropViewSQL(viewName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String valuesPart, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, valuesPart, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder sql = new StringBuilder();
        sql.append("RENAME TABLE ");
        sql.append(DialectUtils.shapeQualifiableIdentifier(oldTableName, qualifier, prefs, this));
        sql.append(" ");
        sql.append(" TO ");
        sql.append(DialectUtils.shapeIdentifier(newTableName, prefs, this));
        return sql.toString();
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 11;
        String msg = DialectUtils.getUnsupportedMessage(this, 11);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder createViewSql = new StringBuilder();
        createViewSql.append("SELECT TEXT ");
        createViewSql.append(" FROM SYSCAT.VIEWS ");
        createViewSql.append("WHERE VIEWSCHEMA = '");
        createViewSql.append(qualifier.getSchema());
        createViewSql.append("' AND UPPER(VIEWNAME) = '");
        createViewSql.append(viewName.toUpperCase());
        createViewSql.append("'");
        return createViewSql.toString();
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT NEXTCACHEFIRSTVALUE, MAXVALUE, MINVALUE, CACHE, INCREMENT, CYCLE ");
        result.append("FROM SYSCAT.SEQUENCES ");
        result.append("WHERE ");
        if (qualifier.getSchema() != null) {
            result.append("SEQSCHEMA = upper('" + qualifier.getSchema() + "') AND ");
        }
        result.append("SEQNAME = '");
        result.append(sequenceName);
        result.append("'");
        return result.toString();
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return true;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String schema = qualifier.getSchema();
        String catalog = qualifier.getCatalog();
        StringBuilder result = new StringBuilder();
        if (!StringUtils.isEmpty((String)catalog)) {
            result.append(DialectUtils.shapeIdentifier(catalog, prefs, this));
            result.append(".");
        }
        if (!StringUtils.isEmpty((String)schema)) {
            result.append(DialectUtils.shapeIdentifier(schema, prefs, this));
            result.append(".");
        }
        result.append(DialectUtils.shapeIdentifier(identifier, prefs, this));
        return result.toString();
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public int getTimestampMaximumFractionalDigits() {
        return 6;
    }

    @Override
    public String getBinaryLiteralString(byte[] binaryData) {
        return "BLOB(x'" + DialectUtils.toHexString(binaryData) + "')";
    }

    private class DB2DialectHelper
    extends DB2Dialect {
        public DB2DialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 254, "char($l) for bit data");
            this.registerColumnType(-2, "blob");
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(2004, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(2004, "blob(1073741823)");
            this.registerColumnType(16, "smallint");
            this.registerColumnType(1, 254, "char($l)");
            this.registerColumnType(1, 4000, "varchar($l)");
            this.registerColumnType(1, 32700, "long varchar");
            this.registerColumnType(1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(1, "clob(1073741823)");
            this.registerColumnType(2005, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(2005, "clob(1073741823)");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, 32700, "long varchar for bit data");
            this.registerColumnType(-4, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(-4, "blob(1073741823)");
            this.registerColumnType(-1, 32700, "long varchar");
            this.registerColumnType(-1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-1, "clob(1073741823)");
            this.registerColumnType(2, "bigint");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(-3, 254, "varchar($l) for bit data");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, 3924, "varchar($l)");
            this.registerColumnType(12, 32700, "long varchar");
            this.registerColumnType(12, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(12, "clob(1073741823)");
            this.registerColumnType(-8, "int");
            this.registerColumnType(-9, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-9, "clob(1073741823)");
            this.registerColumnType(-15, "char($l)");
            this.registerColumnType(-16, "longvarchar");
            this.registerColumnType(2009, "clob");
            this.registerColumnType(2011, "clob");
        }
    }
}

