/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;
import net.sourceforge.squirrel_sql.fw.util.IProxySettings;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ProxyHandler {
    private static final ILogger s_log = LoggerController.createLogger(ProxyHandler.class);

    public void apply(IProxySettings proxy) {
        this.apply(proxy, System.getProperties());
    }

    public void apply(IProxySettings proxy, Properties props) {
        if (proxy == null) {
            throw new IllegalArgumentException("ProxySettings == null");
        }
        boolean http = proxy.getHttpUseProxy();
        if (http) {
            this.applySetting(props, "proxySet", "true");
            this.applySetting(props, "http.proxyHost", proxy.getHttpProxyServer());
            this.applySetting(props, "http.proxyPort", proxy.getHttpProxyPort());
            this.applySetting(props, "http.nonProxyHosts", proxy.getHttpNonProxyHosts());
            String user = proxy.getHttpProxyUser();
            String password = proxy.getHttpProxyPassword();
            if (password == null) {
                password = "";
            }
            if (user != null && user.length() > 0) {
                s_log.debug("Using HTTP proxy with security");
                Authenticator.setDefault(new MyAuthenticator(user, password));
            } else {
                s_log.debug("Using HTTP proxy without security");
                Authenticator.setDefault(null);
            }
        } else {
            s_log.debug("Not using HTTP proxy");
            props.remove("proxySet");
            props.remove("http.proxyHost");
            props.remove("http.proxyPort");
            props.remove("http.nonProxyHosts");
            Authenticator.setDefault(null);
        }
        boolean socks = proxy.getSocksUseProxy();
        if (socks) {
            this.applySetting(props, "socksProxyHost", proxy.getSocksProxyServer());
            this.applySetting(props, "socksProxyPort", proxy.getSocksProxyPort());
        } else {
            props.remove("socksProxyHost");
            props.remove("socksProxyPort");
        }
    }

    private void applySetting(Properties props, String key, String value) {
        if (value != null && value.length() > 0) {
            props.put(key, value);
        } else {
            props.remove(key);
        }
    }

    private static final class MyAuthenticator
    extends Authenticator {
        private final PasswordAuthentication _password;

        public MyAuthenticator(String user, String password) {
            this._password = new PasswordAuthentication(user, password.toCharArray());
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this._password;
        }
    }
}

