/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public abstract class ThemeConverter {
    private final String prefix;
    private final String suffix;
    private File skinDirectory;
    private File currentOutputDir;

    protected ThemeConverter(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public void setSkinDirectory(File directory) {
        this.skinDirectory = directory;
    }

    protected File getSkinDirectory() {
        return this.skinDirectory;
    }

    public void setCurrentOutputDirectory(File directory) {
        this.currentOutputDir = directory;
    }

    public File getCurrentOutputDirectory() {
        return this.currentOutputDir;
    }

    public void process() throws Exception {
        System.out.println("Processing GTK template");
        File gtkFolder = new File(this.skinDirectory, "gtk");
        gtkFolder.mkdirs();
        this.setCurrentOutputDirectory(gtkFolder);
        this.processTemplate(this.getClass().getResourceAsStream("gtkrc.template"), new FileOutputStream(new File(gtkFolder, "gtkrc")));
        System.out.println("Processing KDE template");
        File kdeFolder = new File(this.skinDirectory, "kde");
        kdeFolder.mkdirs();
        this.setCurrentOutputDirectory(kdeFolder);
        this.processTemplate(this.getClass().getResourceAsStream("kde.template"), new FileOutputStream(new File(kdeFolder, "kde.themerc")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplate(InputStream template, OutputStream output) throws Exception {
        PrintWriter out = new PrintWriter(output);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(template));
        try {
            String read;
            while ((read = reader.readLine()) != null) {
                out.println(this.parseLine(read));
            }
        }
        catch (Exception e) {
            System.err.println("Error at line:" + reader.getLineNumber());
            e.printStackTrace();
        }
        finally {
            out.flush();
        }
    }

    protected String parseLine(String line) throws Exception {
        int index = line.indexOf(this.prefix);
        if (index == -1) {
            return line;
        }
        int endIndex = line.indexOf(this.suffix, index + this.prefix.length());
        if (endIndex == -1) {
            throw new Exception("Tag not closed");
        }
        String tag = line.substring(index + this.prefix.length(), endIndex);
        return line.substring(0, index) + this.parseTag(tag) + this.parseLine(line.substring(endIndex + 1));
    }

    protected String parseTag(String tag) throws Exception {
        if (tag.startsWith("Image:")) {
            StringTokenizer token = new StringTokenizer(tag, ":#,|");
            token.nextToken();
            String path = token.hasMoreTokens() ? token.nextToken() : null;
            int index = token.hasMoreTokens() ? Integer.parseInt(token.nextToken()) : -1;
            int count = token.hasMoreTokens() ? Integer.parseInt(token.nextToken()) : -1;
            String output = token.hasMoreTokens() ? token.nextToken() : null;
            return this.handleImage(path, index, count, output);
        }
        if (tag.startsWith("Property:")) {
            StringTokenizer token = new StringTokenizer(tag, ":");
            token.nextToken();
            String prop = token.hasMoreTokens() ? token.nextToken() : null;
            return this.handleProperty(prop);
        }
        System.err.println("Found unknown tag: " + tag);
        return tag;
    }

    protected abstract String handleImage(String var1, int var2, int var3, String var4) throws Exception;

    protected abstract String handleProperty(String var1) throws Exception;

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "prefix=" + this.prefix + ",suffix=" + this.suffix + ",skinDirectory=" + this.skinDirectory;
    }
}

