/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.AbstractListIntelliHints;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;

public class ListDataIntelliHints
extends AbstractListIntelliHints {
    private boolean _caseSensitive = false;
    private List<?> _completionList;

    public ListDataIntelliHints(JTextComponent comp, List<?> completionList) {
        super(comp);
        this.setCompletionList(completionList);
    }

    public ListDataIntelliHints(JTextComponent comp, String[] completionList) {
        super(comp);
        this.setCompletionList(completionList);
    }

    public List<?> getCompletionList() {
        return this._completionList;
    }

    public void setCompletionList(List<?> completionList) {
        this._completionList = completionList;
    }

    public void setCompletionList(String[] completionList) {
        final String[] list = completionList;
        this._completionList = new AbstractList(){

            @Override
            public Object get(int index) {
                return list[index];
            }

            @Override
            public int size() {
                return list.length;
            }
        };
    }

    @Override
    public boolean updateHints(Object context) {
        if (context == null) {
            return false;
        }
        String s = context.toString();
        int substringLen = s.length();
        ArrayList<String> possibleStrings = new ArrayList<String>();
        for (Object o : this.getCompletionList()) {
            String listEntry = (String)o;
            if (substringLen > listEntry.length()) continue;
            if (!this.isCaseSensitive()) {
                if (!s.equalsIgnoreCase(listEntry.substring(0, substringLen))) continue;
                possibleStrings.add(listEntry);
                continue;
            }
            if (!listEntry.startsWith(s)) continue;
            possibleStrings.add(listEntry);
        }
        Object[] objects = possibleStrings.toArray();
        this.setListData(objects);
        return objects.length > 0;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }
}

