/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.vsnet.VsnetJideTabbedPaneUI;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class Eclipse3xJideTabbedPaneUI
extends VsnetJideTabbedPaneUI {
    protected int _closeButtonMargin;
    protected int _closeButtonMarginSize;
    protected int _iconMarginHorizon;
    protected int _iconMarginVertical;

    public static ComponentUI createUI(JComponent c) {
        return new Eclipse3xJideTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this._rectSizeExtend = 12;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this._tabPane, "JideTabbedPane.border");
        this._closeButtonMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMargin");
        this._closeButtonMarginSize = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginSize");
        this._iconMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.iconMarginHorizon");
        this._iconMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.iconMarginVertical");
    }

    @Override
    public void paintBackground(Graphics g, Component c) {
        if (this.getTabShape() == 7) {
            if (this._tabPane.isOpaque()) {
                int width = c.getWidth();
                int height = c.getHeight();
                int temp1 = -1;
                int temp2 = -1;
                if (this.isTabLeadingComponentVisible()) {
                    if (height < this._tabLeadingComponent.getSize().height) {
                        height = this._tabLeadingComponent.getSize().height;
                        temp1 = this._tabLeadingComponent.getSize().height;
                    }
                    if (width < this._tabLeadingComponent.getSize().width) {
                        width = this._tabLeadingComponent.getSize().width;
                        temp2 = this._tabLeadingComponent.getSize().width;
                    }
                }
                if (this.isTabTrailingComponentVisible()) {
                    if (height < this._tabTrailingComponent.getSize().height && temp1 < this._tabTrailingComponent.getSize().height) {
                        height = this._tabTrailingComponent.getSize().height;
                    }
                    if (width < this._tabTrailingComponent.getSize().width && temp2 < this._tabTrailingComponent.getSize().width) {
                        width = this._tabTrailingComponent.getSize().width;
                    }
                }
                g.setColor(this._background);
                g.fillRect(0, 0, width, height);
            }
        } else {
            super.paintBackground(g, c);
        }
    }

    @Override
    protected void ensureCurrentLayout() {
        if (!this._tabPane.isValid()) {
            BasicJideTabbedPaneUI.TabbedPaneLayout layout = (BasicJideTabbedPaneUI.TabbedPaneLayout)this._tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
        if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
            for (int i = 0; i < this._closeButtons.length; ++i) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (i != this._tabPane.getSelectedIndex()) {
                        this._closeButtons[i].setBounds(0, 0, 0, 0);
                        continue;
                    }
                } else if (i >= this._rects.length) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                if (!this._tabPane.isTabClosableAt(i)) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                Dimension size = this._closeButtons[i].getPreferredSize();
                Rectangle bounds = null;
                bounds = this._closeButtonAlignment == 11 ? (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3 ? new Rectangle(this._rects[i].x + this._rects[i].width - size.width - 16, this._rects[i].y + (this._rects[i].height - size.height >> 1), size.width, size.height) : (this._tabPane.getTabPlacement() == 2 ? new Rectangle(this._rects[i].x + (this._rects[i].width - size.width >> 1), this._rects[i].y + this._rects[i].height - size.height - 16, size.width, size.height) : new Rectangle(this._rects[i].x + (this._rects[i].width - size.width >> 1), this._rects[i].y + this._rects[i].height - size.height - 16, size.width, size.height))) : new Rectangle(this._rects[i].x + 4, this._rects[i].height - size.height >> 1, size.width, size.height);
                this._closeButtons[i].setIndex(i);
                if (!bounds.equals(this._closeButtons[i].getBounds())) {
                    this._closeButtons[i].setBounds(bounds);
                }
                if (this._tabPane.getSelectedIndex() == i) {
                    this._closeButtons[i].setBackground(this._selectedColor == null ? this._tabPane.getBackgroundAt(i) : this._selectedColor);
                    continue;
                }
                this._closeButtons[i].setBackground(this._tabPane.getBackgroundAt(i));
            }
        }
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex, Component c) {
        if (this.getTabShape() == 7) {
            int tabCount = this._tabPane.getTabCount();
            Rectangle iconRect = new Rectangle();
            Rectangle textRect = new Rectangle();
            Rectangle clipRect = g.getClipBounds();
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            if (this._tabPane.isOpaque()) {
                g.setColor(this._tabBackground);
                g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            }
            for (int i = this._runCount - 1; i >= 0; --i) {
                int start = this._tabRuns[i];
                int next = this._tabRuns[i == this._runCount - 1 ? 0 : i + 1];
                int end = next != 0 ? next - 1 : tabCount - 1;
                for (int j = start; j <= end; ++j) {
                    if (!this._rects[j].intersects(clipRect)) continue;
                    this.paintTab(g, tabPlacement, this._rects, j, iconRect, textRect);
                }
            }
            if (selectedIndex >= 0 && this.getRunForTab(tabCount, selectedIndex) == 0 && this._rects[selectedIndex].intersects(clipRect)) {
                this.paintTab(g, tabPlacement, this._rects, selectedIndex, iconRect, textRect);
            }
            if (this._tabPane.isOpaque()) {
                g.setColor(this._shadow);
                switch (tabPlacement) {
                    case 2: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g.fillRect(viewRect.x, viewRect.y + 3, 1, 2);
                            g.fillRect(viewRect.x + 1, viewRect.y + 2, 1, 1);
                            g.fillRect(viewRect.x + 2, viewRect.y + 1, 1, 1);
                            g.fillRect(viewRect.x + 3, viewRect.y, 2, 1);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g.fillRect(viewRect.x + 3, viewRect.y + viewRect.height - 1, 2, 1);
                            g.fillRect(viewRect.x + 2, viewRect.y + viewRect.height - 2, 1, 1);
                            g.fillRect(viewRect.x + 1, viewRect.y + viewRect.height - 3, 1, 1);
                            g.fillRect(viewRect.x, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        g.setColor(this._tabBackground);
                        g.fillRect(viewRect.x, viewRect.y, 3, 1);
                        g.fillRect(viewRect.x, viewRect.y + 1, 2, 1);
                        g.fillRect(viewRect.x, viewRect.y + 2, 1, 1);
                        break;
                    }
                    case 4: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g.fillRect(viewRect.x + viewRect.width - 5, viewRect.y, 2, 1);
                            g.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + 1, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + 2, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + 3, 1, 2);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g.fillRect(viewRect.x + viewRect.width - 5, viewRect.y + viewRect.height - 1, 2, 1);
                            g.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + viewRect.height - 2, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + viewRect.height - 3, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        g.setColor(this._tabBackground);
                        g.fillRect(viewRect.x + viewRect.width - 3, viewRect.y, 3, 1);
                        g.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + 1, 2, 1);
                        g.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + 2, 1, 1);
                        break;
                    }
                    case 3: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g.fillRect(viewRect.x + 3, viewRect.y + viewRect.height - 1, 2, 1);
                            g.fillRect(viewRect.x + 2, viewRect.y + viewRect.height - 2, 1, 1);
                            g.fillRect(viewRect.x + 1, viewRect.y + viewRect.height - 3, 1, 1);
                            g.fillRect(viewRect.x, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g.fillRect(viewRect.x + viewRect.width - 5, viewRect.y + viewRect.height - 1, 2, 1);
                            g.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + viewRect.height - 2, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + viewRect.height - 3, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + viewRect.height - 5, 1, 2);
                        }
                        g.setColor(this._tabBackground);
                        g.fillRect(viewRect.x, viewRect.y + viewRect.height - 1, 3, 1);
                        g.fillRect(viewRect.x, viewRect.y + viewRect.height - 2, 2, 1);
                        g.fillRect(viewRect.x, viewRect.y + viewRect.height - 3, 1, 1);
                        break;
                    }
                    default: {
                        if (!this.isTabLeadingComponentVisible()) {
                            g.fillRect(viewRect.x + 3, viewRect.y, 2, 1);
                            g.fillRect(viewRect.x + 2, viewRect.y + 1, 1, 1);
                            g.fillRect(viewRect.x + 1, viewRect.y + 2, 1, 1);
                            g.fillRect(viewRect.x, viewRect.y + 3, 1, 2);
                        }
                        if (this.isNoneTabTrailingComponentVisible()) {
                            g.fillRect(viewRect.x + viewRect.width - 5, viewRect.y, 2, 1);
                            g.fillRect(viewRect.x + viewRect.width - 3, viewRect.y + 1, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 2, viewRect.y + 2, 1, 1);
                            g.fillRect(viewRect.x + viewRect.width - 1, viewRect.y + 3, 1, 2);
                        }
                        g.setColor(this._tabBackground);
                        g.fillRect(viewRect.x, viewRect.y, 3, 1);
                        g.fillRect(viewRect.x, viewRect.y + 1, 2, 1);
                        g.fillRect(viewRect.x, viewRect.y + 2, 1, 1);
                    }
                }
            }
        } else {
            super.paintTabArea(g, tabPlacement, selectedIndex, c);
        }
    }

    private boolean isNoneTabTrailingComponentVisible() {
        return !this._tabScroller.scrollForwardButton.isVisible() && !this._tabScroller.scrollBackwardButton.isVisible() && !this._tabScroller.closeButton.isVisible() && !this.isTabTrailingComponentVisible();
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this._tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this._textIconGap);
        this._tabPane.putClientProperty("html", null);
        if (tabPlacement == 1 || tabPlacement == 3) {
            iconRect.x = tabRect.x + this._iconMarginHorizon;
            textRect.x = icon != null ? iconRect.x + iconRect.width + this._textIconGap : tabRect.x + this._textPadding;
            iconRect.width = Math.min(iconRect.width, tabRect.width - this._tabRectPadding);
            textRect.width = tabRect.width - this._tabRectPadding - iconRect.width - (icon != null ? this._textIconGap : this._noIconMargin);
            if (this.getTabResizeMode() == 2 || this._tabPane.getTabResizeMode() == 3) {
                textRect.width -= 10;
                if (this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
                    if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                        if (isSelected) {
                            textRect.width -= this._closeButtons[tabIndex].getPreferredSize().width;
                        }
                    } else {
                        textRect.width -= this._closeButtons[tabIndex].getPreferredSize().width;
                    }
                }
            } else if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.width = iconRect.width + this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonMarginSize;
                textRect.width = 0;
            }
        } else {
            iconRect.y = tabRect.y + this._iconMarginVertical;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 3;
            textRect.x = tabRect.x + 3;
            textRect.width = tabRect.width - this._textMarginVertical;
            textRect.height = tabRect.height - this._tabRectPadding - iconRect.height - (icon != null ? this._textIconGap : this._noIconMargin);
            if (this.getTabResizeMode() == 2 || this._tabPane.getTabResizeMode() == 3) {
                textRect.height -= 10;
                if (this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
                    if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                        if (isSelected) {
                            textRect.height -= this._closeButtons[tabIndex].getPreferredSize().height;
                        }
                    } else {
                        textRect.height -= this._closeButtons[tabIndex].getPreferredSize().height;
                    }
                }
            } else if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.height = iconRect.height + this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonMarginSize;
                textRect.height = 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.getTabShape() == 7) {
            g.setColor(this._lightHighlight);
            boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
            switch (tabPlacement) {
                case 2: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --y;
                    }
                    if (isSelected) {
                        g.setColor(this._shadow);
                        g.drawLine(x + 5, y, x + w - 1, y);
                        g.drawLine(x + 4, y + 1, x + 3, y + 1);
                        g.drawLine(x + 2, y + 2, x + 2, y + 2);
                        g.drawLine(x + 1, y + 3, x + 1, y + 3);
                        g.drawLine(x, y + 4, x, y + 5);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g.drawLine(x, y + 5, x, y + h - 21);
                        }
                        g.drawLine(x, y + h - 21, x, y + h - 19);
                        g.drawLine(x + 1, y + h - 18, x + 1, y + h - 16);
                        g.drawLine(x + 2, y + h - 15, x + 2, y + h - 14);
                        g.drawLine(x + 3, y + h - 13, x + 3, y + h - 13);
                        g.drawLine(x + 4, y + h - 12, x + 4, y + h - 11);
                        for (int i = 0; i < w - 10; ++i) {
                            g.drawLine(x + 5 + i, y + h - 10 + i, x + 5 + i, y + h - 10 + i);
                        }
                        g.drawLine(x + w - 5, y + h + w - 20, x + w - 5, y + h + w - 19);
                        g.drawLine(x + w - 4, y + h + w - 18, x + w - 4, y + h + w - 18);
                        g.drawLine(x + w - 3, y + h + w - 17, x + w - 3, y + h + w - 16);
                        g.drawLine(x + w - 2, y + h + w - 15, x + w - 2, y + h + w - 13);
                        g.drawLine(x + w - 1, y + h + w - 12, x + w - 1, y + h + w - 10);
                        if (this.isTabLeadingComponentVisible()) return;
                        ++y;
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._shadow);
                        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g.setColor(this._shadow);
                    g.drawLine(x, y - 1, x + w - 1, y - 1);
                    return;
                }
                case 4: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --y;
                    }
                    if (isSelected) {
                        g.setColor(this._shadow);
                        g.drawLine(x, y, x + w - 6, y);
                        g.drawLine(x + w - 5, y + 1, x + w - 4, y + 1);
                        g.drawLine(x + w - 3, y + 2, x + w - 3, y + 2);
                        g.drawLine(x + w - 2, y + 3, x + w - 2, y + 3);
                        g.drawLine(x + w - 1, y + 4, x + w - 1, y + 5);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g.drawLine(x + w - 1, y + 5, x + w - 1, y + h - 21);
                        }
                        g.drawLine(x + w - 1, y + h - 21, x + w - 1, y + h - 19);
                        g.drawLine(x + w - 2, y + h - 18, x + w - 2, y + h - 16);
                        g.drawLine(x + w - 3, y + h - 15, x + w - 3, y + h - 14);
                        g.drawLine(x + w - 4, y + h - 13, x + w - 4, y + h - 13);
                        g.drawLine(x + w - 5, y + h - 12, x + w - 5, y + h - 11);
                        for (int i = 0; i < w - 10; ++i) {
                            g.drawLine(x + w - 6 - i, y + h - 10 + i, x + w - 6 - i, y + h - 10 + i);
                        }
                        g.drawLine(x + 4, y + h + w - 20, x + 4, y + h + w - 19);
                        g.drawLine(x + 3, y + h + w - 18, x + 3, y + h + w - 18);
                        g.drawLine(x + 2, y + h + w - 17, x + 2, y + h + w - 16);
                        g.drawLine(x + 1, y + h + w - 15, x + 1, y + h + w - 13);
                        g.drawLine(x, y + h + w - 12, x, y + h + w - 10);
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._shadow);
                        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g.setColor(this._shadow);
                    g.drawLine(x, y - 1, x + w - 1, y - 1);
                    return;
                }
                case 3: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --x;
                    }
                    if (isSelected) {
                        g.setColor(this._shadow);
                        g.drawLine(x, y + h - 6, x, y);
                        g.drawLine(x + 1, y + h - 5, x + 1, y + h - 4);
                        g.drawLine(x + 2, y + h - 3, x + 2, y + h - 3);
                        g.drawLine(x + 3, y + h - 2, x + 3, y + h - 2);
                        g.drawLine(x + 4, y + h - 1, x + 5, y + h - 1);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g.drawLine(x + 5, y + h - 1, x + w - 20, y + h - 1);
                        }
                        g.drawLine(x + w - 20, y + h - 1, x + w - 18, y + h - 1);
                        g.drawLine(x + w - 17, y + h - 2, x + w - 15, y + h - 2);
                        g.drawLine(x + w - 14, y + h - 3, x + w - 13, y + h - 3);
                        g.drawLine(x + w - 12, y + h - 4, x + w - 12, y + h - 4);
                        g.drawLine(x + w - 11, y + h - 5, x + w - 10, y + h - 5);
                        for (int i = 0; i < h - 10; ++i) {
                            g.drawLine(x + w - 9 + i, y + h - 6 - i, x + w - 9 + i, y + h - 6 - i);
                        }
                        g.drawLine(x + w + h - 19, y + 4, x + w + h - 18, y + 4);
                        g.drawLine(x + w + h - 17, y + 3, x + w + h - 17, y + 3);
                        g.drawLine(x + w + h - 16, y + 2, x + w + h - 15, y + 2);
                        g.drawLine(x + w + h - 14, y + 1, x + w + h - 12, y + 1);
                        g.drawLine(x + w + h - 11, y, x + w + h - 9, y);
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._shadow);
                        if (leftToRight) {
                            g.drawLine(x + w - 2, y - 1, x + w - 2, y + h);
                            return;
                        }
                        g.drawLine(x, y - 1, x, y + h);
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g.setColor(this._shadow);
                    if (leftToRight) {
                        g.drawLine(x, y - 1, x, y + h);
                        return;
                    }
                    g.drawLine(x + w - 2, y - 1, x + w - 2, y + h);
                    return;
                }
                default: {
                    if (!this.isTabLeadingComponentVisible()) {
                        --x;
                    }
                    if (isSelected) {
                        g.setColor(this._shadow);
                        g.drawLine(x, y + 5, x, y + h);
                        g.drawLine(x + 4, y, x + 5, y);
                        g.drawLine(x + 3, y + 1, x + 3, y + 1);
                        g.drawLine(x + 2, y + 2, x + 2, y + 2);
                        g.drawLine(x + 1, y + 3, x + 1, y + 4);
                        if (this.isTabTopVisible(tabPlacement)) {
                            g.drawLine(x + 5, y, x + w - 20, y);
                        }
                        g.drawLine(x + w - 20, y, x + w - 18, y);
                        g.drawLine(x + w - 17, y + 1, x + w - 15, y + 1);
                        g.drawLine(x + w - 14, y + 2, x + w - 13, y + 2);
                        g.drawLine(x + w - 12, y + 3, x + w - 12, y + 3);
                        g.drawLine(x + w - 11, y + 4, x + w - 10, y + 4);
                        for (int i = 0; i < h - 10; ++i) {
                            g.drawLine(x + w - 9 + i, y + 5 + i, x + w - 9 + i, y + 5 + i);
                        }
                        g.drawLine(x + w + h - 19, y + h - 5, x + w + h - 18, y + h - 5);
                        g.drawLine(x + w + h - 17, y + h - 4, x + w + h - 17, y + h - 4);
                        g.drawLine(x + w + h - 16, y + h - 3, x + w + h - 15, y + h - 3);
                        g.drawLine(x + w + h - 14, y + h - 2, x + w + h - 12, y + h - 2);
                        g.drawLine(x + w + h - 11, y + h - 1, x + w + h - 9, y + h - 1);
                        return;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g.setColor(this._shadow);
                        if (leftToRight) {
                            g.drawLine(x + w - 2, y, x + w - 2, y + (h - 1));
                            return;
                        }
                        g.drawLine(x, y, x, y + (h - 1));
                        return;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) return;
                    if (tabIndex == 0) return;
                    g.setColor(this._shadow);
                    if (leftToRight) {
                        g.drawLine(x, y, x, y + (h - 1));
                        return;
                    }
                    g.drawLine(x + w - 2, y, x + w - 2, y + (h - 1));
                }
            }
            return;
        } else {
            super.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        if (this.getTabShape() == 7) {
            Color background2;
            Color background1;
            Graphics2D g2d = (Graphics2D)g;
            if (this.showFocusIndicator()) {
                background1 = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
                background2 = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2");
            } else {
                background1 = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
                background2 = this._background;
            }
            switch (tabPlacement) {
                case 2: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{x + w, x + 5, x, x, x + 6, x + w - 6, x + w};
                    int[] yp = new int[]{--y, y, y + 4, y + h - 19, y + h - 8, y + h + w - 21, y + h + w - 10};
                    int np = yp.length;
                    Polygon p = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p, background1, background2, false);
                    break;
                }
                case 4: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{x, x + w - 6, x + w, x + w, x + w - 5, x + 5, x};
                    int[] yp = new int[]{--y, y, y + 4, y + h - 21, y + h - 10, y + h + w - 21, y + h + w - 10};
                    int np = yp.length;
                    Polygon p = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p, background2, background1, false);
                    break;
                }
                case 3: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{--x, x, x + 6, x + w - 20, x + w - 16, x + w - 14, x + w - 12, x + w - 9, x + w + h - 19, x + w + h - 10, x + w + h - 12};
                    int[] yp = new int[]{y, y + h - 6, y + h, y + h, y + h - 2, y + h - 3, y + h - 4, y + h - 6, y + 4, y + 1, y};
                    int np = yp.length;
                    Polygon p = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p, background2, background1, true);
                    break;
                }
                default: {
                    if (!this.isTabLeadingComponentVisible()) {
                        // empty if block
                    }
                    int[] xp = new int[]{--x, x, x + 2, x + 3, x + 6, x + w - 20, x + w - 14, x + w - 12, x + w - 9, x + w + h - 20, x + w + h - 9};
                    int[] yp = new int[]{y + h, y + 5, y + 2, y + 1, y, y, y + 2, y + 3, y + 5, y + h - 6, y + h};
                    int np = xp.length;
                    Polygon p = new Polygon(xp, yp, np);
                    JideSwingUtilities.fillGradient(g2d, p, background1, background2, true);
                    break;
                }
            }
        } else {
            super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.getTabShape() == 7) {
            int width = this._tabPane.getWidth();
            int height = this._tabPane.getHeight();
            Insets insets = this._tabPane.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = width - insets.right - insets.left;
            int h = height - insets.top - insets.bottom;
            int temp = -1;
            switch (tabPlacement) {
                case 2: {
                    x += this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                    if (this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getSize().width > this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth)) {
                        x = insets.left + this._tabLeadingComponent.getSize().width;
                        temp = this._tabLeadingComponent.getSize().width;
                    }
                    if (this.isTabTrailingComponentVisible() && this._maxTabWidth < this._tabTrailingComponent.getSize().width && temp < this._tabTrailingComponent.getSize().width) {
                        x = insets.left + this._tabTrailingComponent.getSize().width;
                    }
                    w -= x - insets.left;
                    break;
                }
                case 4: {
                    w -= this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                    break;
                }
                case 3: {
                    h -= this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                    break;
                }
                default: {
                    y += this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                    if (this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getSize().height > this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight)) {
                        y = insets.top + this._tabLeadingComponent.getSize().height;
                        temp = this._tabLeadingComponent.getSize().height;
                    }
                    if (this.isTabTrailingComponentVisible() && this._maxTabHeight < this._tabTrailingComponent.getSize().height && temp < this._tabTrailingComponent.getSize().height) {
                        y = insets.top + this._tabTrailingComponent.getSize().height;
                    }
                    h -= y - insets.top;
                }
            }
            this.paintContentBorder(g, x, y, w, h);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r = this._rects[selectedIndex];
            Rectangle button = this._tabScroller.scrollForwardButton.getBounds();
            Rectangle panel = this._tabScroller.tabPanel.getBounds();
            int lsize = 0;
            if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                if (this.isTabLeadingComponentVisible()) {
                    lsize = this._tabLeadingComponent.getSize().width;
                }
            } else if (this.isTabLeadingComponentVisible()) {
                lsize = this._tabLeadingComponent.getSize().height;
            }
            switch (tabPlacement) {
                case 2: {
                    if (r.y < viewRect.y + viewRect.height && r.y + r.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 > viewRect.y + viewRect.height) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.y += r.y + r.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.y + panel.height + lsize > button.y) {
                            viewRect.y += r.y + r.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width, viewRect.height + this.getLayoutSize());
                        }
                    }
                    this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                    break;
                }
                case 4: {
                    if (r.y < viewRect.y + viewRect.height && r.y + r.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 > viewRect.y + viewRect.height) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.y += r.y + r.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.y + panel.height + lsize > button.y) {
                            viewRect.y += r.y + r.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9 - (viewRect.y + viewRect.height);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width, viewRect.height + this.getLayoutSize());
                        }
                    }
                    this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                    break;
                }
                case 3: {
                    if (r.x < viewRect.x + viewRect.width && r.x + r.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 > viewRect.x + viewRect.width) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.x += r.x + r.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.x + panel.width + lsize > button.x) {
                            viewRect.x += r.x + r.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width + this.getLayoutSize(), viewRect.height);
                        }
                    }
                    this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                    break;
                }
                default: {
                    if (r.x < viewRect.x + viewRect.width && r.x + r.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 > viewRect.x + viewRect.width) {
                        if (selectedIndex != this._tabPane.getTabCount() - 1) {
                            viewRect.x += r.x + r.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else if (panel.x + panel.width + lsize > button.x) {
                            viewRect.x += r.x + r.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9 - (viewRect.x + viewRect.width);
                            this._tabScroller.viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                        } else {
                            this._tabScroller.viewport.setSize(viewRect.width + this.getLayoutSize(), viewRect.height);
                        }
                    }
                    this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                }
            }
            g.setColor(this._shadow);
            if (this._tabPane.isTabShown()) {
                switch (tabPlacement) {
                    case 2: {
                        g.drawLine(width - 1, 0, width - 1, height - 1);
                        g.drawLine(6, 0, width - 1, 0);
                        g.drawLine(6, height - 1, width - 1, height - 1);
                        g.drawLine(0, 6, 0, height - 7);
                        g.drawLine(1, height - 6, 1, height - 5);
                        g.drawLine(2, height - 4, 2, height - 4);
                        g.drawLine(3, height - 3, 3, height - 3);
                        g.drawLine(4, height - 2, 5, height - 2);
                        g.drawLine(4, 1, 5, 1);
                        g.drawLine(3, 2, 3, 2);
                        g.drawLine(2, 3, 2, 3);
                        g.drawLine(1, 4, 1, 5);
                        break;
                    }
                    case 4: {
                        g.drawLine(0, 0, 0, height - 1);
                        g.drawLine(0, 0, width - 7, 0);
                        g.drawLine(0, height - 1, width - 7, height - 1);
                        g.drawLine(width - 1, 6, width - 1, height - 7);
                        g.drawLine(width - 2, height - 6, width - 2, height - 5);
                        g.drawLine(width - 3, height - 4, width - 3, height - 4);
                        g.drawLine(width - 4, height - 3, width - 4, height - 3);
                        g.drawLine(width - 5, height - 2, width - 6, height - 2);
                        g.drawLine(width - 6, 1, width - 5, 1);
                        g.drawLine(width - 4, 2, width - 4, 2);
                        g.drawLine(width - 3, 3, width - 3, 3);
                        g.drawLine(width - 2, 4, width - 2, 5);
                        break;
                    }
                    case 3: {
                        g.drawLine(0, 0, width - 1, 0);
                        g.drawLine(0, 0, 0, height - 7);
                        g.drawLine(width - 1, 0, width - 1, height - 7);
                        g.drawLine(6, height - 1, width - 7, height - 1);
                        g.drawLine(width - 6, height - 2, width - 5, height - 2);
                        g.drawLine(width - 4, height - 3, width - 4, height - 3);
                        g.drawLine(width - 3, height - 4, width - 3, height - 4);
                        g.drawLine(width - 2, height - 5, width - 2, height - 6);
                        g.drawLine(1, height - 6, 1, height - 5);
                        g.drawLine(2, height - 4, 2, height - 4);
                        g.drawLine(3, height - 3, 3, height - 3);
                        g.drawLine(4, height - 2, 5, height - 2);
                        break;
                    }
                    default: {
                        g.drawLine(6, 0, width - 7, 0);
                        g.drawLine(0, height - 1, width - 1, height - 1);
                        g.drawLine(width - 1, 6, width - 1, height - 1);
                        g.drawLine(0, 6, 0, height - 1);
                        g.drawLine(width - 6, 1, width - 5, 1);
                        g.drawLine(width - 4, 2, width - 4, 2);
                        g.drawLine(width - 3, 3, width - 3, 3);
                        g.drawLine(width - 2, 4, width - 2, 5);
                        g.drawLine(4, 1, 5, 1);
                        g.drawLine(3, 2, 3, 2);
                        g.drawLine(2, 3, 2, 3);
                        g.drawLine(1, 4, 1, 5);
                        break;
                    }
                }
            } else {
                g.drawRect(0, 0, width - 1, height - 1);
            }
        } else {
            super.paintContentBorder(g, tabPlacement, selectedIndex);
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int x, int y, int w, int h) {
        if (this.getTabShape() == 7) {
            if (this.showFocusIndicator()) {
                Insets insets = this.getContentBorderInsets(this._tabPane.getTabPlacement());
                Color selectedTitleColor2 = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground2");
                g.setColor(selectedTitleColor2);
                g.fillRect(x, y, w, insets.top);
                g.fillRect(x, y, insets.left, h);
                g.fillRect(x, y + h - insets.bottom, w, insets.bottom);
                g.fillRect(x + w - insets.right, y, insets.right, h);
            }
        } else {
            super.paintContentBorder(g, x, y, w, h);
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r = this._rects[selectedIndex];
            g.setColor(this.getPainter().getControlShadow());
            if (this.isTabLeadingComponentVisible() && selRect.x > 0) {
                g.drawLine(x, y, selRect.x, y);
            }
            if (r.x > viewRect.x) {
                g.drawLine(x, y, selRect.x - 1, y);
            }
            if (this._tabPane.isTabShown()) {
                if (r.x >= viewRect.x + viewRect.width) {
                    g.drawLine(x, y, x + w - 1, y);
                } else {
                    g.drawLine(selRect.x + selRect.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9, y, x + w - 1, y);
                }
            }
        } else {
            super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            g.setColor(this.getPainter().getControlShadow());
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r = this._rects[selectedIndex];
            if (this.isTabLeadingComponentVisible() && selRect.x > 0) {
                g.drawLine(x, y + h - 1, selRect.x, y + h - 1);
            }
            if (r.x > viewRect.x) {
                g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            }
            if (this._tabPane.isTabShown()) {
                if (r.x >= viewRect.x + viewRect.width) {
                    g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
                } else {
                    g.drawLine(selRect.x + selRect.width + this._tabPane.getBoundsAt((int)selectedIndex).height - 9, y + h - 1, x + w - 1, y + h - 1);
                }
            }
        } else {
            super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r = this._rects[selectedIndex];
            g.setColor(this.getPainter().getControlShadow());
            if (this.isTabLeadingComponentVisible() && selRect.y > 0) {
                g.drawLine(x, y, x, selRect.y);
            }
            if (r.y - 2 > viewRect.y) {
                g.drawLine(x, y, x, selRect.y - 3);
            }
            if (this._tabPane.isTabShown()) {
                if (r.y >= viewRect.y + viewRect.height) {
                    g.drawLine(x, y, x, y + h - 1);
                } else {
                    g.drawLine(x, selRect.y + selRect.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9, x, y + h - 1);
                }
            }
        } else {
            super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (selectedIndex < 0) {
            return;
        }
        if (this.getTabShape() == 7) {
            Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
            Rectangle viewRect = this._tabScroller.viewport.getViewRect();
            Rectangle r = this._rects[selectedIndex];
            g.setColor(this.getPainter().getControlShadow());
            if (this.isTabLeadingComponentVisible() && selRect.y > 0) {
                g.drawLine(x + w - 1, y, x + w - 1, selRect.y);
            }
            if (r.y - 2 > viewRect.y) {
                g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 3);
            }
            if (this._tabPane.isTabShown()) {
                if (r.y >= viewRect.y + viewRect.height) {
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                } else {
                    g.drawLine(x + w - 1, selRect.y + selRect.height + this._tabPane.getBoundsAt((int)selectedIndex).width - 9, x + w - 1, y + h - 1);
                }
            }
        } else {
            super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    @Override
    protected Rectangle getTabsTextBoundsAt(int tabIndex) {
        Rectangle tabRect = this._tabPane.getBoundsAt(tabIndex);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String title = this._tabPane.getDisplayTitleAt(tabIndex);
        Icon icon = this._tabPane.getIconForTab(tabIndex);
        SwingUtilities.layoutCompoundLabel(this._tabPane, this._tabPane.getGraphics().getFontMetrics(this._tabPane.getFont()), title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, icon == null ? 0 : this._textIconGap);
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            iconRect.x = tabRect.x + this._iconMarginHorizon;
            textRect.x = icon != null ? iconRect.x + iconRect.width + this._textIconGap : tabRect.x + this._textPadding;
        } else {
            iconRect.y = tabRect.y + this._iconMarginVertical;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 2;
            textRect.x = tabRect.x + 2;
        }
        return textRect;
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (this._tabPane.hasFocus() && isSelected) {
            int h;
            int w;
            int y;
            int x;
            g.setColor(this._focus);
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 4;
                    h = tabRect.height - 19;
                    break;
                }
                case 4: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 4;
                    h = tabRect.height - 19;
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 19;
                    h = tabRect.height - 3;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 19;
                    h = tabRect.height - 3;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    @Override
    protected BasicJideTabbedPaneUI.TabCloseButton createNoFocusButton(int type) {
        return new Eclipse3xTabCloseButton(type);
    }

    public class Eclipse3xTabCloseButton
    extends BasicJideTabbedPaneUI.TabCloseButton {
        public Eclipse3xTabCloseButton(int type) {
            super(type);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            g.setColor(UIDefaultsLookup.getColor("controlShadow").darker());
            int centerX = this.getWidth() >> 1;
            int centerY = this.getHeight() >> 1;
            switch (this.getType()) {
                case 0: {
                    g.drawLine(centerX - 4, centerY - 4, centerX - 2, centerY - 4);
                    g.drawLine(centerX - 4, centerY - 4, centerX - 4, centerY - 2);
                    g.drawLine(centerX - 1, centerY - 3, centerX - 0, centerY - 2);
                    g.drawLine(centerX - 3, centerY - 1, centerX - 2, centerY - 0);
                    g.drawLine(centerX + 3, centerY - 4, centerX + 5, centerY - 4);
                    g.drawLine(centerX + 5, centerY - 4, centerX + 5, centerY - 2);
                    g.drawLine(centerX + 2, centerY - 3, centerX + 1, centerY - 2);
                    g.drawLine(centerX + 4, centerY - 1, centerX + 3, centerY - 0);
                    g.drawLine(centerX - 4, centerY + 5, centerX - 2, centerY + 5);
                    g.drawLine(centerX - 4, centerY + 5, centerX - 4, centerY + 3);
                    g.drawLine(centerX - 1, centerY + 4, centerX - 0, centerY + 3);
                    g.drawLine(centerX - 3, centerY + 2, centerX - 2, centerY + 1);
                    g.drawLine(centerX + 3, centerY + 5, centerX + 5, centerY + 5);
                    g.drawLine(centerX + 5, centerY + 5, centerX + 5, centerY + 3);
                    g.drawLine(centerX + 2, centerY + 4, centerX + 1, centerY + 3);
                    g.drawLine(centerX + 4, centerY + 2, centerX + 3, centerY + 1);
                    if (this.isMouseOver()) {
                        g.setColor(new Color(252, 160, 160));
                    } else {
                        g.setColor(Color.WHITE);
                    }
                    g.drawLine(centerX - 2, centerY - 3, centerX + 4, centerY + 3);
                    g.drawLine(centerX - 3, centerY - 3, centerX + 4, centerY + 4);
                    g.drawLine(centerX - 3, centerY - 2, centerX + 3, centerY + 4);
                    g.drawLine(centerX - 3, centerY + 3, centerX + 3, centerY - 3);
                    g.drawLine(centerX - 3, centerY + 4, centerX + 4, centerY - 3);
                    g.drawLine(centerX - 2, centerY + 4, centerX + 4, centerY - 2);
                    break;
                }
                default: {
                    super.paintComponent(g);
                }
            }
        }
    }
}

