/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.AbstractButton;
import net.sourceforge.napkinlaf.NapkinThemeColor;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.util.NapkinIcon;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public abstract class AbstractNapkinIcon
implements NapkinIcon {
    protected Shape place;
    protected Shape mark;
    private final NapkinThemeColor markColor;
    private final AffineTransform scaleMat;
    private int width;
    private int height;
    protected AbstractDrawnGenerator placeGen;
    protected AbstractDrawnGenerator markGen;

    public AbstractNapkinIcon(NapkinThemeColor markColor, AffineTransform scale) {
        this.markColor = markColor;
        this.scaleMat = scale;
    }

    protected void init() {
        try {
            this.markGen = this.createMarkGenerator();
            this.placeGen = this.createPlaceGenerator();
            this.width = this.calcWidth();
            this.height = this.calcHeight();
        }
        catch (StackOverflowError e) {
            Thread.dumpStack();
            throw e;
        }
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component c, Graphics g1, int x, int y) {
        if (this.place == null) {
            this.place = this.placeGen.generate(this.scaleMat);
        }
        boolean useMark = this.shouldUseMark(c);
        Graphics2D placeG = NapkinUtil.copy(g1);
        Graphics2D markG = null;
        if (!useMark) {
            this.mark = null;
        } else {
            if (this.markGen != null && this.mark == null) {
                this.mark = this.markGen.generate(this.scaleMat);
            }
            markG = NapkinUtil.lineGraphics(g1, 2.5f);
            markG.setColor(NapkinUtil.currentTheme(c).getColor(this.markColor));
        }
        placeG.setColor(c.getForeground());
        this.doPaint(placeG, markG, x, y);
    }

    protected boolean shouldUseMark(Component c) {
        return c instanceof AbstractButton && ((AbstractButton)c).isSelected();
    }

    protected void doPaint(Graphics2D placeG, Graphics2D markG, int x, int y) {
        if (markG != null) {
            markG.translate(x, y);
            markG.fill(this.mark);
        }
        placeG.translate(x, y);
        placeG.draw(this.place);
    }

    protected abstract int calcWidth();

    protected abstract int calcHeight();

    protected abstract AbstractDrawnGenerator createPlaceGenerator();

    protected abstract AbstractDrawnGenerator createMarkGenerator();
}

