/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.fife.ui.EscapableDialog;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;

public class ExceptionDialog
extends EscapableDialog
implements ActionListener {
    private SelectableLabel descArea;
    private DetailsButton detailsButton;
    private JPanel textPanel;
    private String desc;
    private static final int MIN_HEIGHT = 150;
    private static final int MAX_WIDTH = 600;
    private static final String TRACE_STEP_BEGINNING = "    at ";
    private static final String MSG = "org.fife.ui.app.ExceptionDialog";

    public ExceptionDialog(Frame owner, Throwable t) {
        super(owner);
        this.init(t);
    }

    public ExceptionDialog(Dialog owner, Throwable t) {
        super(owner);
        this.init(t);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("ToggleDetails".equals(command)) {
            this.detailsButton.toggleCollapsed();
            this.detailsButton.repaint();
            JPanel cp = (JPanel)this.getContentPane();
            Dimension d = null;
            if (this.textPanel.getParent() == null) {
                cp.add(this.textPanel);
                d = new Dimension(cp.getSize().width, 350);
            } else {
                cp.remove(this.textPanel);
                int w = cp.getSize().width;
                cp.setPreferredSize(null);
                d = new Dimension(w, cp.getPreferredSize().height);
            }
            cp.setPreferredSize(d);
            this.pack();
        }
    }

    protected JTextComponent createTextComponent() {
        return new JTextArea(12, 25);
    }

    private static final String getStackTraceText(Throwable t) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(t.toString()).append("\n");
        StackTraceElement[] ste = t.getStackTrace();
        int count = ste.length;
        for (int i = 0; i < count; ++i) {
            buffer.append(TRACE_STEP_BEGINNING).append(ste[i].toString()).append("\n");
        }
        return buffer.toString();
    }

    private void init(Throwable t) {
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.setTitle(msg.getString("Title"));
        ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JPanel topPanel = new JPanel(new BorderLayout());
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        if (icon != null) {
            JLabel iconLabel = new JLabel(icon);
            topPanel.add((Component)iconLabel, "Before");
        }
        this.descArea = new SelectableLabel();
        String descFormat = msg.getString("DescriptionFormat");
        this.desc = t.getMessage();
        if (this.desc == null) {
            this.desc = t.toString();
        }
        this.desc = MessageFormat.format(descFormat, this.desc);
        this.setDescription(this.desc);
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        temp2.add(this.descArea);
        topPanel.add(temp2);
        this.detailsButton = new DetailsButton(msg.getString("Details"));
        this.detailsButton.setActionCommand("ToggleDetails");
        this.detailsButton.addActionListener(this);
        topPanel.setBorder(UIUtil.getEmpty5Border());
        contentPane.add((Component)topPanel, "North");
        JTextComponent textArea = this.createTextComponent();
        String stackTraceText = ExceptionDialog.getStackTraceText(t);
        while (t.getCause() != null) {
            t = t.getCause();
            stackTraceText = stackTraceText + "Caused by: " + ExceptionDialog.getStackTraceText(t);
        }
        try {
            textArea.setText(stackTraceText);
        }
        catch (Throwable t2) {
            textArea = new JTextArea(15, 50);
            textArea.setText(stackTraceText);
        }
        textArea.setCaretPosition(0);
        textArea.setEditable(false);
        this.textPanel = new JPanel(new BorderLayout());
        this.textPanel.setBorder(UIUtil.getEmpty5Border());
        this.textPanel.add(new RScrollPane(textArea));
        JButton okButton = new JButton(msg.getString("Close"));
        okButton.setMnemonic(msg.getString("CloseMnemonic").charAt(0));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.setVisible(false);
            }
        });
        Container buttons = UIUtil.createButtonFooter(okButton, this.detailsButton);
        contentPane.add((Component)buttons, "South");
        this.setContentPane(contentPane);
        this.getRootPane().setDefaultButton(okButton);
        this.applyComponentOrientation(orientation);
        this.pack();
        this.setModal(true);
    }

    public void pack() {
        super.pack();
        if (this.getWidth() > 600 && this.getHeight() < 200) {
            this.setSize(600, 200);
        }
        if (this.getHeight() < 150) {
            this.setSize(this.getWidth(), 150);
        }
    }

    public void setDescription(String desc) {
        this.descArea.setText(desc);
        this.descArea.firePropertyChange("wrapStyleWord", false, true);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setPreferredSize(null);
        this.pack();
    }

    private static class DetailsButton
    extends JButton {
        private String mainText;
        private boolean collapsed;

        public DetailsButton(String text) {
            this.mainText = text;
            this.setCollapsed(true);
        }

        public void setCollapsed(boolean collapsed) {
            this.collapsed = collapsed;
            String text = null;
            ComponentOrientation o = this.getComponentOrientation();
            text = collapsed ? (o.isLeftToRight() ? this.mainText + " >>" : this.mainText + " <<") : (o.isLeftToRight() ? this.mainText + " <<" : this.mainText + " >>");
            this.setText(text);
        }

        public void toggleCollapsed() {
            this.setCollapsed(!this.collapsed);
        }
    }
}

