/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import org.fife.help.HelpDialog;
import org.fife.ui.CustomizableToolBar;
import org.fife.ui.StatusBar;
import org.fife.ui.app.GUIApplicationConstants;
import org.fife.ui.app.GUIApplicationPreferences;
import org.fife.ui.app.StandardAction;

public interface GUIApplication
extends GUIApplicationConstants {
    public void addAction(String var1, Action var2);

    public void displayException(Throwable var1);

    public void displayException(Dialog var1, Throwable var2);

    public void displayException(Frame var1, Throwable var2);

    public void doExit();

    public JDialog getAboutDialog();

    public Action getAction(String var1);

    public SortedSet getActionKeys();

    public Action[] getActions();

    public HelpDialog getHelpDialog();

    public Image getIconImage();

    public String getInstallLocation();

    public JMenuBar getJMenuBar();

    public String getLanguage();

    public int getOS();

    public ResourceBundle getResourceBundle();

    public StatusBar getStatusBar();

    public boolean getStatusBarVisible();

    public CustomizableToolBar getToolBar();

    public boolean getToolBarVisible();

    public String getVersionString();

    public boolean isMaximized();

    public GUIApplicationPreferences loadPreferences();

    public void pack();

    public void setJMenuBar(JMenuBar var1);

    public void setLanguage(String var1);

    public void setStatusBar(StatusBar var1);

    public void setStatusBarVisible(boolean var1);

    public void setToolBar(CustomizableToolBar var1);

    public void setToolBarVisible(boolean var1);

    public static class ToggleToolBarAction
    extends StandardAction {
        private static final long serialVersionUID = 1L;

        public ToggleToolBarAction(GUIApplication app, String nameKey) {
            super(app, nameKey);
        }

        public ToggleToolBarAction(GUIApplication app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public ToggleToolBarAction(GUIApplication app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        public void actionPerformed(ActionEvent e) {
            GUIApplication app;
            app.setToolBarVisible(!(app = this.getApplication()).getToolBarVisible());
        }
    }

    public static class ToggleStatusBarAction
    extends StandardAction {
        private static final long serialVersionUID = 1L;

        public ToggleStatusBarAction(GUIApplication app, String nameKey) {
            super(app, nameKey);
        }

        public ToggleStatusBarAction(GUIApplication app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public ToggleStatusBarAction(GUIApplication app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        public void actionPerformed(ActionEvent e) {
            GUIApplication app;
            app.setStatusBarVisible(!(app = this.getApplication()).getStatusBarVisible());
        }
    }

    public static class HelpAction
    extends StandardAction {
        private static final long serialVersionUID = 1L;

        public HelpAction(GUIApplication app, String nameKey) {
            super(app, nameKey);
        }

        public HelpAction(GUIApplication app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public HelpAction(GUIApplication app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            GUIApplication app = this.getApplication();
            if (app instanceof Component) {
                ((Component)((Object)app)).setCursor(Cursor.getPredefinedCursor(3));
            }
            HelpDialog hd = null;
            try {
                hd = app.getHelpDialog();
            }
            finally {
                if (app instanceof Component) {
                    ((Component)((Object)app)).setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            if (hd != null) {
                try {
                    hd.setVisible(true);
                }
                catch (Exception ex) {
                    app.displayException(ex);
                }
            }
        }
    }

    public static class ExitAction
    extends StandardAction {
        private static final long serialVersionUID = 1L;

        public ExitAction(GUIApplication app, String nameKey) {
            super(app, nameKey);
        }

        public ExitAction(GUIApplication app, String nameKey, String icon) {
            super(app, nameKey, icon);
        }

        public ExitAction(GUIApplication app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        public void actionPerformed(ActionEvent e) {
            this.getApplication().doExit();
        }
    }

    public static class AboutAction
    extends StandardAction {
        private static final long serialVersionUID = 1L;

        public AboutAction(GUIApplication app, String nameKey) {
            super(app, nameKey);
        }

        public AboutAction(GUIApplication app, ResourceBundle msg, String nameKey) {
            super(app, msg, nameKey);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.getApplication().getAboutDialog().setVisible(true);
            }
            catch (Exception ex) {
                this.getApplication().displayException(ex);
            }
        }
    }
}

