/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.StyleContext;
import org.fife.ui.BevelDividerBorder;
import org.fife.ui.UIUtil;
import org.fife.ui.app.WizardDialogInfoPanel;
import org.fife.ui.app.WizardPlugin;

public class WizardPluginDialog
extends JDialog {
    private HeaderPanel infoContainer;
    private CardLayout infoPanelLayout;
    private JPanel infoPanel;
    private JButton cancelButton;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishedButton;
    private WizardPlugin plugin;
    private WizardDialogInfoPanel[] panels;
    private int currentPanel;
    private HashMap wizardProperties;
    private Listener listener;
    private int retVal;
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.app.WizardDialog");

    public WizardPluginDialog(WizardPlugin plugin) {
        this.initialize(plugin);
    }

    public WizardPluginDialog(Frame owner, WizardPlugin plugin) {
        super(owner);
        this.initialize(plugin);
    }

    public WizardPlugin getPlugin() {
        return this.plugin;
    }

    public Object getWizardProperty(String key) {
        return this.wizardProperties.get(key);
    }

    protected void initialize(WizardPlugin plugin) {
        this.plugin = plugin;
        this.listener = new Listener();
        this.wizardProperties = new HashMap();
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(UIUtil.getEmpty5Border());
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(new BevelDividerBorder(1), UIUtil.getEmpty5Border()));
        JPanel temp = new JPanel(new GridLayout(1, 4, 5, 5));
        this.cancelButton = new JButton(msg.getString("Button.Cancel"));
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this.listener);
        temp.add(this.cancelButton);
        this.backButton = new JButton(msg.getString("Button.Back"));
        this.backButton.setActionCommand("Back");
        this.backButton.addActionListener(this.listener);
        this.backButton.setEnabled(false);
        temp.add(this.backButton);
        this.nextButton = new JButton(msg.getString("Button.Next"));
        this.nextButton.setActionCommand("Next");
        this.nextButton.addActionListener(this.listener);
        temp.add(this.nextButton);
        this.finishedButton = new JButton(msg.getString("Button.Finished"));
        this.finishedButton.setActionCommand("Finished");
        this.finishedButton.addActionListener(this.listener);
        this.finishedButton.setEnabled(false);
        temp.add(this.finishedButton);
        buttonPanel.add((Component)temp, "After");
        contentPane.add((Component)buttonPanel, "South");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(UIUtil.getEmpty5Border());
        JPanel iconPanel = new JPanel();
        iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JLabel iconLabel = new JLabel(plugin.getSideIcon());
        iconLabel.setBorder(BorderFactory.createBevelBorder(1));
        iconPanel.add(iconLabel);
        topPanel.add((Component)iconPanel, "West");
        this.infoContainer = new HeaderPanel();
        this.infoPanelLayout = new CardLayout();
        this.infoPanel = new JPanel(this.infoPanelLayout);
        this.infoContainer.add(this.infoPanel);
        topPanel.add(this.infoContainer);
        contentPane.add(topPanel);
        this.setPanels(plugin);
        this.setContentPane(contentPane);
        this.getRootPane().setDefaultButton(this.nextButton);
        this.setTitle(plugin.getWizardDialogTitle());
        this.setModal(true);
        this.setResizable(false);
        this.pack();
    }

    protected int runWizard() {
        this.currentPanel = 0;
        this.infoContainer.setHeader(this.panels[0].getHeader());
        this.setVisible(true);
        return this.retVal;
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }

    private void setPanels(WizardPlugin plugin) {
        int stepCount = plugin.getStepCount();
        this.panels = new WizardDialogInfoPanel[stepCount + 2];
        WizardDialogInfoPanel panel = plugin.getIntroductionPanel(this);
        this.infoPanel.add("0", panel);
        this.panels[0] = panel;
        for (int i = 1; i <= stepCount; ++i) {
            panel = plugin.getInfoPanel(i, this);
            this.infoPanel.add("" + i, panel);
            this.panels[i] = panel;
        }
        panel = plugin.getWizardSuccessfulPanel(this);
        this.infoPanel.add("" + (this.panels.length - 1), panel);
        this.panels[this.panels.length - 1] = panel;
    }

    public void setWizardProperty(String key, Object value) {
        this.wizardProperties.put(key, value);
    }

    private void updateVisiblePanel() {
        WizardDialogInfoPanel panel = this.panels[this.currentPanel];
        this.infoPanelLayout.show(this.infoPanel, "" + this.currentPanel);
        this.infoContainer.setHeader(panel.getHeader());
        String title = this.plugin.getWizardDialogTitle();
        int stepCount = this.plugin.getStepCount();
        if (this.currentPanel == 0) {
            this.backButton.setEnabled(false);
        } else if (this.currentPanel == 1) {
            this.backButton.setEnabled(true);
        }
        boolean lastPanel = this.currentPanel == stepCount + 1;
        this.nextButton.setEnabled(!lastPanel);
        this.finishedButton.setEnabled(lastPanel);
        if (this.currentPanel == stepCount) {
            this.getRootPane().setDefaultButton(this.nextButton);
        } else if (this.currentPanel == stepCount + 1) {
            this.getRootPane().setDefaultButton(this.finishedButton);
            this.finishedButton.requestFocusInWindow();
        }
        if (this.currentPanel > 0 && this.currentPanel <= stepCount) {
            String temp = msg.getString("Dialog.InStepTitle");
            title = MessageFormat.format(temp, title, "" + this.currentPanel, "" + stepCount);
        }
        this.setTitle(title);
        panel.isDisplayed();
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("Cancel")) {
                int rc;
                if (WizardPluginDialog.this.plugin.promptBeforeCancel() && (rc = JOptionPane.showConfirmDialog(WizardPluginDialog.this, msg.getString("MessageBox.ExitPrompt.Text"), msg.getString("MessageBox.ExitPrompt.Title"), 0, 3)) != 0) {
                    return;
                }
                WizardPluginDialog.this.retVal = 0;
                WizardPluginDialog.this.setVisible(false);
            } else if (actionCommand.equals("Back")) {
                WizardPluginDialog.this.currentPanel--;
                WizardPluginDialog.this.updateVisiblePanel();
            } else if (actionCommand.equals("Next")) {
                String errorMessage = WizardPluginDialog.this.panels[WizardPluginDialog.this.currentPanel].validateInput();
                if (errorMessage != null) {
                    JOptionPane.showMessageDialog(WizardPluginDialog.this, errorMessage, "Error", 0);
                    return;
                }
                WizardPluginDialog.this.panels[WizardPluginDialog.this.currentPanel].saveUserInput(WizardPluginDialog.this);
                WizardPluginDialog.this.panels[WizardPluginDialog.this.currentPanel].isAccepted();
                WizardPluginDialog.this.currentPanel++;
                WizardPluginDialog.this.updateVisiblePanel();
            } else if (actionCommand.equals("Finished")) {
                WizardPluginDialog.this.panels[WizardPluginDialog.this.currentPanel].isAccepted();
                WizardPluginDialog.this.setVisible(false);
                WizardPluginDialog.this.retVal = 1;
            }
        }
    }

    private static class HeaderPanel
    extends JPanel {
        private JLabel header;

        public HeaderPanel() {
            this.setLayout(new BorderLayout());
            JPanel headerPanel = new JPanel(new BorderLayout());
            headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), new BevelDividerBorder(3)));
            this.header = new JLabel("Header");
            StyleContext sc = StyleContext.getDefaultStyleContext();
            Font font = this.header.getFont();
            font = sc.getFont(font.getFamily(), 1, 18);
            this.header.setFont(font);
            headerPanel.add((Component)this.header, "West");
            this.add((Component)headerPanel, "North");
        }

        public void setHeader(String headerText) {
            this.header.setText(headerText);
        }
    }
}

