/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.SpecialValueComboBox;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.UIUtil;
import org.fife.ui.modifiabletable.AbstractRowHandler;
import org.fife.ui.modifiabletable.ModifiableTable;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.rtextfilechooser.FileChooserOwner;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.TextColorCellRenderer;

public class RTextFileChooserOptionPanel
extends OptionsDialogPanel
implements ActionListener,
ModifiableTableListener {
    private static final long serialVersionUID = 1L;
    public static final String AUTO_COMPLETE_PROPERTY = "AutoComplete";
    public static final String COLOR_CHANGED_PROPERTY = "ColorChanged";
    public static final String HIDDEN_FILES_PROPERTY = "HiddenFiles";
    public static final String OFFER_SUGGESTIONS_PROPERTY = "OfferSuggestions";
    public static final String OPEN_FILES_STYLE_PROPERTY = "OpenFilesStyle";
    public static final String STYLE_OPEN_FILES_PROPERTY = "StyleOpenFiles";
    private JCheckBox hiddenFilesCheckBox;
    private JCheckBox offerSuggestionsCB;
    private JCheckBox autoCompleteCheckBox;
    private RColorSwatchesButton hiddenColorButton;
    private ColorTableModel colorTableModel;
    private static String defaultColorString;
    private SpecialValueComboBox openFilesStyleCombo;
    private JCheckBox styleOpenFilesCheckBox;
    private static final String SUBSTANCE_RENDERER_CLASS = "org.fife.ui.rtextfilechooser.SubstanceTextColorCellRenderer";
    private static final String MAPPING_DIALOG_BUNDLE = "org.fife.ui.rtextfilechooser.ExtensionColorMappingDialog";

    public RTextFileChooserOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.FileChooser");
        defaultColorString = msg.getString("DefaultColorLabel");
        this.setName(msg.getString("FileChooser"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box temp = Box.createVerticalBox();
        temp.setBorder(new OptionsDialogPanel.OptionPanelBorder(msg.getString("General")));
        this.hiddenFilesCheckBox = this.createCheckBox(msg, HIDDEN_FILES_PROPERTY);
        Box temp2 = this.createHorizontalBox();
        this.hiddenColorButton = new RColorSwatchesButton();
        temp2.add(this.hiddenFilesCheckBox);
        temp2.add(this.hiddenColorButton);
        temp2.add(Box.createHorizontalGlue());
        temp.add(temp2);
        temp2 = this.createStyleOpenFilesPanel(msg);
        temp.add(temp2);
        this.offerSuggestionsCB = this.createCheckBox(msg, OFFER_SUGGESTIONS_PROPERTY);
        this.addLeftAligned(temp, this.offerSuggestionsCB);
        this.autoCompleteCheckBox = this.createCheckBox(msg, AUTO_COMPLETE_PROPERTY);
        this.addLeftAligned(temp, this.autoCompleteCheckBox, 0, 20);
        this.add((Component)temp, "North");
        JPanel customColorsPanel = new JPanel(new BorderLayout());
        customColorsPanel.setBorder(new OptionsDialogPanel.OptionPanelBorder(msg.getString("Colors")));
        this.colorTableModel = new ColorTableModel(msg.getString("Extension"), msg.getString("Color"));
        ModifiableTable modifiableTable = new ModifiableTable(this.colorTableModel);
        modifiableTable.setRowHandler(new FileChooserRowHandler());
        modifiableTable.addModifiableTableListener(this);
        JTable colorTable = modifiableTable.getTable();
        colorTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        colorTable.getColumnModel().getColumn(1).setCellRenderer(RTextFileChooserOptionPanel.createTextColorCellRenderer());
        customColorsPanel.add(modifiableTable);
        this.add(customColorsPanel);
        this.applyComponentOrientation(orientation);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (HIDDEN_FILES_PROPERTY.equals(actionCommand)) {
            boolean checked = this.hiddenFilesCheckBox.isSelected();
            this.hiddenColorButton.setEnabled(checked);
            this.firePropertyChange(HIDDEN_FILES_PROPERTY, !checked, checked);
        } else if (OFFER_SUGGESTIONS_PROPERTY.equals(actionCommand)) {
            boolean checked = this.offerSuggestionsCB.isSelected();
            this.autoCompleteCheckBox.setEnabled(checked);
            this.firePropertyChange(OFFER_SUGGESTIONS_PROPERTY, !checked, checked);
        } else if (AUTO_COMPLETE_PROPERTY.equals(actionCommand)) {
            boolean checked = this.autoCompleteCheckBox.isSelected();
            this.firePropertyChange(AUTO_COMPLETE_PROPERTY, !checked, checked);
        } else if (STYLE_OPEN_FILES_PROPERTY.equals(actionCommand)) {
            boolean checked = this.styleOpenFilesCheckBox.isSelected();
            this.openFilesStyleCombo.setEnabled(checked);
            this.firePropertyChange(STYLE_OPEN_FILES_PROPERTY, !checked, checked);
        } else if (OPEN_FILES_STYLE_PROPERTY.equals(actionCommand)) {
            String style = this.openFilesStyleCombo.getSelectedSpecialItem();
            this.firePropertyChange(OPEN_FILES_STYLE_PROPERTY, null, style);
        }
    }

    public void configureFileChooser(RTextFileChooser chooser) {
        chooser.setShowHiddenFiles(this.hiddenFilesCheckBox.isSelected());
        chooser.setHiddenFileColor(this.hiddenColorButton.getColor());
        chooser.setFileSystemAware(this.offerSuggestionsCB.isSelected());
        chooser.setAutoCompleteFileNames(this.autoCompleteCheckBox.isSelected());
        chooser.clearExtensionColorMap();
        chooser.setStyleOpenFiles(this.styleOpenFilesCheckBox.isSelected());
        String style = this.openFilesStyleCombo.getSelectedSpecialItem();
        chooser.setOpenFilesStyle(Integer.parseInt(style));
        int rowCount = this.colorTableModel.getRowCount();
        for (int i = 1; i < rowCount; ++i) {
            String ext = (String)this.colorTableModel.getValueAt(i, 0);
            Color color = (Color)this.colorTableModel.getValueAt(i, 1);
            chooser.setColorForExtension(ext, color);
        }
    }

    private JCheckBox createCheckBox(ResourceBundle msg, String root) {
        JCheckBox cb = new JCheckBox(msg.getString(root + "Label"));
        cb.setMnemonic((int)msg.getString(root + "Mnemonic").charAt(0));
        cb.setActionCommand(root);
        cb.addActionListener(this);
        return cb;
    }

    private Box createStyleOpenFilesPanel(ResourceBundle msg) {
        Box panel = this.createHorizontalBox();
        this.openFilesStyleCombo = new SpecialValueComboBox();
        UIUtil.fixComboOrientation(this.openFilesStyleCombo);
        this.openFilesStyleCombo.addSpecialItem(msg.getString("Underline"), "2");
        this.openFilesStyleCombo.setActionCommand(OPEN_FILES_STYLE_PROPERTY);
        this.openFilesStyleCombo.addActionListener(this);
        String text = msg.getString("StyleOpenFilesLabel");
        int pos = text.indexOf("{0}");
        if (pos == -1) {
            pos = text.length();
        }
        String beg = text.substring(0, pos);
        String end = text.substring(pos + 3);
        this.styleOpenFilesCheckBox = new JCheckBox(beg);
        this.styleOpenFilesCheckBox.setMnemonic((int)msg.getString("StyleOpenFilesMnemonic").charAt(0));
        this.styleOpenFilesCheckBox.setActionCommand(STYLE_OPEN_FILES_PROPERTY);
        this.styleOpenFilesCheckBox.addActionListener(this);
        panel.add(this.styleOpenFilesCheckBox);
        panel.add(this.openFilesStyleCombo);
        if (end.length() > 0) {
            panel.add(new JLabel(end));
        }
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private static final TableCellRenderer createTextColorCellRenderer() {
        TableCellRenderer renderer = null;
        if (SubstanceUtils.isSubstanceInstalled()) {
            try {
                Class<?> clazz = Class.forName(SUBSTANCE_RENDERER_CLASS);
                renderer = (TableCellRenderer)clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (renderer == null) {
            renderer = new TextColorCellRenderer();
        }
        return renderer;
    }

    protected void doApplyImpl(Frame owner) {
        if (!(owner instanceof FileChooserOwner)) {
            throw new IllegalArgumentException("owner must be a FileChooserOwner");
        }
        FileChooserOwner fco = (FileChooserOwner)((Object)owner);
        this.configureFileChooser(fco.getFileChooser());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public JComponent getTopJComponent() {
        return this.hiddenFilesCheckBox;
    }

    public void initialize(RTextFileChooser chooser) {
        boolean showHiddenFiles = chooser.getShowHiddenFiles();
        this.hiddenFilesCheckBox.setSelected(showHiddenFiles);
        this.hiddenColorButton.setColor(chooser.getHiddenFileColor());
        this.hiddenColorButton.setEnabled(showHiddenFiles);
        this.styleOpenFilesCheckBox.setSelected(chooser.getStyleOpenFiles());
        this.openFilesStyleCombo.setSelectedSpecialItem("" + chooser.getOpenFilesStyle());
        this.openFilesStyleCombo.setEnabled(chooser.getStyleOpenFiles());
        this.setOfferSuggestionsSelected(chooser.getFileSystemAware());
        this.autoCompleteCheckBox.setSelected(chooser.getAutoCompleteFileNames());
        this.colorTableModel.initCustomColorTable(chooser);
    }

    public void modifiableTableChanged(ModifiableTableChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(COLOR_CHANGED_PROPERTY, null, new Integer(e.getRow()));
    }

    private void setOfferSuggestionsSelected(boolean selected) {
        this.offerSuggestionsCB.setSelected(selected);
        this.autoCompleteCheckBox.setEnabled(selected);
    }

    protected void setValuesImpl(Frame owner) {
        if (!(owner instanceof FileChooserOwner)) {
            throw new IllegalArgumentException("owner must be a FileChooserOwner");
        }
        FileChooserOwner fco = (FileChooserOwner)((Object)owner);
        this.initialize(fco.getFileChooser());
    }

    class FileChooserRowHandler
    extends AbstractRowHandler {
        private ExtensionColorMappingDialog dialog;

        FileChooserRowHandler() {
        }

        public boolean canModifyRow(int row) {
            return row > 0;
        }

        public Object[] getNewRowInfo(Object[] oldData) {
            if (this.dialog == null) {
                this.dialog = new ExtensionColorMappingDialog(RTextFileChooserOptionPanel.this.getOptionsDialog());
            }
            if (oldData == null) {
                this.dialog.setData(null, null);
            } else {
                this.dialog.setData((String)oldData[0], (Color)oldData[1]);
            }
            int rc = this.dialog.showMappingDialog();
            if (rc == 0) {
                return new Object[]{this.dialog.getExtension(), this.dialog.getColor()};
            }
            return null;
        }

        public void updateUI() {
            if (this.dialog != null) {
                SwingUtilities.updateComponentTreeUI(this.dialog);
            }
        }
    }

    static class ExtensionColorMappingDialog
    extends JDialog
    implements ActionListener,
    ChangeListener,
    DocumentListener {
        static final int OK = 0;
        static final int CANCEL = 1;
        private JTextField extensionField;
        private JColorChooser colorChooser;
        private JButton okButton;
        private JButton cancelButton;
        private int rc;

        public ExtensionColorMappingDialog(JDialog owner) {
            super(owner);
            ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
            ResourceBundle msg = ResourceBundle.getBundle(RTextFileChooserOptionPanel.MAPPING_DIALOG_BUNDLE);
            ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
            contentPane.setBorder(UIUtil.getEmpty5Border());
            Box topPanel = Box.createVerticalBox();
            JPanel temp = new JPanel(new BorderLayout());
            temp.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JLabel label = UIUtil.newLabel(msg, "Extension");
            JPanel temp2 = new JPanel(new BorderLayout());
            temp2.add(label);
            if (orientation.isLeftToRight()) {
                temp2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            } else {
                temp2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            }
            temp.add((Component)temp2, "Before");
            this.extensionField = new JTextField();
            this.extensionField.getDocument().addDocumentListener(this);
            label.setLabelFor(this.extensionField);
            temp.add(this.extensionField);
            topPanel.add(temp);
            this.colorChooser = new JColorChooser();
            this.colorChooser.getSelectionModel().addChangeListener(this);
            topPanel.add(this.colorChooser);
            contentPane.add((Component)topPanel, "North");
            this.okButton = UIUtil.newButton(msg, "OK.Text", "OK.Mnemonic");
            this.okButton.addActionListener(this);
            this.cancelButton = UIUtil.newButton(msg, "Cancel.Text", "Cancel.Mnemonic");
            this.cancelButton.addActionListener(this);
            Container buttons = UIUtil.createButtonFooter(this.okButton, this.cancelButton);
            contentPane.add((Component)buttons, "South");
            this.setTitle(msg.getString("Title"));
            this.setContentPane(contentPane);
            this.getRootPane().setDefaultButton(this.okButton);
            this.setModal(true);
            this.applyComponentOrientation(orientation);
            this.pack();
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.okButton) {
                this.rc = 0;
            }
            this.setVisible(false);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public Color getColor() {
            return this.colorChooser.getColor();
        }

        public String getExtension() {
            return this.extensionField.getText();
        }

        public void insertUpdate(DocumentEvent e) {
            this.okButton.setEnabled(true);
        }

        public void removeUpdate(DocumentEvent e) {
            this.okButton.setEnabled(this.extensionField.getDocument().getLength() > 0);
        }

        public void setData(String extension, Color color) {
            this.extensionField.setText(extension);
            this.colorChooser.setColor(color);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                String extension = this.extensionField.getText();
                this.extensionField.setEnabled(!extension.equals(defaultColorString));
            }
            super.setVisible(visible);
        }

        public int showMappingDialog() {
            this.rc = 1;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExtensionColorMappingDialog.this.extensionField.requestFocusInWindow();
                    ExtensionColorMappingDialog.this.extensionField.selectAll();
                }
            });
            this.setLocationRelativeTo(this.getOwner());
            this.okButton.setEnabled(false);
            this.setVisible(true);
            return this.rc;
        }

        public void stateChanged(ChangeEvent e) {
            this.okButton.setEnabled(this.extensionField.getDocument().getLength() > 0);
        }
    }

    private static class ColorTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        public ColorTableModel(String extensionHeader, String colorHeader) {
            super(new Object[]{extensionHeader, colorHeader}, 0);
        }

        public void initCustomColorTable(RTextFileChooser chooser) {
            this.setRowCount(0);
            Vector<Object> v = new Vector<Object>(2);
            v.add(defaultColorString);
            v.add(chooser.getDefaultFileColor());
            this.addRow(v);
            HashMap map = chooser.getCustomColorsMap();
            Set keySet = map.keySet();
            if (keySet != null) {
                Iterator it = keySet.iterator();
                while (it.hasNext()) {
                    v = new Vector(2);
                    String extension = (String)it.next();
                    Color c = (Color)map.get(extension);
                    v.add(extension);
                    v.add(c);
                    this.addRow(v);
                }
            }
        }
    }
}

