/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.gui.OutputLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.ILookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.LookAndFeelComboBox;

public class LAFPreferencesTab
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(LAFPreferencesTab.class);
    private static ILogger s_log = LoggerController.createLogger(LAFPreferencesTab.class);
    private LAFPlugin _plugin;
    private LAFRegister _lafRegister;
    private LAFPreferencesPanel _myPanel;

    public LAFPreferencesTab(LAFPlugin plugin, LAFRegister lafRegister) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null LAFPlugin passed");
        }
        if (lafRegister == null) {
            throw new IllegalArgumentException("Null LAFRegister passed");
        }
        this._plugin = plugin;
        this._lafRegister = lafRegister;
    }

    public void initialize(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        ((LAFPreferencesPanel)this.getPanelComponent()).loadData();
    }

    public void uninitialize(IApplication app) {
    }

    public synchronized Component getPanelComponent() {
        if (this._myPanel == null) {
            this._myPanel = new LAFPreferencesPanel(this._plugin, this._lafRegister);
        }
        return this._myPanel;
    }

    public void applyChanges() {
        this._myPanel.applyChanges();
    }

    public String getTitle() {
        return LAFPreferencesPanel.LAFPreferencesPanelI18n.TAB_TITLE;
    }

    public String getHint() {
        return LAFPreferencesPanel.LAFPreferencesPanelI18n.TAB_HINT;
    }

    private static final class LAFPreferencesPanel
    extends JPanel {
        private LookAndFeelComboBox _lafCmb = new LookAndFeelComboBox();
        private JCheckBox _allowSetBorder = new JCheckBox(LAFPreferencesTab.access$000().getString("laf.allowsetborder"));
        private LAFPlugin _plugin;
        private LAFRegister _lafRegister;
        private LAFPreferences _prefs;
        private LookAndFeelComboListener _lafComboListener;
        private BaseLAFPreferencesPanelComponent _curLAFConfigComp;
        private JPanel _lafPnl;

        LAFPreferencesPanel(LAFPlugin plugin, LAFRegister lafRegister) {
            super(new GridBagLayout());
            this._plugin = plugin;
            this._lafRegister = lafRegister;
            this._prefs = this._plugin.getLAFPreferences();
            this.createUserInterface();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this._lafComboListener = new LookAndFeelComboListener();
            this._lafCmb.addActionListener(this._lafComboListener);
        }

        @Override
        public void removeNotify() {
            if (this._lafComboListener != null) {
                this._lafCmb.removeActionListener(this._lafComboListener);
                this._lafComboListener = null;
            }
            super.removeNotify();
        }

        void loadData() {
            String selLafClassName = this._prefs.getLookAndFeelClassName();
            this._allowSetBorder.setSelected(this._prefs.getCanLAFSetBorder());
            this._lafCmb.setSelectedLookAndFeelClassName(selLafClassName);
            this.updateLookAndFeelConfigControl();
        }

        void applyChanges() {
            this._prefs.setCanLAFSetBorder(this._allowSetBorder.isSelected());
            this._prefs.setLookAndFeelClassName(this._lafCmb.getSelectedLookAndFeel().getClassName());
            this._lafRegister.applyPreferences();
            boolean forceChange = false;
            if (this._curLAFConfigComp != null) {
                forceChange = this._curLAFConfigComp.applyChanges();
            }
            try {
                this._lafRegister.setLookAndFeel(forceChange);
            }
            catch (Exception ex) {
                s_log.error((Object)"Error setting Look and Feel", (Throwable)ex);
            }
        }

        private void createUserInterface() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridy = 0;
            gbc.gridx = 0;
            this.add((Component)this.createSettingsPanel(), gbc);
            ++gbc.gridy;
            this.add((Component)this.createLookAndFeelPanel(), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            this.add((Component)new MultipleLineLabel(LAFPreferencesPanelI18n.LAF_WARNING), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            MultipleLineLabel enforedWarningLabel = new MultipleLineLabel(LAFPreferencesPanelI18n.LAF_CRITICAL_WARNING);
            enforedWarningLabel.setForeground(Color.red);
            this.add((Component)enforedWarningLabel, gbc);
        }

        private JPanel createLookAndFeelPanel() {
            this._lafPnl = new JPanel(new GridBagLayout());
            this._lafPnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("laf.broderLaf")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this._lafPnl.add((Component)new JLabel(LAFPreferencesPanelI18n.LOOK_AND_FEEL, 4), gbc);
            ++gbc.gridx;
            this._lafPnl.add((Component)this._lafCmb, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this._lafPnl.add((Component)new JLabel(LAFPreferencesPanelI18n.LAF_LOC, 4), gbc);
            ++gbc.gridx;
            this._lafPnl.add((Component)new OutputLabel(this._plugin.getLookAndFeelFolder().getAbsolutePath()), gbc);
            return this._lafPnl;
        }

        private JPanel createSettingsPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("laf.general")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)this._allowSetBorder, gbc);
            return pnl;
        }

        private void updateLookAndFeelConfigControl() {
            UIManager.LookAndFeelInfo lafInfo;
            if (this._curLAFConfigComp != null) {
                this._lafPnl.remove(this._curLAFConfigComp);
                this._curLAFConfigComp = null;
            }
            if ((lafInfo = this._lafCmb.getSelectedLookAndFeel()) != null) {
                String selLafClassName = lafInfo.getClassName();
                if (selLafClassName != null) {
                    ILookAndFeelController ctrl = this._lafRegister.getLookAndFeelController(selLafClassName);
                    if (ctrl != null) {
                        this._curLAFConfigComp = ctrl.getPreferencesComponent();
                        if (this._curLAFConfigComp != null) {
                            this._curLAFConfigComp.loadPreferencesPanel();
                            GridBagConstraints gbc = new GridBagConstraints();
                            gbc.fill = 2;
                            gbc.insets = new Insets(4, 4, 4, 4);
                            gbc.gridx = 0;
                            gbc.gridy = -1;
                            gbc.gridwidth = 0;
                            this._lafPnl.add((Component)this._curLAFConfigComp, gbc);
                        }
                    } else {
                        s_log.debug((Object)("No ILookAndFeelController found for: " + selLafClassName));
                    }
                }
            } else {
                s_log.debug((Object)"Selected Look and Feel class is null");
            }
            this.validate();
        }

        private class LookAndFeelComboListener
        implements ActionListener {
            private LookAndFeelComboListener() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                LAFPreferencesPanel.this.updateLookAndFeelConfigControl();
            }
        }

        static interface LAFPreferencesPanelI18n {
            public static final String LOOK_AND_FEEL = LAFPreferencesTab.access$000().getString("laf.lookAndFeel");
            public static final String LAF_WARNING = LAFPreferencesTab.access$000().getString("laf.lafWarning");
            public static final String TAB_TITLE = LAFPreferencesTab.access$000().getString("laf.lf");
            public static final String TAB_HINT = LAFPreferencesTab.access$000().getString("laf.settings");
            public static final String LAF_LOC = LAFPreferencesTab.access$000().getString("laf.jars");
            public static final String LAF_CRITICAL_WARNING = LAFPreferencesTab.access$000().getString("laf.lafCriticalWarning");
        }
    }
}

