/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf.jtattoo;

import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IntegerIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.BaseLAFPreferencesPanelComponent;
import net.sourceforge.squirrel_sql.plugins.laf.DefaultLookAndFeelController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;
import net.sourceforge.squirrel_sql.plugins.laf.jtattoo.JTattooLafData;

public class JTattooLookAndFeelController
extends DefaultLookAndFeelController {
    private static final String JTATTOO_LOOK_AND_FEEL_CLASS = "com.jtattoo.plaf.acryl.AcrylLookAndFeel";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(JTattooLookAndFeelController.class);
    private static final ILogger s_log = LoggerController.createLogger(JTattooLookAndFeelController.class);
    public static final String JTATTOO_LAF_PLACEHOLDER_CLASS_NAME = "net.sourceforge.squirrel_sql.plugins.laf.jtattoo.JTattooLafPlaceholder";
    private JTattooPreferences _prefs;
    private JTattooLafData _lafData = null;
    private ClassLoader _cl = null;

    public JTattooLookAndFeelController(LAFPlugin plugin, LAFRegister register) throws IOException {
        this._cl = register.getLookAndFeelClassLoader();
        this._lafData = new JTattooLafData(this._cl);
        XMLObjectCache<LAFPreferences> cache = plugin.getSettingsCache();
        Iterator it = cache.getAllForClass(JTattooPreferences.class);
        if (it.hasNext()) {
            this._prefs = (JTattooPreferences)it.next();
        } else {
            this._prefs = new JTattooPreferences();
            try {
                cache.add((IHasIdentifier)this._prefs);
            }
            catch (DuplicateObjectException ex) {
                s_log.error((Object)"JTattooPreferences object already in XMLObjectCache", (Throwable)ex);
            }
        }
    }

    @Override
    public void aboutToBeInstalled(LAFRegister lafRegister, LookAndFeel laf) {
    }

    @Override
    public void hasBeenInstalled(LAFRegister lafRegister, LookAndFeel laf) {
        String skinName = this._prefs.getSkinName();
        Class<?> skinClass = this._lafData.getSkinClassForName(skinName);
        try {
            LookAndFeel skinObject = (LookAndFeel)skinClass.newInstance();
            if (skinClass.getName().equals("com.jtattoo.plaf.mcwin.McWinLookAndFeel")) {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)"Detected McWin L&F selection.  Setting theme to draw square buttons.");
                }
                Properties props = new Properties();
                props.put("drawSquareButtons", "on");
                McWinLookAndFeel.setCurrentTheme((Properties)props);
            }
            UIManager.setLookAndFeel(skinObject);
            UIManager.getLookAndFeelDefaults().put("ClassLoader", this._cl);
        }
        catch (InstantiationException e) {
            s_log.error((Object)("Unable to instantiate skinClass (" + skinName + "):" + e.getMessage()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            s_log.error((Object)("Unable to instantiate skinClass (" + skinName + "):" + e.getMessage()), (Throwable)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            s_log.error((Object)("Unable to set look and feel using skinClass(" + skinName + "):" + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public BaseLAFPreferencesPanelComponent getPreferencesComponent() {
        return new JTattooSkinPrefsPanel(this);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    public static final class JTattooPreferences
    implements IHasIdentifier {
        private String _skinName;
        private IntegerIdentifier _id = new IntegerIdentifier(1);

        public String getSkinName() {
            return this._skinName;
        }

        public void setSkinName(String value) {
            this._skinName = value;
        }

        public IIdentifier getIdentifier() {
            return this._id;
        }
    }

    private static final class JTattooSkinPrefsPanel
    extends BaseLAFPreferencesPanelComponent {
        private static final long serialVersionUID = 1L;
        private JTattooLookAndFeelController _ctrl;
        private JComboBox _skinCmb = new JComboBox();

        JTattooSkinPrefsPanel(JTattooLookAndFeelController ctrl) {
            super(new GridBagLayout());
            this._ctrl = ctrl;
            this.createUserInterface();
        }

        private void createUserInterface() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)new JLabel(SkinPrefsPanelI18n.SKIN_LABEL, 4), gbc);
            ++gbc.gridx;
            this.add((Component)this._skinCmb, gbc);
        }

        @Override
        public void loadPreferencesPanel() {
            super.loadPreferencesPanel();
            Set<String> JTattooThemes = this._ctrl._lafData.getSkins();
            Object[] comboItems = new Object[JTattooThemes.size()];
            int count = 0;
            for (String theme : JTattooThemes) {
                comboItems[count++] = theme;
            }
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(comboItems);
            this._skinCmb.setModel(model);
            this._skinCmb.setSelectedItem(this._ctrl._prefs.getSkinName());
            if (this._skinCmb.getSelectedIndex() == -1 && this._skinCmb.getModel().getSize() > 0) {
                this._skinCmb.setSelectedIndex(0);
            }
        }

        @Override
        public boolean applyChanges() {
            super.applyChanges();
            this._ctrl._prefs.setSkinName((String)this._skinCmb.getSelectedItem());
            return true;
        }

        static interface SkinPrefsPanelI18n {
            public static final String SKIN_LABEL = JTattooLookAndFeelController.access$000().getString("JTattooLookAndFeelController.JTattooSkinLabel");
        }
    }
}

