/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Map;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.border.ClassicBorderPainter;
import org.jvnet.substance.painter.border.CompositeBorderPainter;
import org.jvnet.substance.painter.border.DelegateBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MatteDecorationPainter;
import org.jvnet.substance.painter.gradient.StandardGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class DustSkin
extends SubstanceSkin {
    public static final String NAME = "Dust";

    public DustSkin() {
        Map<String, SubstanceColorScheme> schemes = SubstanceSkin.getColorSchemes(DustSkin.class.getClassLoader().getResource("org/jvnet/substance/skin/dust.colorschemes"));
        SubstanceColorScheme activeScheme = schemes.get("Dust Active");
        SubstanceColorScheme defaultScheme = schemes.get("Dust Default");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, defaultScheme);
        defaultSchemeBundle.registerColorScheme(defaultScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(activeScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme borderDefaultScheme = schemes.get("Dust Border Default");
        SubstanceColorScheme borderActiveScheme = schemes.get("Dust Border Active");
        defaultSchemeBundle.registerColorScheme(borderDefaultScheme, ColorSchemeAssociationKind.BORDER, ComponentState.DEFAULT, ComponentState.DISABLED_SELECTED, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(borderActiveScheme, ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme(borderDefaultScheme, ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        SubstanceColorScheme headerActiveScheme = schemes.get("Dust Header Active");
        SubstanceColorScheme headerDefaultScheme = schemes.get("Dust Header Default");
        SubstanceColorScheme headerWatermarkScheme = schemes.get("Dust Header Watermark");
        SubstanceColorScheme headerSeparatorScheme = schemes.get("Dust Header Separator");
        SubstanceColorScheme headerBorderScheme = schemes.get("Dust Header Border");
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(headerActiveScheme, headerDefaultScheme, headerDefaultScheme);
        headerSchemeBundle.registerColorScheme(headerDefaultScheme, 0.7f, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(headerActiveScheme, 0.7f, ComponentState.DISABLED_SELECTED);
        headerSchemeBundle.registerColorScheme(headerBorderScheme, ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(headerSeparatorScheme, ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        headerSchemeBundle.registerHighlightColorScheme(headerActiveScheme, 1.0f, new ComponentState[0]);
        headerSchemeBundle.registerHighlightColorScheme(headerActiveScheme, 0.0f, ComponentState.DEFAULT);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, DecorationAreaType.TOOLBAR);
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerWatermarkScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER);
        this.setSelectedTabFadeStart(0.1);
        this.setSelectedTabFadeEnd(0.3);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.gradientPainter = new StandardGradientPainter();
        this.decorationPainter = new DustDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new CompositeBorderPainter(NAME, new ClassicBorderPainter(), new DelegateBorderPainter("Dust Inner", new ClassicBorderPainter(), 0x60FFFFFF, 0x30FFFFFF, 0x18FFFFFF, new ColorSchemeTransform(){

            @Override
            public SubstanceColorScheme transform(SubstanceColorScheme scheme) {
                return scheme.shiftBackground(scheme.getUltraLightColor(), 0.8).tint(0.6).saturate(0.2);
            }
        }));
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    private class DustDecorationPainter
    extends MatteDecorationPainter {
        private DustDecorationPainter() {
        }

        @Override
        public String getDisplayName() {
            return DustSkin.NAME;
        }

        @Override
        public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
            super.paintDecorationArea(graphics, comp, decorationAreaType, width, height, skin);
            if (decorationAreaType == DecorationAreaType.TOOLBAR) {
                Container c;
                JToolBar toolbar;
                JToolBar jToolBar = toolbar = comp instanceof JToolBar ? (JToolBar)comp : null;
                for (c = comp.getParent(); c != null; c = c.getParent()) {
                    if (!(c instanceof JToolBar)) continue;
                    toolbar = (JToolBar)c;
                }
                Point inToolbar = SwingUtilities.convertPoint(comp, new Point(0, 0), toolbar);
                int dy = inToolbar.y;
                graphics.translate(0, -dy - 1);
                int fontSize = SubstanceSizeUtils.getComponentFontSize(c);
                float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(fontSize);
                graphics.setStroke(new BasicStroke(borderStrokeWidth));
                SubstanceColorScheme colorScheme = skin.getColorScheme(comp, ComponentState.DEFAULT);
                graphics.setColor(SubstanceColorUtilities.getAlphaColor(colorScheme.getForegroundColor(), 32));
                graphics.drawLine(0, (int)borderStrokeWidth, width, (int)borderStrokeWidth);
            }
            if (comp instanceof JMenuBar) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(comp);
                float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(fontSize);
                graphics.setStroke(new BasicStroke(borderStrokeWidth));
                SubstanceColorScheme colorScheme = skin.getColorScheme(comp, ComponentState.DEFAULT);
                graphics.setColor(colorScheme.getUltraDarkColor().darker());
                graphics.drawLine(0, height - (int)borderStrokeWidth, width, height - (int)borderStrokeWidth);
            }
        }
    }
}

