/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Window;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModel;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintData;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintIconHandlerListener;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintView;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintViewsModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphDesktopController;
import net.sourceforge.squirrel_sql.plugins.graph.GraphUtil;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModel;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndEvent;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ConstraintViewXmlBean;

public class ConstraintViewsModel {
    private static final ILogger s_log = LoggerController.createLogger(ConstraintViewsModel.class);
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConstraintViewsModel.class);
    private ConstraintView[] _constraintViews = new ConstraintView[0];
    private ISession _session;
    private ArrayList<ConstraintViewsModelListener> _listeners = new ArrayList();
    private ConstraintIconHandlerListener _constraintIconHandlerListener;

    public ConstraintViewsModel(ISession session) {
        this._session = session;
        this._constraintIconHandlerListener = new ConstraintIconHandlerListener(){

            @Override
            public void constraintTypeChanged() {
                ConstraintViewsModel.this.fireListeners();
            }
        };
    }

    public ConstraintView[] getConstViews() {
        return this._constraintViews;
    }

    public void initByXmlBeans(ConstraintViewXmlBean[] constraintViewXmlBeans, GraphDesktopController desktopController) {
        this._constraintViews = new ConstraintView[constraintViewXmlBeans.length];
        for (int i = 0; i < this._constraintViews.length; ++i) {
            this._constraintViews[i] = new ConstraintView(constraintViewXmlBeans[i], desktopController, this._session, this._constraintIconHandlerListener);
        }
    }

    public void addConst(ConstraintView constView) {
        ArrayList<ConstraintView> buf = new ArrayList<ConstraintView>();
        buf.addAll(Arrays.asList(this._constraintViews));
        buf.add(constView);
        this._constraintViews = buf.toArray(new ConstraintView[buf.size()]);
        this.fireListeners();
    }

    public void removeConst(ConstraintView constraintView) {
        ArrayList<ConstraintView> buf = new ArrayList<ConstraintView>();
        buf.addAll(Arrays.asList(this._constraintViews));
        buf.remove(constraintView);
        this._constraintViews = buf.toArray(new ConstraintView[buf.size()]);
        this.fireListeners();
    }

    private void fireListeners() {
        ConstraintViewsModelListener[] listeners;
        for (ConstraintViewsModelListener listener : listeners = this._listeners.toArray(new ConstraintViewsModelListener[this._listeners.size()])) {
            listener.constraintsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFromDB(DatabaseMetaData metaData, String catalog, String schema, String tableName, ColumnInfoModel colInfoModel, GraphDesktopController desktopController) {
        Hashtable<String, ConstraintData> dbConstraintInfosByConstraintName = new Hashtable<String, ConstraintData>();
        ResultSet res = null;
        try {
            res = metaData.getImportedKeys(catalog, schema, tableName);
            while (res.next()) {
                String pkCat = res.getString(1);
                String pkSchem = res.getString(2);
                String pkTable = res.getString(3);
                String pkColName = res.getString(4);
                String fkColName = res.getString(8);
                String fkName = res.getString(12);
                ColumnInfo fkCol = colInfoModel.findColumnInfo(fkColName);
                fkCol.setDBImportData(pkTable, pkColName, fkName);
                if (!desktopController.getModeManager().getTableFramesModel().containsTable(pkTable)) continue;
                ConstraintData dbConstraintData = (ConstraintData)dbConstraintInfosByConstraintName.get(fkName);
                if (null == dbConstraintData) {
                    dbConstraintData = new ConstraintData(pkTable, tableName, fkName);
                    dbConstraintInfosByConstraintName.put(fkName, dbConstraintData);
                }
                ColumnInfo pkCol = GraphUtil.createColumnInfo(this._session, pkCat, pkSchem, pkTable, pkColName);
                dbConstraintData.addColumnInfos(pkCol, fkCol);
            }
        }
        catch (SQLException e) {
            s_log.error((Object)"Unable to get Foriegn Key info", (Throwable)e);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
        }
        ConstraintData[] newDBconstraintData = dbConstraintInfosByConstraintName.values().toArray(new ConstraintData[0]);
        Hashtable<String, ConstraintView> oldDBConstraintViewsByConstraintName = new Hashtable<String, ConstraintView>();
        ArrayList<ConstraintView> oldNonDBConstraintViews = new ArrayList<ConstraintView>();
        desktopController.removeConstraintViews(this._constraintViews, true);
        for (int i = 0; i < this._constraintViews.length; ++i) {
            if (this._constraintViews[i].getData().isNonDbConstraint()) {
                oldNonDBConstraintViews.add(this._constraintViews[i]);
                continue;
            }
            String constraintName = this._constraintViews[i].getData().getConstraintName();
            oldDBConstraintViewsByConstraintName.put(constraintName, this._constraintViews[i]);
        }
        ArrayList<ConstraintView> newConstraintViewsBuf = new ArrayList<ConstraintView>();
        for (int i = 0; i < newDBconstraintData.length; ++i) {
            ConstraintView oldCV = (ConstraintView)oldDBConstraintViewsByConstraintName.get(newDBconstraintData[i].getConstraintName());
            if (null != oldCV) {
                oldCV.setData(newDBconstraintData[i]);
                newConstraintViewsBuf.add(oldCV);
                continue;
            }
            newConstraintViewsBuf.add(new ConstraintView(newDBconstraintData[i], desktopController, this._session, this._constraintIconHandlerListener));
        }
        this.removeMatchingConstraints(newConstraintViewsBuf, oldNonDBConstraintViews);
        newConstraintViewsBuf.addAll(oldNonDBConstraintViews);
        this._constraintViews = newConstraintViewsBuf.toArray(new ConstraintView[newConstraintViewsBuf.size()]);
    }

    public ConstraintView createConstraintView(DndEvent e, TableFrameController sourceTable, ColumnInfo sourceColumnInfo, GraphDesktopController desktopController, ISession session) {
        ColumnInfo targetColumnInfo = e.getColumnInfo();
        TableFrameController targetTable = e.getTableFrameController();
        if (null == targetColumnInfo || null == sourceColumnInfo || targetTable == sourceTable) {
            return null;
        }
        String constName = "SquirrelGeneratedConstraintName";
        ConstraintData data = new ConstraintData(sourceTable.getTableInfo().getSimpleName(), targetTable.getTableInfo().getSimpleName(), constName, true);
        data.addColumnInfos(sourceColumnInfo, targetColumnInfo);
        ConstraintView ret = new ConstraintView(data, desktopController, session, this._constraintIconHandlerListener);
        this.addConst(ret);
        return ret;
    }

    private void removeMatchingConstraints(ArrayList<ConstraintView> master, ArrayList<ConstraintView> toRemoveFrom) {
        ArrayList<ConstraintView> removeBuf = new ArrayList<ConstraintView>();
        block0: for (ConstraintView cvRemoveCand : toRemoveFrom) {
            for (ConstraintView cvMaster : master) {
                if (!cvMaster.matches(cvRemoveCand)) continue;
                removeBuf.add(cvRemoveCand);
                continue block0;
            }
        }
        toRemoveFrom.removeAll(removeBuf);
    }

    public ConstraintViewXmlBean[] getXmlBeans() {
        ConstraintViewXmlBean[] constViewXmlBeans = new ConstraintViewXmlBean[this._constraintViews.length];
        for (int i = 0; i < this._constraintViews.length; ++i) {
            constViewXmlBeans[i] = this._constraintViews[i].getXmlBean();
        }
        return constViewXmlBeans;
    }

    public ConstraintView[] removeConstraintsForTable(String tableName) {
        ArrayList<ConstraintView> newConstraintData = new ArrayList<ConstraintView>();
        ArrayList<ConstraintView> constraintDataToRemove = new ArrayList<ConstraintView>();
        for (int i = 0; i < this._constraintViews.length; ++i) {
            if (this._constraintViews[i].getData().getPkTableName().equalsIgnoreCase(tableName)) {
                constraintDataToRemove.add(this._constraintViews[i]);
                continue;
            }
            newConstraintData.add(this._constraintViews[i]);
        }
        this._constraintViews = newConstraintData.toArray(new ConstraintView[newConstraintData.size()]);
        return constraintDataToRemove.toArray(new ConstraintView[constraintDataToRemove.size()]);
    }

    public ConstraintView[] findConstraintViews(String tableName) {
        ArrayList<ConstraintView> ret = new ArrayList<ConstraintView>();
        for (int i = 0; i < this._constraintViews.length; ++i) {
            if (!this._constraintViews[i].getData().getPkTableName().equalsIgnoreCase(tableName)) continue;
            ret.add(this._constraintViews[i]);
        }
        return ret.toArray(new ConstraintView[ret.size()]);
    }

    public void addListener(ConstraintViewsModelListener l) {
        this._listeners.remove(l);
        this._listeners.add(l);
    }

    public void hideNoJoins(boolean b) {
        for (ConstraintView constraintView : this._constraintViews) {
            constraintView.setHideIfNoJoin(b);
        }
    }

    public boolean containsUniddenNoJoins() {
        for (ConstraintView constraintView : this._constraintViews) {
            if (!constraintView.isUniddenNoJoin()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ConstraintView> checkForMatches(ConstraintView v) {
        ArrayList<ConstraintView> ret = new ArrayList<ConstraintView>();
        for (ConstraintView view : this._constraintViews) {
            if (v == view || !v.matches(view)) continue;
            ret.add(view);
        }
        return ret;
    }

    public ArrayList<ConstraintView> checkMerges(GraphDesktopController desktopController, TableFrameController fkTable, TableFrameController pkTable, ConstraintView newConstraint) {
        ArrayList<ConstraintView> ret = new ArrayList<ConstraintView>();
        if (!newConstraint.generateFoldingPointIfLinesWouldCoverEachOther()) {
            Mode mode = desktopController.getModeManager().getMode();
            String pkTableName = pkTable.getTableInfo().getSimpleName();
            if (mode.isQueryBuilder() && 2 == this.nonDbJoinCountTo(pkTableName)) {
                String fkTableName;
                String msg;
                Window parent = SwingUtilities.windowForComponent(pkTable.getFrame());
                int opt = JOptionPane.showConfirmDialog(parent, msg = s_stringMgr.getString("graph.ConstraintViewsModel.joinMergeMsg", new Object[]{fkTableName = fkTable.getTableInfo().getSimpleName(), pkTableName}));
                if (1 == opt) {
                    return this.mergeNonDBJoinsTo(newConstraint, pkTableName);
                }
                if (2 == opt) {
                    ret.add(newConstraint);
                }
            }
        }
        return ret;
    }

    private int nonDbJoinCountTo(String pkTableName) {
        int ret = 0;
        for (ConstraintView constraintView : this._constraintViews) {
            if (!pkTableName.equalsIgnoreCase(constraintView.getData().getPkTableName()) || !constraintView.getData().isNonDbConstraint() || constraintView.getData().getConstraintQueryData().isNoJoin()) continue;
            ++ret;
        }
        return ret;
    }

    private ArrayList<ConstraintView> mergeNonDBJoinsTo(ConstraintView mergeTarget, String pkTableName) {
        ArrayList<ConstraintView> toRemove = new ArrayList<ConstraintView>();
        for (ConstraintView constraintView : this._constraintViews) {
            if (!pkTableName.equalsIgnoreCase(constraintView.getData().getPkTableName()) || mergeTarget == constraintView || !constraintView.getData().isNonDbConstraint() || constraintView.hasOverlap(mergeTarget)) continue;
            for (int i = 0; i < constraintView.getData().getFkColumnInfos().length; ++i) {
                ColumnInfo fkCol = constraintView.getData().getFkColumnInfos()[i];
                ColumnInfo pkCol = constraintView.getData().getPkColumnInfos()[i];
                mergeTarget.getData().addColumnInfos(pkCol, fkCol);
            }
            toRemove.add(constraintView);
        }
        return toRemove;
    }

    public void replaceColumnClonesInConstraintsByRefrences(TableFramesModel tableFramesModel) {
        for (ConstraintView constraintView : this._constraintViews) {
            constraintView.getData().replaceColumnClonesInConstraintsByRefrences(tableFramesModel);
        }
    }
}

