/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.gui.db.ColumnListDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddAutoIncrementDialog;

public class AddAutoIncrementCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(AddAutoIncrementCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddAutoIncrementCommand.class);
    protected AddAutoIncrementDialog customDialog;
    private ColumnListDialog listDialog;
    private TableColumnInfo columnToModify;

    public AddAutoIncrementCommand(ISession session, IDatabaseObjectInfo[] dbInfo) {
        super(session, dbInfo);
    }

    @Override
    protected void onExecute() throws SQLException {
        ITableInfo selectedTable = (ITableInfo)this._info[0];
        TableColumnInfo[] tableColumnInfos = this._session.getMetaData().getColumnInfo(selectedTable);
        if (tableColumnInfos.length == 1) {
            this.columnToModify = tableColumnInfos[0];
            this.showCustomDialog();
        } else {
            this.listDialog = new ColumnListDialog(tableColumnInfos, 1);
            this.listDialog.addColumnSelectionListener((ActionListener)new ColumnListSelectionActionListener());
            this.listDialog.setLocationRelativeTo((Component)SessionUtils.getOwningFrame((ISession)this._session));
            this.listDialog.setSingleSelection();
            this.listDialog.setTableName(selectedTable.getSimpleName());
            this.listDialog.setVisible(true);
        }
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        String[] result = new String[]{};
        if (this._dialect.supportsAutoIncrement()) {
            DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this.columnToModify.getCatalogName(), this.columnToModify.getSchemaName());
            StringBuilder sequenceName = new StringBuilder();
            sequenceName.append(this.columnToModify.getTableName().toUpperCase()).append("_");
            sequenceName.append(this.columnToModify.getColumnName().toUpperCase()).append("_SEQ");
            result = this._dialect.getAddAutoIncrementSQL(this.columnToModify, sequenceName.toString(), qualifier, this._sqlPrefs);
        } else {
            this._session.showMessage(s_stringMgr.getString("AddAutoIncrementCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result;
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AddAutoIncrementCommand.this.customDialog.setVisible(false);
                        AddAutoIncrementCommand.this.customDialog.dispose();
                        AddAutoIncrementCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsAutoIncrement();
    }

    private void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                AddAutoIncrementCommand.this.customDialog = new AddAutoIncrementDialog(AddAutoIncrementCommand.this.columnToModify, SessionUtils.getOwningFrame((ISession)AddAutoIncrementCommand.this._session));
                AddAutoIncrementCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                AddAutoIncrementCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(AddAutoIncrementCommand.this.customDialog));
                AddAutoIncrementCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, AddAutoIncrementCommand.this.customDialog));
                AddAutoIncrementCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)AddAutoIncrementCommand.this._session));
                AddAutoIncrementCommand.this.customDialog.setVisible(true);
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class ColumnListSelectionActionListener
    implements ActionListener {
        private ColumnListSelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddAutoIncrementCommand.this.listDialog == null) {
                System.err.println("dialog was null");
                return;
            }
            AddAutoIncrementCommand.this.listDialog.setVisible(false);
            AddAutoIncrementCommand.this.listDialog.dispose();
            AddAutoIncrementCommand.this.columnToModify = AddAutoIncrementCommand.this.listDialog.getSelectedColumnList()[0];
            AddAutoIncrementCommand.this.showCustomDialog();
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = AddAutoIncrementCommand.access$000().getString("AddAutoIncrementCommand.sqlDialogTitle");
    }
}

