#! /usr/pkg/bin/perl
# -*- indent-tabs-mode: nil; -*-
# vim:ft=perl:et:sw=4
# $Id$

# Sympa - SYsteme de Multi-Postage Automatique
#
# Copyright (c) 1997, 1998, 1999 Institut Pasteur & Christophe Wolfhugel
# Copyright (c) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
# 2006, 2007, 2008, 2009, 2010, 2011 Comite Reseau des Universites
# Copyright (c) 2011, 2012, 2013, 2014, 2015, 2016, 2017 GIP RENATER
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

use lib split(/:/, $ENV{SYMPALIB} || ''), '/usr/pkg/sympa/bin';
use strict;
use warnings;

use Conf;
use Sympa::Constants;
use Sympa::DatabaseManager;

## Load sympa config
Conf::load(Sympa::Constants::CONFIG) or die 'config_error';

chdir $Conf::Conf{'home'};

my $sdm = Sympa::DatabaseManager->instance
    or die 'Can\'t connect to database';

my $sth = $sdm->do_query(
    q{SELECT user_subscriber, comment_subscriber
      FROM subscriber_table}
) or die 'Unable to execute SQL statement';

my $user;

while ($user = $sth->fetchrow_hashref('NAME_lc')) {
    printf "\nUser: %s", $user->{'user_subscriber'};

    unless ($user->{'comment_subscriber'}) {
        my $sth2 = $sdm->do_prepared_query(
            q{SELECT gecos_user
              FROM user_table
              WHERE email_user = ?},
            $user->{'user_subscriber'}
        ) or die "Unable to execute SQL statement";

        my $gecos = $sth2->fetchrow;
        $sth2->finish();

        if ($gecos) {
            printf " =>%s", $gecos;
            my $sth2 = $sdm->do_prepared_query(
                q{UPDATE subscriber_table
                  SET comment_subscriber = ?
                  WHERE user_subscriber = ?},
                $gecos, $user->{'user_subscriber'}
            ) or die "Unable to execute SQL statement";
            $sth2->finish();
        }

    }
}

$sth->finish();

## Disconnect from Database
Sympa::DatabaseManager->disconnect();
