/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.jersey.resources;

import com.sun.jersey.api.json.JSONWithPadding;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.jersey.ZooKeeperService;
import org.apache.zookeeper.server.jersey.jaxb.ZChildren;
import org.apache.zookeeper.server.jersey.jaxb.ZChildrenJSON;
import org.apache.zookeeper.server.jersey.jaxb.ZError;
import org.apache.zookeeper.server.jersey.jaxb.ZPath;
import org.apache.zookeeper.server.jersey.jaxb.ZStat;

@Path(value="znodes/v1{path: /.*}")
public class ZNodeResource {
    private final ZooKeeper zk;

    public ZNodeResource(@DefaultValue(value="") @QueryParam(value="session") String session, @Context UriInfo ui, @Context HttpServletRequest request) throws IOException {
        String contextPath = request.getContextPath();
        if (contextPath.equals("")) {
            contextPath = "/";
        }
        if (session.equals("")) {
            session = null;
        } else if (!ZooKeeperService.isConnected(contextPath, session)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        this.zk = ZooKeeperService.getClient(contextPath, session);
    }

    private void ensurePathNotNull(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Invalid path \"" + path + "\"");
        }
    }

    @HEAD
    @Produces(value={"application/json", "application/javascript", "application/xml"})
    public Response existsZNode(@PathParam(value="path") String path, @Context UriInfo ui) throws InterruptedException, KeeperException {
        Stat stat = this.zk.exists(path, false);
        if (stat == null) {
            ZNodeResource.throwNotFound(path, ui);
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @HEAD
    @Produces(value={"application/octet-stream"})
    public Response existsZNodeAsOctet(@PathParam(value="path") String path, @Context UriInfo ui) throws InterruptedException, KeeperException {
        Stat stat = this.zk.exists(path, false);
        if (stat == null) {
            ZNodeResource.throwNotFound(path, ui);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Produces(value={"application/json", "application/javascript"})
    public Response getZNodeListJSON(@PathParam(value="path") String path, @QueryParam(value="callback") String callback, @DefaultValue(value="data") @QueryParam(value="view") String view, @DefaultValue(value="base64") @QueryParam(value="dataformat") String dataformat, @Context UriInfo ui) throws InterruptedException, KeeperException {
        return this.getZNodeList(true, path, callback, view, dataformat, ui);
    }

    @GET
    @Produces(value={"application/xml"})
    public Response getZNodeList(@PathParam(value="path") String path, @QueryParam(value="callback") String callback, @DefaultValue(value="data") @QueryParam(value="view") String view, @DefaultValue(value="base64") @QueryParam(value="dataformat") String dataformat, @Context UriInfo ui) throws InterruptedException, KeeperException {
        return this.getZNodeList(false, path, callback, view, dataformat, ui);
    }

    private Response getZNodeList(boolean json, String path, String callback, String view, String dataformat, UriInfo ui) throws InterruptedException, KeeperException {
        String dataUtf8;
        byte[] data64;
        this.ensurePathNotNull(path);
        if (view.equals("children")) {
            ArrayList<String> children = new ArrayList<String>();
            for (String child : this.zk.getChildren(path, false)) {
                children.add(child);
            }
            String childTemplate = ui.getAbsolutePath().toString();
            if (!childTemplate.endsWith("/")) {
                childTemplate = childTemplate + "/";
            }
            childTemplate = childTemplate + "{child}";
            Object child = json ? new ZChildrenJSON(path, ui.getAbsolutePath().toString(), childTemplate, children) : new ZChildren(path, ui.getAbsolutePath().toString(), childTemplate, children);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new JSONWithPadding(child, callback)).build();
        }
        Stat stat = new Stat();
        byte[] data = this.zk.getData(path, false, stat);
        if (data == null) {
            data64 = null;
            dataUtf8 = null;
        } else if (!dataformat.equals("utf8")) {
            data64 = data;
            dataUtf8 = null;
        } else {
            data64 = null;
            dataUtf8 = new String(data);
        }
        ZStat zstat = new ZStat(path, ui.getAbsolutePath().toString(), data64, dataUtf8, stat.getCzxid(), stat.getMzxid(), stat.getCtime(), stat.getMtime(), stat.getVersion(), stat.getCversion(), stat.getAversion(), stat.getEphemeralOwner(), stat.getDataLength(), stat.getNumChildren(), stat.getPzxid());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new JSONWithPadding((Object)zstat, callback)).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getZNodeListAsOctet(@PathParam(value="path") String path) throws InterruptedException, KeeperException {
        this.ensurePathNotNull(path);
        Stat stat = new Stat();
        byte[] data = this.zk.getData(path, false, stat);
        if (data == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)data).build();
    }

    @PUT
    @Produces(value={"application/json", "application/javascript", "application/xml"})
    @Consumes(value={"application/octet-stream"})
    public Response setZNode(@PathParam(value="path") String path, @QueryParam(value="callback") String callback, @DefaultValue(value="-1") @QueryParam(value="version") String versionParam, @DefaultValue(value="base64") @QueryParam(value="dataformat") String dataformat, @DefaultValue(value="false") @QueryParam(value="null") String setNull, @Context UriInfo ui, byte[] data) throws InterruptedException, KeeperException {
        int version;
        this.ensurePathNotNull(path);
        try {
            version = Integer.parseInt(versionParam);
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ZError(ui.getRequestUri().toString(), path + " bad version " + versionParam)).build());
        }
        if (setNull.equals("true")) {
            data = null;
        }
        Stat stat = this.zk.setData(path, data, version);
        ZStat zstat = new ZStat(path, ui.getAbsolutePath().toString(), null, null, stat.getCzxid(), stat.getMzxid(), stat.getCtime(), stat.getMtime(), stat.getVersion(), stat.getCversion(), stat.getAversion(), stat.getEphemeralOwner(), stat.getDataLength(), stat.getNumChildren(), stat.getPzxid());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new JSONWithPadding((Object)zstat, callback)).build();
    }

    @PUT
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/octet-stream"})
    public void setZNodeAsOctet(@PathParam(value="path") String path, @DefaultValue(value="-1") @QueryParam(value="version") String versionParam, @DefaultValue(value="false") @QueryParam(value="null") String setNull, @Context UriInfo ui, byte[] data) throws InterruptedException, KeeperException {
        int version;
        this.ensurePathNotNull(path);
        try {
            version = Integer.parseInt(versionParam);
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ZError(ui.getRequestUri().toString(), path + " bad version " + versionParam)).build());
        }
        if (setNull.equals("true")) {
            data = null;
        }
        this.zk.setData(path, data, version);
    }

    @POST
    @Produces(value={"application/json", "application/javascript", "application/xml"})
    @Consumes(value={"application/octet-stream"})
    public Response createZNode(@PathParam(value="path") String path, @QueryParam(value="callback") String callback, @DefaultValue(value="create") @QueryParam(value="op") String op, @QueryParam(value="name") String name, @DefaultValue(value="base64") @QueryParam(value="dataformat") String dataformat, @DefaultValue(value="false") @QueryParam(value="null") String setNull, @DefaultValue(value="false") @QueryParam(value="sequence") String sequence, @DefaultValue(value="false") @QueryParam(value="ephemeral") String ephemeral, @Context UriInfo ui, byte[] data) throws InterruptedException, KeeperException {
        this.ensurePathNotNull(path);
        path = path.equals("/") ? path + name : path + "/" + name;
        if (!op.equals("create")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ZError(ui.getRequestUri().toString(), path + " bad operaton " + op)).build());
        }
        if (setNull.equals("true")) {
            data = null;
        }
        CreateMode createMode = sequence.equals("true") ? (ephemeral.equals("false") ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.EPHEMERAL_SEQUENTIAL) : (ephemeral.equals("false") ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL);
        String newPath = this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        URI uri = ui.getAbsolutePathBuilder().path(newPath).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)new JSONWithPadding((Object)new ZPath(newPath, ui.getAbsolutePath().toString()))).build();
    }

    @POST
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/octet-stream"})
    public Response createZNodeAsOctet(@PathParam(value="path") String path, @DefaultValue(value="create") @QueryParam(value="op") String op, @QueryParam(value="name") String name, @DefaultValue(value="false") @QueryParam(value="null") String setNull, @DefaultValue(value="false") @QueryParam(value="sequence") String sequence, @Context UriInfo ui, byte[] data) throws InterruptedException, KeeperException {
        this.ensurePathNotNull(path);
        path = path.equals("/") ? path + name : path + "/" + name;
        if (!op.equals("create")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ZError(ui.getRequestUri().toString(), path + " bad operaton " + op)).build());
        }
        if (setNull.equals("true")) {
            data = null;
        }
        CreateMode createMode = sequence.equals("true") ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.PERSISTENT;
        String newPath = this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        URI uri = ui.getAbsolutePathBuilder().path(newPath).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)new ZPath(newPath, ui.getAbsolutePath().toString())).build();
    }

    @DELETE
    @Produces(value={"application/json", "application/javascript", "application/xml", "application/octet-stream"})
    public void deleteZNode(@PathParam(value="path") String path, @DefaultValue(value="-1") @QueryParam(value="version") String versionParam, @Context UriInfo ui) throws InterruptedException, KeeperException {
        int version;
        this.ensurePathNotNull(path);
        try {
            version = Integer.parseInt(versionParam);
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ZError(ui.getRequestUri().toString(), path + " bad version " + versionParam)).build());
        }
        this.zk.delete(path, version);
    }

    private static void throwNotFound(String path, UriInfo ui) throws WebApplicationException {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ZError(ui.getRequestUri().toString(), path + " not found")).build());
    }
}

