/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.servlets;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class JsonServlet
extends HttpServlet {
    abstract String handleRequest(JsonRequest var1) throws Exception;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain;charset=utf-8");
        response.setStatus(200);
        try {
            String req = request.getRequestURI().substring(request.getServletPath().length());
            response.getWriter().println(this.handleRequest(new JsonRequest((ServletRequest)request)));
        }
        catch (Exception e) {
            JSONObject o = new JSONObject();
            o.put((Object)"error", (Object)e.toString());
            response.getWriter().println(JSONValue.toJSONString((Object)o));
        }
        catch (OutOfMemoryError oom) {
            JSONObject o = new JSONObject();
            o.put((Object)"error", (Object)"Out of memory. Perhaps you've requested too many logs. Try narrowing you're filter criteria.");
            response.getWriter().println(JSONValue.toJSONString((Object)o));
        }
    }

    protected class JsonRequest {
        private Map map;

        public JsonRequest(ServletRequest request) {
            this.map = request.getParameterMap();
        }

        public long getNumber(String name, long defaultnum) {
            String[] vals = (String[])this.map.get(name);
            if (vals == null || vals.length == 0) {
                return defaultnum;
            }
            try {
                return Long.valueOf(vals[0]);
            }
            catch (NumberFormatException e) {
                return defaultnum;
            }
        }

        public String getString(String name, String defaultstr) {
            String[] vals = (String[])this.map.get(name);
            if (vals == null || vals.length == 0) {
                return defaultstr;
            }
            return vals[0];
        }
    }
}

