/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift;

import com.lmax.disruptor.EventFactory;
import com.thinkaurelius.thrift.State;
import com.thinkaurelius.thrift.util.ThriftFactories;
import com.thinkaurelius.thrift.util.mem.Buffer;
import com.thinkaurelius.thrift.util.mem.FastMemoryOutputTransport;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final Logger logger = LoggerFactory.getLogger(Message.class);
    public final TNonblockingTransport transport;
    public final ThriftFactories thriftFactories;
    private final SelectionKey selectionKey;
    private State state = State.READY_TO_READ_FRAME_SIZE;
    private Buffer dataBuffer;
    private Buffer frameSizeBuffer;
    private FastMemoryOutputTransport response;
    private final boolean useHeapBasedAllocation;
    private final boolean alwaysReallocateBuffers;

    public Message(TNonblockingTransport trans, SelectionKey key, ThriftFactories factories, boolean heapBasedAllocation, boolean reallocateBuffers) {
        this.frameSizeBuffer = Buffer.allocate(4, heapBasedAllocation);
        this.transport = trans;
        this.selectionKey = key;
        this.thriftFactories = factories;
        this.useHeapBasedAllocation = heapBasedAllocation;
        this.alwaysReallocateBuffers = reallocateBuffers;
    }

    public boolean isReadyToRead() {
        return (this.state == State.READY_TO_READ_FRAME_SIZE || this.state == State.READY_TO_READ_FRAME) && this.selectionKey.isReadable();
    }

    public boolean isReadyToWrite() {
        return this.state == State.READY_TO_WRITE && this.selectionKey.isWritable();
    }

    public boolean read() {
        if (this.state == State.READING_FRAME_SIZE) {
            if (!this.internalRead(this.frameSizeBuffer)) {
                return false;
            }
            if (this.frameSizeBuffer.remaining() == 0) {
                int frameSize = this.frameSizeBuffer.getInt(0);
                if (frameSize <= 0) {
                    logger.error("Read an invalid frame size of " + frameSize + ". Are you using TFramedTransport on the client side?");
                    return false;
                }
                if (frameSize > this.thriftFactories.maxFrameSizeInBytes) {
                    logger.error("Invalid frame size got (" + frameSize + "), maximum expected " + this.thriftFactories.maxFrameSizeInBytes);
                    return false;
                }
                this.reallocateDataBuffer(frameSize);
                this.frameSizeBuffer.clear();
                this.state = State.READING_FRAME;
            } else {
                this.state = State.READY_TO_READ_FRAME_SIZE;
                return true;
            }
        }
        if (this.state == State.READING_FRAME) {
            if (!this.internalRead(this.dataBuffer)) {
                return false;
            }
            this.state = this.dataBuffer.remaining() == 0 ? State.READ_FRAME_COMPLETE : State.READY_TO_READ_FRAME;
            return true;
        }
        logger.error("Read was called but state is invalid (" + (Object)((Object)this.state) + ")");
        return false;
    }

    public boolean isFrameFullyRead() {
        return this.state == State.READ_FRAME_COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        assert (this.state == State.WRITING);
        boolean writeFailed = false;
        try {
            if (this.response.streamTo(this.transport) < 0) {
                writeFailed = true;
                boolean bl = false;
                return bl;
            }
            if (!this.response.isFullyStreamed()) {
                this.switchToWrite();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            logger.error("Got an IOException during write!", (Throwable)e);
            writeFailed = true;
            boolean bl = false;
            return bl;
        }
        finally {
            if (writeFailed || this.response.isFullyStreamed()) {
                this.response.close();
            }
        }
        this.switchToRead();
        return true;
    }

    public void changeSelectInterests() {
        switch (this.state) {
            case READY_TO_WRITE: {
                this.state = State.WRITING;
                break;
            }
            case READY_TO_READ_FRAME_SIZE: {
                this.state = State.READING_FRAME_SIZE;
                break;
            }
            case READY_TO_READ_FRAME: {
                this.state = State.READING_FRAME;
                break;
            }
            case AWAITING_CLOSE: {
                this.close();
                this.selectionKey.cancel();
                break;
            }
            default: {
                logger.error("changeSelectInterest was called, but state is invalid (" + (Object)((Object)this.state) + ")");
            }
        }
    }

    public void responseReady() {
        if (this.response.size() == 0) {
            this.switchToRead();
            this.response.close();
        } else {
            this.switchToWrite();
        }
    }

    public void invoke() {
        assert (this.state == State.READ_FRAME_COMPLETE) : "Invoke called in invalid state: " + (Object)((Object)this.state);
        TTransport inTrans = this.getInputTransport();
        TProtocol inProt = this.thriftFactories.inputProtocolFactory.getProtocol(inTrans);
        TProtocol outProt = this.thriftFactories.outputProtocolFactory.getProtocol(this.getOutputTransport());
        try {
            this.thriftFactories.processorFactory.getProcessor(inTrans).process(inProt, outProt);
            this.responseReady();
            return;
        }
        catch (TException te) {
            logger.warn("Exception while invoking!", (Throwable)te);
        }
        catch (Throwable t) {
            logger.error("Unexpected throwable while invoking!", t);
        }
        this.state = State.AWAITING_CLOSE;
        this.changeSelectInterests();
    }

    private TTransport getInputTransport() {
        return this.dataBuffer.getInputTransport();
    }

    private TTransport getOutputTransport() {
        this.response = new FastMemoryOutputTransport(32, this.useHeapBasedAllocation);
        return this.thriftFactories.outputTransportFactory.getTransport((TTransport)this.response);
    }

    private boolean internalRead(Buffer buffer) {
        try {
            return buffer.readFrom(this.transport) >= 0;
        }
        catch (IOException e) {
            logger.warn("Got an IOException in internalRead!", (Throwable)e);
            return false;
        }
    }

    private void switchToRead() {
        this.switchMode(State.READY_TO_READ_FRAME_SIZE);
    }

    private void switchToWrite() {
        this.switchMode(State.READY_TO_WRITE);
    }

    private void switchMode(State newState) {
        this.state = newState;
        switch (newState) {
            case READY_TO_READ_FRAME_SIZE: {
                this.selectionKey.interestOps(1);
                break;
            }
            case READY_TO_WRITE: {
                this.selectionKey.interestOps(4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal state: " + (Object)((Object)newState));
            }
        }
        this.selectionKey.selector().wakeup();
    }

    private void freeDataBuffer() {
        if (this.dataBuffer == null) {
            return;
        }
        this.dataBuffer.free();
        this.dataBuffer = null;
    }

    private void reallocateDataBuffer(int newSize) {
        if (this.shouldReallocateBuffer(newSize)) {
            this.freeDataBuffer();
        }
        if (this.dataBuffer == null) {
            this.dataBuffer = Buffer.allocate(newSize, this.useHeapBasedAllocation);
        }
        this.dataBuffer.clear();
    }

    private boolean shouldReallocateBuffer(int newSize) {
        return this.alwaysReallocateBuffers || this.dataBuffer != null && this.dataBuffer.size() != newSize;
    }

    public void close() {
        this.freeDataBuffer();
        this.frameSizeBuffer.free();
        this.transport.close();
        if (this.response != null) {
            this.response.close();
        }
    }

    public void cancel() {
        this.close();
        this.selectionKey.cancel();
    }

    public static class Invocation {
        public static final EventFactory<Invocation> FACTORY = new EventFactory<Invocation>(){

            public Invocation newInstance() {
                return new Invocation();
            }
        };
        public Message message;

        public void setMessage(Message message) {
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }

        public void execute() {
            this.message.invoke();
        }
    }
}

