/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;

public abstract class AbstractMBean
implements DynamicMBean,
MBeanRegistration {
    protected static final String MBEAN_ATTR_TYPE = "type";
    protected static final short CACHED_30SEC = 0;
    protected static final short CACHED_5SEC = 1;
    protected static final short CACHED_500MS = 2;
    protected static final short CACHELESS = 3;
    protected static final short DEFAULT = 0;
    protected final Sigar sigarImpl;
    protected final SigarProxy sigar;
    protected MBeanServer mbeanServer;

    protected AbstractMBean(Sigar sigar, short cacheMode) {
        this.sigarImpl = sigar;
        this.sigar = cacheMode == 3 ? this.sigarImpl : (cacheMode == 2 ? SigarProxyCache.newInstance(this.sigarImpl, 500) : (cacheMode == 1 ? SigarProxyCache.newInstance(this.sigarImpl, 5000) : SigarProxyCache.newInstance(this.sigarImpl, 30000)));
    }

    public abstract String getObjectName();

    protected RuntimeException unexpectedError(String type, SigarException e) {
        String msg = "Unexected error in Sigar.get" + type + ": " + e.getMessage();
        return new IllegalArgumentException(msg);
    }

    public AttributeList getAttributes(String[] attrs) {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                result.add(new Attribute(attrs[i], this.getAttribute(attrs[i])));
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (MBeanException e) {
                continue;
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        return result;
    }

    public AttributeList setAttributes(AttributeList attrs) {
        AttributeList result = new AttributeList();
        for (int i = 0; i < attrs.size(); ++i) {
            try {
                Attribute next = (Attribute)attrs.get(i);
                this.setAttribute(next);
                result.add(next);
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (InvalidAttributeValueException e) {
                continue;
            }
            catch (MBeanException e) {
                continue;
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        return result;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        return new ObjectName(this.getObjectName());
    }

    public void postRegister(Boolean success) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.mbeanServer = null;
    }
}

