/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Pair;

public final class RowCacheKey
extends CacheKey {
    public final byte[] key;
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowCacheKey(null, ByteBufferUtil.EMPTY_BYTE_BUFFER));

    public RowCacheKey(Pair<String, String> ksAndCFName, byte[] key) {
        super(ksAndCFName);
        this.key = key;
    }

    public RowCacheKey(Pair<String, String> ksAndCFName, DecoratedKey key) {
        this(ksAndCFName, key.getKey());
    }

    public RowCacheKey(Pair<String, String> ksAndCFName, ByteBuffer key) {
        super(ksAndCFName);
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowCacheKey that = (RowCacheKey)o;
        return this.ksAndCFName.equals(that.ksAndCFName) && Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.ksAndCFName.hashCode();
        result = 31 * result + (this.key != null ? Arrays.hashCode(this.key) : 0);
        return result;
    }

    public String toString() {
        return String.format("RowCacheKey(ksAndCFName:%s, key:%s)", this.ksAndCFName, Arrays.toString(this.key));
    }
}

