/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.LogManager;
import org.apache.juli.logging.DirectJDKLog;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;

public class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    private static LogFactory singleton = new LogFactory();
    Properties logConfig;

    private LogFactory() {
        try {
            Class<?> clazz = Class.forName("java.nio.file.FileSystems");
            Method m = clazz.getMethod("getDefault", new Class[0]);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.logConfig = new Properties();
    }

    void setLogConfig(Properties p) {
        this.logConfig = p;
    }

    public Log getInstance(String name) throws LogConfigurationException {
        return DirectJDKLog.getInstance(name);
    }

    public void release() {
        DirectJDKLog.release();
    }

    public Object getAttribute(String name) {
        return this.logConfig.get(name);
    }

    public String[] getAttributeNames() {
        String[] result = new String[this.logConfig.size()];
        return this.logConfig.keySet().toArray(result);
    }

    public void removeAttribute(String name) {
        this.logConfig.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.logConfig.put(name, value);
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
        if (!LogManager.getLogManager().getClass().getName().equals("java.util.logging.LogManager")) {
            LogManager.getLogManager().reset();
        }
    }

    public static void releaseAll() {
        singleton.release();
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }
}

