/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.commons;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

public class CommonUtils {
    public static final String STRING_OUTPUT_TYPE_BASE64 = "base64";
    public static final String STRING_OUTPUT_TYPE_HEXADECIMAL = "hexadecimal";
    private static final List STRING_OUTPUT_TYPE_HEXADECIMAL_NAMES = Arrays.asList("HEXADECIMAL", "HEXA", "0X", "HEX", "HEXADEC");
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Boolean getStandardBooleanValue(String valueStr) {
        return BooleanUtils.toBooleanObject((String)valueStr);
    }

    public static String getStandardStringOutputType(String valueStr) {
        if (valueStr == null) {
            return null;
        }
        if (STRING_OUTPUT_TYPE_HEXADECIMAL_NAMES.contains(valueStr.toUpperCase())) {
            return STRING_OUTPUT_TYPE_HEXADECIMAL;
        }
        return STRING_OUTPUT_TYPE_BASE64;
    }

    public static String toHexadecimal(byte[] message) {
        if (message == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < message.length; ++i) {
            int curByte = message[i] & 0xFF;
            buffer.append(hexDigits[curByte >> 4]);
            buffer.append(hexDigits[curByte & 0xF]);
        }
        return buffer.toString();
    }

    public static byte[] fromHexadecimal(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() % 2 != 0) {
            throw new EncryptionOperationNotPossibleException();
        }
        try {
            byte[] result = new byte[message.length() / 2];
            for (int i = 0; i < message.length(); i += 2) {
                int first = Integer.parseInt("" + message.charAt(i), 16);
                int second = Integer.parseInt("" + message.charAt(i + 1), 16);
                result[i / 2] = (byte)(0 + ((first & 0xFF) << 4) + (second & 0xFF));
            }
            return result;
        }
        catch (Exception e) {
            throw new EncryptionOperationNotPossibleException();
        }
    }

    private CommonUtils() {
    }
}

