/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.xml.transform.Transform;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.schematron.OutputHandler;
import com.thaiopensource.validate.schematron.SchemaReaderImpl;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;

class ValidatorImpl
implements Validator {
    private final Templates templates;
    private final SAXTransformerFactory factory;
    private final ContentHandler outputHandler;
    private TransformerHandler transformerHandler;
    private final Resolver resolver;

    ValidatorImpl(Templates templates, SAXTransformerFactory sAXTransformerFactory, PropertyMap propertyMap) {
        this.templates = templates;
        this.factory = sAXTransformerFactory;
        ErrorHandler errorHandler = propertyMap.get(ValidateProperty.ERROR_HANDLER);
        this.outputHandler = new OutputHandler(errorHandler);
        this.resolver = ResolverFactory.createResolver(propertyMap).getResolver();
        this.initTransformerHandler();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.transformerHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.transformerHandler;
    }

    @Override
    public void reset() {
        this.initTransformerHandler();
    }

    private void initTransformerHandler() {
        try {
            this.transformerHandler = this.factory.newTransformerHandler(this.templates);
            if (!SchemaReaderImpl.isXsltc(this.factory.getClass())) {
                this.transformerHandler.getTransformer().setURIResolver(Transform.createSAXURIResolver(this.resolver));
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException("could not create transformer");
        }
        this.transformerHandler.setResult(new SAXResult(this.outputHandler));
    }
}

