.TH FBEXT 1 25-Jun-90
.CM 3
.SH NAME
fbext \- extract a rectangle from an image, resize, change aspect ratio
.SH SYNOPSIS
.nf
fbext [ -w<width> -h<height> -W<maxwdith> -H<maxheight>
        -s<size> -a<aspect> -t'title' -c'credits' ] [ -<type> ]
        [ x y [ width height ] ]     < bitmap > bitmap
.fi
.SH DESCRIPTION
.PP
Extract a rectangle from a bitmap and resize it.  There are lots of
arguments, but you'll typically only give it a few.  For example, you
should only specify two of width, height and aspect ratio, and it will
calculate the third.  The rectangle spec is given as 2 or 4 positional
arguments after the flags, and if omitted the entire input image is
copied.
.sp
The maximum width and height override all other size specifications, so
they can be used ot keep the results displayable on your screen.
.sp
When working with Amiga images, remember that the original input has an
aspect ratio of 1.2, so a common operation is "fbext -a1" which expands
the smaller dimension to give an output with an aspect ratio of 1.
.SH OPTIONS
.TP
.B -SPFB
.I output file format,
S=sun, P=pbm, F=fbm, B=face format.  Only one may be specified.
.TP
.B -a
.I aspect ratio,
specify desired output aspect ratio.
.TP
.B -w
.I width,
specify desired output width in pixels.
.TP
.B -h
.I height,
specify desired output height in pixels.
.TP
.B -s
.I size,
specify desired number of pixels in output (eg: 320x200 is 64000 pixels.
.TP
.B -W
.I maximum width,
of output.  The image will be expanded up to this size, keeping the
specified aspect ratio.
.TP
.B -H
.I maximum height.,
.TP
.BR -t'title'
.I title,
specify a character string (up to 80 characters) to describe the image.
The default is no title.
.TP
.BR -c'credits'
.I credits or subtitle,
specify a second character string (up to 80 characters) to describe the
image.  The default is no credit string.
.PP
.SH EXAMPLE
.PP
Suppose you have a GIF file with 320 by 200 pixels and an aspect ratio
of 1.2 (that is, it looks right at 320 by 240 pixels).  You want to
blow it up to fit your Sun screen (1152 by 900). You want the output
ratio adjusted to be 1.0 so it will look right on the Sun.
.sp
fbext -S -W1152 -H900 -a1.0 < foo.gif > foo.raster
.sp
You have an FBM format file 512 by 384 and you want to extract a
rectangle 300 by 200 from the middle:
.sp
fbext -F 106 92 300 200 < foo.fbm > bar.fbm
.sp
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
