/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.resources.ResourceManager;

public class FreeColImageBorder
extends AbstractBorder {
    public static final FreeColImageBorder imageBorder = new FreeColImageBorder();
    private final BufferedImage topLeftCornerImage;
    private final BufferedImage topImage;
    private final BufferedImage topRightCornerImage;
    private final BufferedImage rightImage;
    private final BufferedImage bottomRightCornerImage;
    private final BufferedImage bottomImage;
    private final BufferedImage bottomLeftCornerImage;
    private final BufferedImage leftImage;

    public FreeColImageBorder() {
        this(ResourceManager.getImage("image.menuborder.nw"), ResourceManager.getImage("image.menuborder.n"), ResourceManager.getImage("image.menuborder.ne"), ResourceManager.getImage("image.menuborder.e"), ResourceManager.getImage("image.menuborder.se"), ResourceManager.getImage("image.menuborder.s"), ResourceManager.getImage("image.menuborder.sw"), ResourceManager.getImage("image.menuborder.w"));
    }

    public FreeColImageBorder(BufferedImage topLeftCornerImage, BufferedImage topImage, BufferedImage topRightCornerImage, BufferedImage rightImage, BufferedImage bottomRightCornerImage, BufferedImage bottomImage, BufferedImage bottomLeftCornerImage, BufferedImage leftImage) {
        this.topLeftCornerImage = topLeftCornerImage;
        this.topImage = topImage;
        this.topRightCornerImage = topRightCornerImage;
        this.rightImage = rightImage;
        this.bottomRightCornerImage = bottomRightCornerImage;
        this.bottomImage = bottomImage;
        this.bottomLeftCornerImage = bottomLeftCornerImage;
        this.leftImage = leftImage;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, null);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int top = Math.max(Math.max(FreeColImageBorder.getHeight(this.topImage), FreeColImageBorder.getHeight(this.topLeftCornerImage)), FreeColImageBorder.getHeight(this.topRightCornerImage));
        int left = Math.max(Math.max(FreeColImageBorder.getWidth(this.leftImage), FreeColImageBorder.getWidth(this.topLeftCornerImage)), FreeColImageBorder.getWidth(this.bottomLeftCornerImage));
        int bottom = Math.max(Math.max(FreeColImageBorder.getHeight(this.bottomImage), FreeColImageBorder.getHeight(this.bottomLeftCornerImage)), FreeColImageBorder.getHeight(this.bottomRightCornerImage));
        int right = Math.max(Math.max(FreeColImageBorder.getWidth(this.rightImage), FreeColImageBorder.getWidth(this.topRightCornerImage)), FreeColImageBorder.getWidth(this.bottomRightCornerImage));
        if (this.topImage == null) {
            top = 0;
        }
        if (this.leftImage == null) {
            left = 0;
        }
        if (this.bottomImage == null) {
            bottom = 0;
        }
        if (this.rightImage == null) {
            right = 0;
        }
        if (insets == null) {
            return new Insets(top, left, bottom, right);
        }
        insets.top = top;
        insets.left = left;
        insets.bottom = bottom;
        insets.right = right;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(c);
        Graphics2D g2 = (Graphics2D)g;
        int topHeight = FreeColImageBorder.getHeight(this.topImage);
        int leftWidth = FreeColImageBorder.getWidth(this.leftImage);
        int bottomHeight = FreeColImageBorder.getHeight(this.bottomImage);
        int rightWidth = FreeColImageBorder.getWidth(this.rightImage);
        int topLeftCornerWidth = FreeColImageBorder.getWidth(this.topLeftCornerImage);
        int topLeftCornerHeight = FreeColImageBorder.getHeight(this.topLeftCornerImage);
        int topRightCornerWidth = FreeColImageBorder.getWidth(this.topRightCornerImage);
        int topRightCornerHeight = FreeColImageBorder.getHeight(this.topRightCornerImage);
        int bottomLeftCornerWidth = FreeColImageBorder.getWidth(this.bottomLeftCornerImage);
        int bottomLeftCornerHeight = FreeColImageBorder.getHeight(this.bottomLeftCornerImage);
        int bottomRightCornerWidth = FreeColImageBorder.getWidth(this.bottomRightCornerImage);
        int bottomRightCornerHeight = FreeColImageBorder.getHeight(this.bottomRightCornerImage);
        if (this.topImage != null) {
            ImageLibrary.fillTexture(g2, this.topImage, x + topLeftCornerWidth, y + insets.top - topHeight, width - topLeftCornerWidth - topRightCornerWidth, topHeight);
        }
        if (this.leftImage != null) {
            ImageLibrary.fillTexture(g2, this.leftImage, x + insets.left - leftWidth, y + topLeftCornerHeight, leftWidth, height - topLeftCornerHeight - bottomLeftCornerHeight);
        }
        if (this.bottomImage != null) {
            ImageLibrary.fillTexture(g2, this.bottomImage, x + bottomLeftCornerWidth, y + height - insets.bottom, width - bottomLeftCornerWidth - bottomRightCornerWidth, bottomHeight);
        }
        if (this.rightImage != null) {
            ImageLibrary.fillTexture(g2, this.rightImage, x + width - insets.right, y + topRightCornerHeight, rightWidth, height - topRightCornerHeight - bottomRightCornerHeight);
        }
        if (this.topLeftCornerImage != null) {
            ImageLibrary.fillTexture(g2, this.topLeftCornerImage, x + Math.max(insets.left, topLeftCornerWidth) - topLeftCornerWidth, y + Math.max(insets.top, topLeftCornerHeight) - topLeftCornerHeight, topLeftCornerWidth, topLeftCornerHeight);
        }
        if (this.topRightCornerImage != null) {
            ImageLibrary.fillTexture(g2, this.topRightCornerImage, x + width - Math.max(insets.right, topRightCornerWidth), y + Math.max(insets.top, topRightCornerHeight) - topRightCornerHeight, topRightCornerWidth, topRightCornerHeight);
        }
        if (this.bottomLeftCornerImage != null) {
            ImageLibrary.fillTexture(g2, this.bottomLeftCornerImage, x + Math.max(insets.left, bottomLeftCornerWidth) - bottomLeftCornerWidth, y + height - Math.max(insets.bottom, bottomLeftCornerHeight), bottomLeftCornerWidth, bottomLeftCornerHeight);
        }
        if (this.bottomRightCornerImage != null) {
            ImageLibrary.fillTexture(g2, this.bottomRightCornerImage, x + width - Math.max(insets.right, bottomRightCornerWidth), y + height - Math.max(insets.bottom, bottomRightCornerHeight), bottomRightCornerWidth, bottomRightCornerHeight);
        }
    }

    private static int getHeight(Image im) {
        return im == null ? 0 : im.getHeight(null);
    }

    private static int getWidth(Image im) {
        return im == null ? 0 : im.getWidth(null);
    }
}

