/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Specification;

public abstract class FreeColGameObjectType
extends FreeColObject
implements Named {
    private boolean abstractType;
    private FeatureContainer featureContainer = null;
    private int index = -1;
    private static final String ABSTRACT_TAG = "abstract";
    protected static final String DELETE_TAG = "delete";
    public static final String EXTENDS_TAG = "extends";
    public static final String PRESERVE_TAG = "preserve";

    protected FreeColGameObjectType() {
    }

    public FreeColGameObjectType(String id) {
        this(id, null);
    }

    public FreeColGameObjectType(Specification specification) {
        this(null, specification);
    }

    public FreeColGameObjectType(String id, Specification specification) {
        this.setId(id);
        this.setSpecification(specification);
    }

    @Override
    public final FeatureContainer getFeatureContainer() {
        if (this.featureContainer == null) {
            this.featureContainer = new FeatureContainer();
        }
        return this.featureContainer;
    }

    protected int getIndex() {
        return this.index;
    }

    protected final void setIndex(int index) {
        this.index = index;
    }

    public final String getDescriptionKey() {
        return Messages.descriptionKey(this.getId());
    }

    public final boolean isAbstractType() {
        return this.abstractType;
    }

    @Override
    public final String getNameKey() {
        return Messages.nameKey(this.getId());
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Ability ability : FreeColGameObjectType.getSortedCopy(this.getAbilities())) {
            ability.toXML(xw);
        }
        for (Modifier modifier : this.getSortedModifiers()) {
            modifier.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        if (this.getId() == null) {
            throw new XMLStreamException("Null id");
        }
        this.abstractType = xr.getAttribute(ABSTRACT_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers() && this.featureContainer != null) {
            this.featureContainer.clear();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (Ability.getXMLElementTagName().equals(tag)) {
            if (xr.getAttribute(DELETE_TAG, false)) {
                this.removeAbilities(xr.readId());
                xr.closeTag(Ability.getXMLElementTagName());
            } else {
                Ability ability = new Ability(xr, spec);
                if (ability.getSource() == null) {
                    ability.setSource(this);
                }
                this.addAbility(ability);
                spec.addAbility(ability);
            }
        } else if (Modifier.getXMLElementTagName().equals(tag)) {
            if (xr.getAttribute(DELETE_TAG, false)) {
                this.removeModifiers(xr.readId());
                xr.closeTag(Modifier.getXMLElementTagName());
            } else {
                Modifier modifier = new Modifier(xr, spec);
                if (modifier.getSource() == null) {
                    modifier.setSource(this);
                }
                this.addModifier(modifier);
                spec.addModifier(modifier);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }
}

