#############################################################################
##
#W  ctbllib.tst         GAP character table library             Thomas Breuer
##
#H  @(#)$Id: ctbllib.tst,v 1.5 2002/01/16 17:32:10 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##

gap> START_TEST("$Id: ctbllib.tst,v 1.5 2002/01/16 17:32:10 gap Exp $");

# Check that all ordinary tables can be loaded without problems
# and are internally consistent.
gap> AllCharacterTableNames( IsInternallyConsistent, false );
[  ]

# Check that all Brauer tables can be loaded without problems
# and are internally consistent.
# (This covers the tables that belong to the library via `MBT' calls
# as well as $p$-modular tables of $p$-solvable ordinary tables
# and tables of groups $G$ for which the Brauer table of $G/O_p(G)$ is
# contained in the library and the corresponding factor fusion is stored
# on the table of $G$.)
gap> brauernames:= function( ordtbl )
>       local primes;
>       primes:= Set( Factors( Size( ordtbl ) ) );
>       return List( primes, p -> Concatenation( Identifier( ordtbl ),
>                                     "mod", String( p ) ) );
> end;;
gap> AllCharacterTableNames( OfThose, brauernames,
>                            IsInternallyConsistent, false );
[  ]

# Check that all simple tables have this information stored.
gap> newsimple:= tbl -> not IsBound( tbl!.isSimple ) and IsSimple( tbl );;
gap> newsimple:= AllCharacterTableNames( newsimple, true );
[  ]
gap> if not IsEmpty( newsimple ) then 
>      Print( "new tables of simple groups:\n", newsimple, "\n" );
> fi;

gap> STOP_TEST( "ctbllib.tst", 200000000000 );

#############################################################################
##
#E

