/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jrcs.util.ToString;

public class Chunk
extends ToString {
    protected int anchor;
    protected int count;
    protected List chunk;

    public Chunk(int n, int n2) {
        this.anchor = n;
        this.count = n2 >= 0 ? n2 : 0;
    }

    public Chunk(Object[] objectArray, int n, int n2) {
        this(n, n2);
        this.chunk = Chunk.slice(objectArray, n, n2);
    }

    public Chunk(Object[] objectArray, int n, int n2, int n3) {
        this(n3, n2);
        this.chunk = Chunk.slice(objectArray, n, n2);
    }

    public Chunk(List list, int n, int n2) {
        this(n, n2);
        this.chunk = Chunk.slice(list, n, n2);
    }

    public Chunk(List list, int n, int n2, int n3) {
        this(n3, n2);
        this.chunk = Chunk.slice(list, n, n2);
    }

    public int anchor() {
        return this.anchor;
    }

    public int size() {
        return this.count;
    }

    public int first() {
        return this.anchor();
    }

    public int last() {
        return this.anchor() + this.size() - 1;
    }

    public int rcsfrom() {
        return this.anchor + 1;
    }

    public int rcsto() {
        return this.anchor + this.count;
    }

    public List chunk() {
        return this.chunk;
    }

    public boolean verify(List list) {
        if (this.chunk == null) {
            return true;
        }
        if (this.last() > list.size()) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (list.get(this.anchor + i).equals(this.chunk.get(i))) continue;
            return false;
        }
        return true;
    }

    public void applyDelete(List list) {
        for (int i = this.last(); i >= this.first(); --i) {
            list.remove(i);
        }
    }

    public void applyAdd(int n, List list) {
        Iterator iterator = this.chunk.iterator();
        while (iterator.hasNext()) {
            list.add(n++, iterator.next());
        }
    }

    public void toString(StringBuffer stringBuffer) {
        this.toString(stringBuffer, "", "");
    }

    public StringBuffer toString(StringBuffer stringBuffer, String string, String string2) {
        if (this.chunk != null) {
            Iterator iterator = this.chunk.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(string);
                stringBuffer.append(iterator.next());
                stringBuffer.append(string2);
            }
        }
        return stringBuffer;
    }

    public static List slice(List list, int n, int n2) {
        if (n2 <= 0) {
            return new ArrayList(list.subList(n, n));
        }
        return new ArrayList(list.subList(n, n + n2));
    }

    public static List slice(Object[] objectArray, int n, int n2) {
        return Chunk.slice(Arrays.asList(objectArray), n, n2);
    }

    public String rangeString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.rangeString(stringBuffer);
        return stringBuffer.toString();
    }

    public void rangeString(StringBuffer stringBuffer) {
        this.rangeString(stringBuffer, ",");
    }

    public void rangeString(StringBuffer stringBuffer, String string) {
        if (this.size() <= 1) {
            stringBuffer.append(Integer.toString(this.rcsfrom()));
        } else {
            stringBuffer.append(Integer.toString(this.rcsfrom()));
            stringBuffer.append(string);
            stringBuffer.append(Integer.toString(this.rcsto()));
        }
    }
}

