/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.commons.jrcs.util.ToString;

public class Revision
extends ToString {
    List deltas_ = new LinkedList();

    public synchronized void addDelta(Delta delta) {
        if (delta == null) {
            throw new IllegalArgumentException("new delta is null");
        }
        this.deltas_.add(delta);
    }

    public synchronized void insertDelta(Delta delta) {
        if (delta == null) {
            throw new IllegalArgumentException("new delta is null");
        }
        this.deltas_.add(0, delta);
    }

    public Delta getDelta(int n) {
        return (Delta)this.deltas_.get(n);
    }

    public int size() {
        return this.deltas_.size();
    }

    public Object[] patch(Object[] objectArray) throws PatchFailedException {
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        this.applyTo(arrayList);
        return arrayList.toArray();
    }

    public synchronized void applyTo(List list) throws PatchFailedException {
        ListIterator listIterator = this.deltas_.listIterator(this.deltas_.size());
        while (listIterator.hasPrevious()) {
            Delta delta = (Delta)listIterator.previous();
            delta.patch(list);
        }
    }

    public synchronized void toString(StringBuffer stringBuffer) {
        Iterator iterator = this.deltas_.iterator();
        while (iterator.hasNext()) {
            ((Delta)iterator.next()).toString(stringBuffer);
        }
    }

    public synchronized void toRCSString(StringBuffer stringBuffer, String string) {
        Iterator iterator = this.deltas_.iterator();
        while (iterator.hasNext()) {
            ((Delta)iterator.next()).toRCSString(stringBuffer, string);
        }
    }

    public void toRCSString(StringBuffer stringBuffer) {
        this.toRCSString(stringBuffer, Diff.NL);
    }

    public String toRCSString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toRCSString(stringBuffer, string);
        return stringBuffer.toString();
    }

    public String toRCSString() {
        return this.toRCSString(Diff.NL);
    }

    public void accept(RevisionVisitor revisionVisitor) {
        revisionVisitor.visit(this);
        Iterator iterator = this.deltas_.iterator();
        while (iterator.hasNext()) {
            ((Delta)iterator.next()).accept(revisionVisitor);
        }
    }
}

