/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff.myers;

public abstract class PathNode {
    public final int i;
    public final int j;
    public final PathNode prev;

    public PathNode(int n, int n2, PathNode pathNode) {
        this.i = n;
        this.j = n2;
        this.prev = pathNode;
    }

    public abstract boolean isSnake();

    public boolean isBootstrap() {
        return this.i < 0 || this.j < 0;
    }

    public final PathNode previousSnake() {
        if (this.isBootstrap()) {
            return null;
        }
        if (!this.isSnake() && this.prev != null) {
            return this.prev.previousSnake();
        }
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        PathNode pathNode = this;
        while (pathNode != null) {
            stringBuffer.append("(");
            stringBuffer.append(Integer.toString(pathNode.i));
            stringBuffer.append(",");
            stringBuffer.append(Integer.toString(pathNode.j));
            stringBuffer.append(")");
            pathNode = pathNode.prev;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

