/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search.context;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.TreeMap;
import org.opensolaris.opengrok.search.Hit;
import org.opensolaris.opengrok.web.Util;

public class PlainLineTokenizer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    private static final String ZZ_CMAP_PACKED = "\n\u0000\u0001\n\u0019\u0000\u0003\t\u0004\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0003\u0001\u0000\u0001\u0004\t\u0002\u0001\t\u0002\u0000\u0001\t\u0001\u0000\u0002\t\u0006\b\u0011\u0001\u0001\u0006\u0002\u0001\u0001\u0005\u0001\u0000\u0001\u0007\u0001\t\u0001\u0001\u0001\u0000\u0006\b\u0011\u0001\u0001\u0006\u0002\u0001\uff85\u0000";
    private static final char[] ZZ_CMAP = PlainLineTokenizer.zzUnpackCMap("\n\u0000\u0001\n\u0019\u0000\u0003\t\u0004\u0000\u0001\t\u0001\u0000\u0001\t\u0001\u0003\u0001\u0000\u0001\u0004\t\u0002\u0001\t\u0002\u0000\u0001\t\u0001\u0000\u0002\t\u0006\b\u0011\u0001\u0001\u0006\u0002\u0001\u0001\u0005\u0001\u0000\u0001\u0007\u0001\t\u0001\u0001\u0001\u0000\u0006\b\u0011\u0001\u0001\u0006\u0002\u0001\uff85\u0000");
    private static final int[] ZZ_ACTION = PlainLineTokenizer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0004\u0002\u0001\u0003\u0002\u0000\u0001\u0002\u0003\u0000\u0001\u0002";
    private static final int[] ZZ_ROWMAP = PlainLineTokenizer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u000b\u0000\u0016\u0000!\u0000\u000b\u0000,\u0000\u000b\u00007\u0000B\u00007\u0000M\u0000X\u0000c\u0000c";
    private static final int[] ZZ_TRANS = PlainLineTokenizer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0002\u0001\u0003\u0001\u0002\u0001\u0003\u0001\u0005\u0001\u0007\f\u0000\u0002\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0003\u0004\u0000\u0001\u0004\u0001\b\u0001\u0004\b\u0000\u0001\u0004\u0001\b\u0001\u0004\u0001\t\u0007\u0000\u0001\n\u0001\u0000\u0001\n\f\u0000\u0001\u000b\n\u0000\u0001\f\u000b\u0000\u0001\r\u0005\u0000\u0001\u000e\u0001\u0000\u0001\u000e\u0003\u0000\u0001\u000e\u0002\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = PlainLineTokenizer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\u0002\u0001\u0001\t\u0001\u0001\u0001\t\u0002\u0000\u0001\u0001\u0003\u0000\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private final StringBuilder markedContents = new StringBuilder();
    int markedPos = 0;
    int curLinePos = 0;
    int matchStart = -1;
    int markedLine = 0;
    int rest = 0;
    boolean wait = false;
    boolean dumpRest = false;
    Writer out;
    String url;
    TreeMap<Integer, String[]> tags;
    boolean prevHi = false;
    Integer prevLn = null;
    List<Hit> hits;
    Hit hit;
    StringBuilder sb;
    boolean alt;

    private static int[] zzUnpackAction() {
        int[] result = new int[14];
        int offset = 0;
        offset = PlainLineTokenizer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[14];
        int offset = 0;
        offset = PlainLineTokenizer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[110];
        int offset = 0;
        offset = PlainLineTokenizer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[14];
        int offset = 0;
        offset = PlainLineTokenizer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public void setWriter(Writer out) {
        this.yyline = 1;
        this.out = out;
    }

    public void setFilename(String filename) {
        this.url = filename;
        this.hit = new Hit(filename, null, null, false, this.alt);
    }

    public void setHitList(List<Hit> hits) {
        this.hits = hits;
    }

    public void setAlt(boolean alt) {
        this.alt = alt;
    }

    public void reInit(char[] buf, int len, Writer out, String url, TreeMap<Integer, String[]> tags) {
        this.reInit(new CharArrayReader(buf, 0, len), out, url, tags);
    }

    public void reInit(Reader in, Writer out, String url, TreeMap<Integer, String[]> tags) {
        this.yyreset(in);
        this.markedContents.setLength(0);
        this.wait = false;
        this.dumpRest = false;
        this.rest = 0;
        this.markedPos = 0;
        this.curLinePos = 0;
        this.matchStart = -1;
        this.markedLine = 0;
        this.yyline = 1;
        this.out = out;
        this.url = url;
        this.tags = tags;
        if (this.tags == null) {
            this.tags = new TreeMap();
        }
        this.prevHi = false;
    }

    public void holdOn() {
        if (!this.wait) {
            this.wait = true;
            this.matchStart = this.markedContents.length() - this.yylength();
        }
    }

    public void neverMind() {
        this.wait = false;
        if (!this.dumpRest) {
            this.markedPos = this.curLinePos;
            this.markedLine = this.yyline;
        }
        this.matchStart = -1;
    }

    private int printWithNum(int start, int end, int lineNo, boolean bold) throws IOException {
        if (bold) {
            this.out.write("<b>");
        }
        block6: for (int i = start; i < end; ++i) {
            char ch = this.markedContents.charAt(i);
            switch (ch) {
                case '\n': {
                    Integer ln = ++lineNo;
                    boolean hi = this.tags.containsKey(ln);
                    if (bold) {
                        this.out.write("</b>");
                    }
                    this.out.write("</a>");
                    if (this.prevHi) {
                        this.out.write(" <i> ");
                        String[] desc = this.tags.remove(this.prevLn);
                        this.out.write(desc[2]);
                        this.out.write(" </i>");
                    }
                    this.out.write("<br/>");
                    this.prevHi = hi;
                    this.prevLn = ln;
                    if (hi) {
                        this.out.write("<span class=\"h\">");
                    }
                    this.out.write("<a class=\"s\" href=\"");
                    this.out.write(this.url);
                    String num = String.valueOf(lineNo);
                    this.out.write(num);
                    this.out.write("\"><span class=\"l\">");
                    this.out.write(num);
                    this.out.write("</span> ");
                    if (!bold) continue block6;
                    this.out.write("<b>");
                    continue block6;
                }
                case '<': {
                    this.out.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.out.write("&gt;");
                    continue block6;
                }
                case '&': {
                    this.out.write("&amp;");
                    continue block6;
                }
                default: {
                    this.out.write(ch);
                }
            }
        }
        if (bold) {
            this.out.write("</b>");
        }
        return lineNo;
    }

    private int formatWithNum(int start, int end, int lineNo) {
        block6: for (int i = start; i < end; ++i) {
            char ch = this.markedContents.charAt(i);
            switch (ch) {
                case '\n': {
                    Integer ln = ++lineNo;
                    boolean hi = this.tags.containsKey(ln);
                    if (this.prevHi) {
                        String[] desc = this.tags.remove(this.prevLn);
                        this.hit.setTag(desc[2]);
                    }
                    this.prevHi = hi;
                    this.prevLn = ln;
                    this.sb.append(' ');
                    continue block6;
                }
                case '<': {
                    this.sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    this.sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    this.sb.append("&amp;");
                    continue block6;
                }
                default: {
                    this.sb.append(ch);
                }
            }
        }
        return lineNo;
    }

    public void printContext() throws IOException {
        if (this.sb == null) {
            this.sb = new StringBuilder();
        }
        if (this.hit == null) {
            this.hit = new Hit(this.url, null, null, false, this.alt);
        }
        this.wait = false;
        if (this.matchStart == -1) {
            this.matchStart = this.markedContents.length() - this.yylength();
        }
        if (this.curLinePos == this.markedPos) {
            Integer ln = this.markedLine;
            this.prevHi = this.tags.containsKey(ln);
            this.prevLn = ln;
            if (this.prevHi) {
                this.prevLn = ln;
            }
            if (this.out != null) {
                this.out.write("<a class=\"s\" href=\"");
                this.out.write(this.url);
                String num = String.valueOf(this.markedLine);
                this.out.write(num);
                this.out.write("\"><span class=\"l\">");
                this.out.write(num);
                this.out.write("</span> ");
            }
        }
        if (this.out != null) {
            this.markedLine = this.printWithNum(this.markedPos, this.matchStart, this.markedLine, false);
            this.markedLine = this.printWithNum(this.matchStart, this.markedContents.length(), this.markedLine, true);
        } else {
            this.markedLine = this.formatWithNum(this.markedPos, this.matchStart, this.markedLine);
            this.hit.setLineno(String.valueOf(this.markedLine));
            this.sb.append("<b>");
            this.markedLine = this.formatWithNum(this.matchStart, this.markedContents.length(), this.markedLine);
            this.sb.append("</b>");
        }
        this.markedContents.delete(0, this.curLinePos);
        this.curLinePos = 0;
        this.markedPos = this.markedContents.length();
        this.matchStart = -1;
        this.dumpRest = true;
        this.rest = this.markedPos;
    }

    public void dumpRest() throws IOException {
        block11: {
            if (this.dumpRest) {
                int maxLooks = 100;
                int i = 0;
                while (true) {
                    boolean newline;
                    boolean endOfBuffer = i >= this.markedContents.length() - this.rest;
                    boolean bl = newline = !endOfBuffer && this.markedContents.charAt(this.rest + i) == '\n';
                    if (endOfBuffer || newline || i >= 100) {
                        String[] desc;
                        if (this.out != null) {
                            this.printWithNum(this.rest, this.rest + i - 1, this.markedLine, false);
                            if (!newline && (i >= 100 || endOfBuffer && this.yychar + this.yylength() == 0x100000)) {
                                this.out.write(" (&hellip;)");
                            }
                            this.out.write("</a>");
                            if (this.prevHi) {
                                this.out.write(" <i> ");
                                desc = this.tags.remove(this.prevLn);
                                this.out.write(desc[2]);
                                this.out.write(" </i>");
                            }
                            this.out.write("<br/>");
                            break;
                        }
                        this.formatWithNum(this.rest, this.rest + i - 1, this.markedLine);
                        this.hit.setLine(this.sb.toString());
                        if (this.prevHi) {
                            desc = this.tags.remove(this.prevLn);
                            this.hit.setTag(desc[2]);
                        }
                        this.hits.add(this.hit);
                        break;
                    }
                    ++i;
                }
            }
            if (this.tags.size() <= 0) break block11;
            if (this.out != null) {
                for (Integer rem : this.tags.keySet()) {
                    String[] desc = this.tags.get(rem);
                    this.out.write("<a class=\"s\" href=\"");
                    this.out.write(this.url);
                    this.out.write(desc[1]);
                    this.out.write("\"><span class=\"l\">");
                    this.out.write(desc[1]);
                    this.out.write("</span> ");
                    this.out.write(Util.htmlize(desc[3]).replace(desc[0], "<b>" + desc[0] + "</b>"));
                    this.out.write("</a> <i> ");
                    this.out.write(desc[2]);
                    this.out.write(" </i><br/>");
                }
            } else {
                for (Integer rem : this.tags.keySet()) {
                    String[] desc = this.tags.get(rem);
                    this.hit = new Hit(this.url, "<html>" + Util.htmlize(desc[3]).replace(desc[0], "<b>" + desc[0] + "</b>"), desc[1], false, this.alt);
                    this.hit.setTag(desc[2]);
                    this.hits.add(this.hit);
                }
            }
        }
    }

    public PlainLineTokenizer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 64) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public String yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block13: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            block14: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        continue block14;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        continue block14;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block14;
                        }
                        ++this.yyline;
                        continue block14;
                    }
                    default: {
                        zzR = false;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.markedContents.append(this.yycharat(0));
                }
                case 4: {
                    continue block13;
                }
                case 2: {
                    String text = this.yytext();
                    this.markedContents.append(text);
                    return text;
                }
                case 5: {
                    continue block13;
                }
                case 3: {
                    this.markedContents.append(this.yycharat(0));
                    if (!this.wait) {
                        this.markedPos = this.markedContents.length();
                        this.markedLine = this.yyline + 1;
                        this.matchStart = -1;
                        this.curLinePos = this.markedPos;
                    }
                    if (this.dumpRest) {
                        String[] desc;
                        int endPos = this.markedContents.length() - this.yylength();
                        if (this.out != null) {
                            this.printWithNum(this.rest, endPos, this.markedLine, false);
                            this.out.write("</a>");
                            if (this.prevHi) {
                                this.out.write(" <i> ");
                                desc = this.tags.remove(this.prevLn);
                                this.out.write(desc[2]);
                                this.out.write("</i> ");
                            }
                            this.out.write("<br/>");
                        } else {
                            this.formatWithNum(this.rest, endPos, this.markedLine);
                            this.hit.setLine(this.sb.toString());
                            if (this.prevHi) {
                                desc = this.tags.remove(this.prevLn);
                                this.hit.setTag(desc[2]);
                            }
                            this.hits.add(this.hit);
                            this.sb.setLength(0);
                            this.hit = new Hit(this.url, null, null, false, this.alt);
                        }
                        this.dumpRest = false;
                    }
                    if (!this.wait) {
                        this.markedContents.setLength(0);
                        this.markedPos = 0;
                        this.curLinePos = 0;
                    }
                }
                case 6: {
                    continue block13;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

