/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.util;

import java.io.IOException;
import java.util.Arrays;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;

public class KerberosFlags {
    BitArray bits;
    protected static final int BITS_PER_UNIT = 8;

    public KerberosFlags(int n) throws IllegalArgumentException {
        this.bits = new BitArray(n);
    }

    public KerberosFlags(int n, byte[] byArray) throws IllegalArgumentException {
        this.bits = new BitArray(n, byArray);
        if (n != 32) {
            this.bits = new BitArray(Arrays.copyOf(this.bits.toBooleanArray(), 32));
        }
    }

    public KerberosFlags(boolean[] blArray) {
        this.bits = new BitArray(blArray.length == 32 ? blArray : Arrays.copyOf(blArray, 32));
    }

    public void set(int n, boolean bl) {
        this.bits.set(n, bl);
    }

    public boolean get(int n) {
        return this.bits.get(n);
    }

    public boolean[] toBooleanArray() {
        return this.bits.toBooleanArray();
    }

    public byte[] asn1Encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(this.bits);
        return derOutputStream.toByteArray();
    }

    public String toString() {
        return this.bits.toString();
    }
}

