<?php

###############################################################################
# french_canada.php
# This is a french language version for Geeklog!
#
#
# Copyright (C) 2003 Jean-Francois Allard
# jfallard@jfallard.com
#
# Original translation work by Florent Guiliani
# flyer@perinfo.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

$LANG_ISO639_1 = 'fr';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Contribution de:',
    2 => 'suppl&eacute;ment d\'info',
    3 => 'commentaires',
    4 => 'Modifier',
    5 => 'Contributed by: %s on %s',
    6 => 'Last modified on %s',
    7 => '',
    8 => '',
    9 => 'Fonctions Admin:',
    10 => 'Propositions',
    11 => 'Articles',
    12 => 'Blocs',
    13 => 'Sujets',
    14 => 'Command &amp; Control',
    15 => '',
    16 => '',
    17 => 'Membres',
    18 => 'Requête SQL',
    19 => 'Se d&eacute;connecter',
    20 => 'Infos personnelles:',
    21 => 'Nom d\'utilisateur',
    22 => 'Num&eacute;ro d\'utilisateur:',
    23 => 'Niveau de s&eacute;curit&eacute;',
    24 => 'Anonyme',
    25 => 'R&eacute;pondre',
    26 => 'Ce site n\'est pas responsable du contenu des commentaires. Ceux-ci sont de la responsabilit&eacute; des auteurs',
    27 => 'Commentaire le plus r&eacute;cent',
    28 => 'Effacer',
    29 => 'Aucuns commentaires.',
    30 => 'Vieux articles',
    31 => 'Balises HTML autoris&eacute;es:',
    32 => 'Erreur: Nom d\'utilisateur erron&eacute;',
    33 => 'Erreur: Impossibilit&eacute; d\'enregistrer la r&eacute;f&eacute;rence',
    34 => 'Erreur',
    35 => 'Se d&eacute;connecter',
    36 => 'sur',
    37 => 'Aucun article d\'utilisateur',
    38 => '(CNT 38)',
    39 => 'Rafra&icirc;chir',
    40 => 'Error in password request, invalid username',
    41 => 'Visiteur(s)',
    42 => 'Cr&eacute;&eacute; par:',
    43 => 'Pour y r&eacute;pondre',
    44 => 'Parent',
    45 => 'Num&eacute;ro d\'erreur MySQL',
    46 => 'Message d\'erreur MySQL',
    47 => 'Espace Membres',
    48 => 'Informations personnelles',
    49 => 'Pr&eacute;f&eacute;rences d\'affichage',
    50 => 'Erreur dans la requête SQL',
    51 => 'aide',
    52 => 'Nouveau',
    53 => 'Centre administratif',
    54 => 'Fichier impossible &agrave; ouvrir.',
    55 => 'Erreur &agrave;',
    56 => 'Voter',
    57 => 'Mot de passe',
    58 => 'Connexion',
    59 => "Pas encore de compte?  Enregistrez-vous comme <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">nouveau membre</a>",
    60 => 'Ajouter un commentaire',
    61 => 'Cr&eacute;er un nouveau compte',
    62 => 'mots',
    63 => 'Commentaires pr&eacute;f&eacute;r&eacute;s',
    64 => 'Envoyer cet article &agrave; un ami',
    65 => 'Version imprimable',
    66 => '',
    67 => 'Bienvenue chez ',
    68 => 'entr&eacute;e',
    69 => 'contact',
    70 => 'chercher',
    71 => 'contribuer',
    72 => 'ressources internet',
    73 => '',
    74 => '',
    75 => 'recherche avanc&eacute;e',
    76 => 'statistiques du site',
    77 => 'Plugins',
    78 => '',
    79 => 'Quoi de neuf ?',
    80 => 'derniers articles',
    81 => 'dernier article',
    82 => 'heures',
    83 => 'COMMENTAIRES',
    84 => '',
    85 => 'derni&egrave;res 48 heures',
    86 => 'Pas de nouveau commentaires',
    87 => '2 derni&egrave;res semaines',
    88 => '',
    89 => '',
    90 => 'Entr&eacute;e',
    91 => 'Page g&eacute;n&eacute;r&eacute;e en',
    92 => 'secondes',
    93 => 'Tout droits r&eacute;serv&eacute;s',
    94 => 'Toutes les marques cit&eacute;es apartiennent &agrave; leurs propri&eacute;taires respectifs.',
    95 => 'G&eacute;n&eacute;r&eacute; par',
    96 => 'Groupes',
    97 => 'Liste de mots',
    98 => 'Plug-ins',
    99 => 'ARTICLES',
    100 => 'Pas de nouveaux articles',
    101 => 'There are no older articles',
    102 => '',
    103 => 'Sauvegarde de la BDD',
    104 => 'par',
    105 => 'Courriel aux membres',
    106 => 'Vu',
    107 => 'MAJ de GL',
    108 => 'Vider la cache',
    109 => 'Report abuse',
    110 => 'Report this post to the site admin',
    111 => '',
    112 => 'Registered Users',
    113 => 'Documentation',
    114 => 'TRACKBACKS',
    115 => 'No new trackback comments',
    116 => 'Trackback',
    117 => 'Directory',
    118 => 'Please continue reading on the next page:',
    119 => "Lost your <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">password</a>?",
    120 => 'Permanent link to this comment',
    121 => 'Commetaires (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'All HTML is allowed',
    124 => 'Click to delete all checked items',
    125 => 'Are you sure you want to Delete all checked items?',
    126 => 'Select or de-select all items',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    140 => 'Allowed Autotags:',
    141 => 'An Error Occurred',
    142 => 'Unfortunately, an error has occurred rendering this page. Please try again later.',
    143 => 'Commetaire (%d)',
    144 => 'Parse Error.  An error occurred while parsing PHP code.',
    'loginform' => "<a href=\"{$_CONF['site_url']}/users.php\">Login Here</a>",
    'remoteloginoptions' => 'Remote Login Options',
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn',
    'google' => 'Login with Google',
    'microsoft' => 'Login with Microsoft',
    'yahoo' => 'Login with Yahoo',
    'github' => 'Login with GitHub',
    'ctl' => 'Clear Cache',
    'ok' => 'OK',
    'filemanager' => 'File Manager',
    'error_invalid_password' => 'Error, invalid password for username',
    'error_filemanager_disabled' => 'Filemanager is disabled',
    'terms_of_use' => 'Terms of Use',
    'terms_of_service' => 'Terms of Service',
    'privacy_policy' => 'Privacy Policy',
    'about_cookies' => 'About Cookies',
    'parse_php_error' => 'There was an error parsing your PHP code: %s',
    'error_title' => 'An Error Occurred'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Ajouter un commentaire',
    2 => 'Format',
    3 => 'Se d&eacute;connecter',
    4 => 'Cr&eacute;er un compte',
    5 => 'Nom d\'utilisateur',
    6 => 'This site requires you to be logged in to post a comment. If you have an account already (or need to create one), please <a href="%s">login here</a>.',
    7 => 'Votre dernier commentaire &eacute;tait il y a ',
    8 => " secondes. Vous devez attendre au moins {$_CONF['commentspeedlimit']} secondes entre chaque commentaire.",
    9 => 'Commenter',
    10 => 'CNT 10',
    11 => 'Envoyer le commentaire',
    12 => 'Vous devez obligatoirement compl&eacute;ter les champs Titre et Commentaire avant d\'envoyer.',
    13 => 'Vos infos',
    14 => 'Aper&ccedil;u',
    15 => 'CNT 15',
    16 => 'Titre',
    17 => 'Erreur',
    18 => 'Remarque importante',
    19 => 'Essayez de respecter le sujet de l\'article dans votre r&eacute;ponse.',
    20 => 'Essayez de r&eacute;pondre aux commentaires des autres plut&ocirc;t qu\'&agrave; l\'article lui même.',
    21 => 'Lisez tous les messages des autres avant d\'envoyer votre propre message afin faire de r&eacute;p&eacute;tition.',
    22 => 'Veuillez utiliser un titre en lien avec votre message.',
    23 => 'Votre adresse courriel NE SERA PAS rendue publique.',
    'instr_line6' => 'When logged in as a user your comments will be linked to your account and you can specify if you would like notifications of any replies.',
    24 => 'Utilisateur anonyme',
    25 => 'Are you sure you want to report this post to the site admin?',
    26 => '%s reported the following abusive comment post:',
    27 => 'Abuse report',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment.",
    100 => 'Comment Manager',
    101 => 'Existing Comments',
    102 => 'Bulk Action',
    103 => 'Ban this user',
    104 => 'Ban this IP address with the Spamx plugin',
    105 => 'IP Address',
    106 => 'Perform bulk action on comments and comment submissions including approval, deleting, and banning of user or IP address.',
    'record_edit' => 'Record user and time of edit?',
    'ban_plugin_ban_ip' => 'Ban this IP address with the Ban plugin',
    'num_comments' => '%s Comment(s)',
    'anon_user_name' => '%s (Anonymous User)',
    'comments_closed_msg' => 'Comments are closed and no new posts are allowed.',
    'read_comment' => 'Read the full comment at',
    'comment_for' => 'The above comment is for the following item',
    'comment_page_title' => 'Comments for %s',
    'comments' => 'Comments'
);

###############################################################################
# usersettings.php

$LANG04 = array(
    1 => 'Profil membre de',
    2 => 'Nom d\'utilisateur',
    3 => 'Nom complet',
    4 => 'Mot de passe',
    5 => 'Courriel',
    6 => 'Site Internet',
    7 => 'Biographie',
    8 => 'Cl&eacute; PGP',
    9 => 'Mettre &agrave; jour',
    10 => 'Les 10 derniers commentaires de l\'utilisateur',
    11 => 'Aucun commentaire',
    12 => 'Pr&eacute;f&eacute;rences d\'utilisation de',
    13 => 'Courriel temporis&eacute; la nuit',
    14 => 'Ce mot de passe a &eacute;t&eacute; g&eacute;n&eacute;r&eacute; automatiquement. Il est recommend&eacute; que vous le changiez imm&eacute;diatement. Pour ce faire, connectez-vous et cliquez sur &laquo;informations personnelles&raquo; dans le menu &laquo;membre&raquo;.',
    15 => "Votre compte, nomm&eacute; {$_CONF['site_name']}, a &eacute;t&eacute; cr&eacute;&eacute; avec succ&egrave;s. Vous devez utiliser les informations ci-dessous pour vous connecter. Veuillez sauvegarder ce message pour vous y r&eacute;f&eacute;rer.",
    'email_convert_remote' => "Your {$_CONF['site_name']} remote account has been converted to a local account. To continue to use your account, you must login using the information below. Please save this mail for further reference.",
    16 => 'Informations sur votre compte',
    17 => 'Ce compte n\'existe pas',
    18 => 'L\'adresse courriel semble ne pas être valide.',
    19 => 'L\'adresse courriel fournie est d&eacute;ja utilis&eacute;e par un autre membre.',
    20 => 'L\'adresse courriel fournie ne semble pas être valide.',
    21 => 'Erreur',
    22 => "Enregistrez-vous avec {$_CONF['site_name']}!",
    23 => "Apres avoir cr&eacute;&eacute; votre compte {$_CONF['site_name']} vous pourrez envoyer des commentaires et d'autres &eacute;l&eacute;ments. Si vous n'avez pas de compte, vous ne pourrez seulement qu'envoyer des commentaires anonymes. Votre adresse courriel ne sera jamais publi&eacute;e sur ce site.",
    24 => 'Le mot de passe vous sera envoy&eacute; par courriel &agrave; l\'adresse enregistr&eacute;e.',
    25 => 'Avez-vous oubli&eacute; votre mot de passe?',
    26 => 'Saisissez <em>soit</em> votre nom d\'utilisateur <em>soit</em> l\'adresse courriel enregistr&eacute;e &agrave; ce compte, et cliquez &laquo;Envoi du mot de passe&raquo;. Des instructions &agrave; suivre concernant l\'enregistrement d\'un nouveau mot de passe vous seront adress&eacute;es par courriel.',
    27 => 'Enregistrez-vous maintenant!',
    28 => 'Envoi du mot de passe',
    29 => 'd&eacute;connect&eacute; de',
    30 => 'connect&eacute; &agrave;',
    31 => 'Vous devez être connect&eacute; pour ex&eacute;cuter cette fonction',
    32 => 'Signature',
    33 => 'Jamais affich&eacute;e publiquement',
    34 => 'Votre nom v&eacute;ritable',
    35 => 'Entrez votre mot de passe afin de le changer',
    36 => 'Commence par http://',
    37 => 'Appliquer &agrave; vos commentaires',
    38 => 'Tout sur vous! Accessible par tous',
    39 => 'Votre cl&eacute; puplique PGP &agrave; partager',
    42 => 'Format de date',
    43 => 'Nombre maximal d\'articles',
    48 => 'Sujets',
    52 => 'Par d&eacute;faut',
    53 => 'Recevoir les articles du jour chaque nuit',
    56 => 'Auteur',
    57 => 'Format',
    58 => 'Ordre de tri',
    59 => 'Nombre maximum de commentaires',
    60 => 'Comment souhaitez vous que vos commentaires appara&icirc;ssent?',
    61 => 'Les plus r&eacute;cents ou les plus anciens en premier?',
    62 => '100 par d&eacute;faut',
    63 => "Votre mot de passe vous a &eacute;t&eacute; envoy&eacute; par courriel et ne devrait pas tarder. Suivez les instructions du message et encore merci d'utiliser {$_CONF['site_name']}",
    64 => 'Pr&eacute;f&eacute;rences des commentaires pour',
    65 => 'Essayez de vous connecter &agrave; nouveau',
    66 => "Vous avez peut-être mal saisi le nom de votre compte. Essayer encore de vous connecter &agrave; l'aide du formulaire ci-dessous. Pas encore membre? Inscrivez-vous comme <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">ici</a>?",
    67 => 'Membre depuis',
    68 => 'S\'en souvenir pour moi',
    69 => 'Combien de temps devrions-nous garder votre connection  active?',
    'cookietimeout_tooltip' => 'This site will remember you are logged in from the device you are currently using regardless of if your account has been logged out automatically due to no activity. Accounts are logged out after being inactive for %s seconds (this is called the "User Session Timeout"). When "Remember Me For" is set for your account it will include the time you select here PLUS the "User Session timeout".',
    70 => "Personnaliser l'aspect et le contenu de {$_CONF['site_name']}",
    71 => "Une fonctionnalit&eacute; int&eacute;ressante de {$_CONF['site_name']} est que vous pouvez en personnaliser l'aspect et le contenu. Afin de pouvoir utiliser ces fonctionnalit&eacute;s vous devez vous <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">enregistrer</a> au pr&egrave;s de {$_CONF['site_name']}.  Vous êtes d&eacute;j&agrave; membre?  Alors utilisez la passerelle de connection dans la barre de gauche pour vous connecter!",
    72 => 'Aspect',
    73 => 'Langue',
    74 => 'Changez l\'aspect de ce site!',
    75 => 'Envoyez des courriel &agrave; ces sujets',
    76 => 'Si vous s&eacute;lectionnez un (des) sujet(s) parmi ceux ci-dessous, vous recevrez par courriel &agrave; la fin de chaque journ&eacute;e (vers 22H) les nouveaux articles concerant ces sujets. Choisissez uniquement les sujets qui vous int&eacute;ressent !',
    77 => 'Photo',
    78 => 'Ajouter votre propre photo!',
    79 => 'Cochez ici pour effacer cette photo',
    80 => 'Nom de connexion',
    81 => 'Envoyer courriel',
    82 => '10 derniers article du membre',
    83 => 'Statistiques du membre',
    84 => 'Nombre total d\'articles:',
    85 => 'Nombre total de commentaires:',
    86 => 'Chercher les articles par',
    87 => 'Votre nom de membre',
    88 => "Quelqu'un (possiblement vous-même) avez demand&eacute; un nouveau mot de passe pour le compte '%s' sur {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nSi vous d&eacute;sirez r&eacute;ellement que cette action soit entreprise, nous vous prions de cliquer sur ce lien:\n\n",
    'user_password_action_msg' => 'If you really want this action to be taken, please click on the following link:',
    89 => "Pour refuser d\'entreprendre cette action, vous n\'avez simplement qu\'&agrave; ignorer ce message, ainsi aucune nouvelle action ne sera alors entreprise (votre mot de passe demeurera inchang&eacute;).\n\n",
    90 => 'Vous pouvez choisir un nouveau mot de passe pour le compte ci-dessous. Pri&egrave;re de noter que l\'ancien mot de passe demeurera actif jusqu\'&agrave; ce que vous soumettiez ce formulaire.',
    91 => 'R&eacute;glez le nouveau mot de passe',
    92 => 'Entrez le nouveau mot de passe',
    93 => 'Votre derni&egrave;re requête pour l\'obtention d\'un nouveau mot de passe &eacute;tait il y a %d secondes de cela. Ce site requiers que s\'&eacute;coule au moins %d secondes entre les requêtes de nouveaux mots de passe.',
    94 => 'Effacer le compte "%s"',
    96 => 'effacer le compte',
    97 => 'Confirmez l\'effacement de votre compte',
    98 => 'Êtes-vous certain de vouloir effacer ce compte? Car ce faisant, vous ne pourrez alors plus acc&eacute;der aux fonctions de ce site (sauf en cr&eacute;ant un nouveau compte). Si vous en êtes certain, cliquez alors sur "effacer le compte" une derni&egrave;re fois ci-dessous.',
    99 => 'Options de s&eacute;curit&eacute; pour',
    100 => '&eacute;crivez &agrave; l\'administrateur du site',
    101 => 'Autorisez les courriels provenant de l\'administrateur du site',
    102 => 'Courriels des membres',
    103 => 'Allouez la r&eacute;ception de courriels provenant d\'autre membres',
    104 => 'Affichez votre pr&eacute;sence en ligne',
    105 => 'Affichez ma pr&eacute;sence dans le bloc &laquo;En ligne&raquo;',
    106 => 'Location',
    107 => 'Shown in your public profile',
    108 => 'Confirm new password',
    109 => 'Enter the New password again here',
    110 => 'Current Password',
    111 => 'Please enter your Current password',
    112 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    113 => 'Login Attempt Failed',
    114 => 'Account Disabled',
    115 => 'Your account has been disabled, you may not login. Please contact an Administrator.',
    116 => 'Account Awaiting Activation',
    117 => 'Your account is currently awaiting activation by an administrator. You will not be able to login until your account has been approved.',
    118 => '',
    119 => '',
    120 => 'Account Activated',
    121 => 'Service',
    122 => 'Sorry, new user registration is disabled',
    123 => "Are you a <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">new user</a>?",
    124 => 'Confirm Email',
    125 => 'You have to enter the same email address in both fields!',
    126 => 'Please repeat for confirmation',
    127 => 'To change any of these settings, you will have to enter your current password.',
    128 => 'Your Name',
    129 => 'Password &amp; Email',
    130 => 'About You',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Comment Display',
    134 => 'Comment Options',
    135 => '<li>Default mode for how comments will be displayed</li><li>Default order to display comments</li><li>Set maximum number of comments to show - default is 100</li>',
    138 => 'Misc Settings',
    139 => 'Layout and Language',
    140 => '<li>No Topic Icons if checked will not display the article topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics</li><li>Set the maximum number of articles to show per page</li><li>Set your theme, timezone and preferred date format</li>',
    141 => 'Privacy Settings',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    145 => 'Your Public Profile',
    146 => 'Password and email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'User Information',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => '',
    156 => 'Delete Account',
    157 => 'Delete Option',
    158 => 'Time Zone',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services',
    169 => 'User has updated his/her profile',
    170 => "Admin at {$_CONF['site_name']} changed the password of your account as follows.  Please save this mail for further reference.",
    171 => 'Post mode for "Signature" and "Bio".',
    'user_login' => 'User Login',
    'user_login_message' => 'Please login below. You must enter both a username and password.',
    'user_remote_login_desc_long' => 'Click on one of the button(s) below to login and/or register via an account you have on another supported remote service. Please note, you must have an account on the remote service. If you are creating a new account on this website, then the remote service may ask you to give this website permissions to access information like your name, email address, and profile photo.',
    'remote_register_instructions' => "<strong>Please note:</strong> To register and create an account via Remote Login, please visit the <a href=\"{$_CONF['site_url']}/users.php\" rel=\"nofollow\">User Login</a>.",
    'user_logged_in_message' => "You are already logged in. Whould you like to <a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">logout</a>?",
    'user_max_login_attempts' => 'Max Login Attempts and Speed Limit Reached',
    'tfa_two_factor_auth' => 'Two Factor Authentication',
    'tfa_help1' => 'Make sure to install "Google Authenticator" application on your mobile device before you enable Two Factor Authentication.',
    'tfa_help2' => 'Enable Two Factor Authentication.',
    'tfa_help3' => 'Run "Google Authenticator", tap on the plus icon and scan the QR code.',
    'tfa_help4' => 'Print or download the backup codes below in case you cannot use your mobile device you installed the Google Authenticator.  Each backup code is valid only one-time.  If you generate a new set of backup codes, then the current set will be invalid.',
    'tfa_help5' => 'Hit the "Save" button at the bottom of the screen.',
    'tfa_enter_code' => 'Enter the %d-digit code your Google Authenticator app is showing or one of the backup code you have got in your preference page.',
    'tfa_backup_code_desc' => 'Note: You can only use a backup code once, then it becomes invalid. Remember to generate more backup codes from the user preference page if you are getting low.',
    'tfa_code' => 'Google Authenticator Code',
    'tfa_authenticate' => 'Authenticate',
    'tfa_qrcode' => 'QR Code',
    'tfa_show_hide' => 'Show/Hide',
    'tfa_backup_code' => 'Backup Codes',
    'tfa_download' => 'Download Backup Codes',
    'tfa_new_backup_code' => 'Generate a new set of backup codes',
    'tfa_generate_confirm' => 'Go ahead?',
    'lang_tfa_user_edit_desc' => 'You are only allowed to disable Two Factor Authentication (2FA) from this form if needed (like the user does not have their backup codes). It should not be enabled by Admins as the user themselves are required to enable and setup 2FA from their Account, including the Google Authenticator App for their phone and coping the backup codes.',
    'desc_new_pwd_status' => 'You are required to enter a new password for your account. You can enter a new password for your account below. <em>Please note you will not be able to do anything with your account until your password is updated.</em>',
    'new_email' => 'New Email',
    'set_new_email' => 'Set New Email',
    'confirm_new_email' => 'Confirm new email',
    'enter_new_email' => 'Enter New Email',
    'desc_new_email_status' => 'You are required to enter a new email address for your account. You can enter a new email for your account below. <em>Please note you will not be able to do anything with your account until your email is updated and verified.</em>',
    'email_msg_email_status_1' => "You have updated your email address for your account \"%s\" on {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\nPlease click on the following link to verify this email address:\n\n",
    'email_msg_verify' => 'Please click on the following link to verify this email address:',
    'email_msg_email_status_2' => "If you do not verify this email address and you log into your account you will be required to enter a new email address and go through this email verification process again.\n\n",
    'email_verify' => 'New Email to be Verified',
    'email_verify_delete' => 'Delete email to be verified',
    'email_verify_msg' => "You have previously updated your email address for your account but it still needs to be verified. Please check your email account for an email from {$_CONF['site_name']} that contains a verification link. Once you click on that link your new email address will be verified and your account will be updated to use it.<br" . XHTML . "><br" . XHTML . ">If you wish you may update the new email to be verified with the email fields above or you can delete it.",
    'remove_account_msg' => 'To remove your account from our database, enter your current password into the above "Current Password", check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'remove_remote_account_msg' => 'To remove your remote account from our database, check the checkbox next to "Delete Option" below and click on "Save" . Please note that any articles and comments you posted under this account will <strong>not</strong> be deleted but show up as being posted by "Anonymous".',
    'theme_info' => '%1$s %2$s (requires Geeklog %3$s)'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Aucun article &agrave; afficher',
    2 => 'Il n\'y a pas de nouveaux articles &agrave; afficher. Il n\'y a peut-être pas de nouveaut&eacute;s pour ce sujet ou alors vos pr&eacute;f&eacute;rences sont trop restrictives.',
    3 => '',
    4 => 'Article du jour',
    5 => 'Suivant',
    6 => 'Pr&eacute;c&eacute;dent',
    7 => 'First',
    8 => 'Last',
    9 => 'Page navigation'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Une erreur s\'est produite lors de l\'envoi de votre message. Veuillez r&eacute;essayer.',
    2 => 'Message a &eacute;t&eacute; envoy&eacute; avec succ&egrave;s.',
    3 => 'V&eacute;rifiez que l\'adresse du champ &laquo;r&eacute;pondre &agrave;&raquo; est valide.',
    4 => 'Veuillez compl&eacute;ter les champs: &laquo;Votre nom&raquo;, &laquo;r&eacute;ponse &agrave;&raquo;, &laquo;sujet&raquo; et &laquo;message&raquo;',
    5 => 'Erreur: membre inconnu.',
    6 => 'Il y a eu une erreur.',
    7 => 'Profil membre de ',
    8 => 'Nom de connexion',
    9 => 'URL membre',
    10 => 'Envoyer un courriel &agrave;',
    11 => 'Votre nom:',
    12 => 'R&eacute;pondre &agrave;:',
    13 => 'Subject:',
    14 => 'Message:',
    15 => 'Les balises HTML ne seront pas traduites.',
    16 => 'Envoyer Message',
    17 => 'Envoyer cette article &agrave; un ami',
    18 => 'Pour',
    19 => 'Adresse courriel',
    20 => 'De',
    21 => 'Adresse courriel',
    22 => 'Tous les champs sont obligatoires',
    23 => "Ce courriel vous a &eacute;t&eacute; envoy&eacute; de la part de %s at %s car il pensait que vous pourriez être int&eacute;ress&eacute; par {$_CONF['site_url']}. Ce n'est pas un SPAM et l'adresse courriel utilis&eacute;e n'est pas stok&eacute;e dans une liste d'envoi.",
    24 => 'Commentaire sur cet article &agrave;',
    25 => 'Vous devez être connect&eacute; pour utiliser cette fonction. Votre identification permettra de contr&ocirc;ler tout abus du syst&egrave;me',
    26 => 'Ce formulaire vous permet d\'envoyer un courriel &agrave; tous les membres s&eacute;lectionn&eacute;s. Tous les champs sont obligatoires.',
    27 => 'Message court',
    28 => '%s a &eacute;crit: ',
    29 => "Voici les articles du jour {$_CONF['site_name']} pour ",
    30 => ' lettre d\'information de ',
    31 => 'Titre',
    32 => 'Date',
    33 => 'Lire l\'article complet &agrave;',
    34 => 'Fin du message',
    35 => 'D&eacute;sol&eacute;, ce membre ne d&eacute;sire pas recevoir de messages.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages",
    41 => 'This user doesn\'t exist.',
    42 => 'This users email address doesn\'t exist. This most likely means is is an OAuth user account.',
    43 => 'This users email address is invalid.',
    44 => 'This users status is set to something other than Active or New Password therefore the email address is assumed bad.',
    45 => "This is a message sent from {$_CONF['site_name']} by %s. Any replies will need to be sent to the email address: %s",
    46 => "To unsubscribe from the Daily Digest, login to {$_CONF['site_name']} at {$_CONF['site_url']}. Then visit the user settings page at {$_CONF['site_url']}/usersettings.php and view the Content Tab. You can then unsubscribe to the Daily Digest by deselecting all topics and saving your profile."
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Recherche avanc&eacute;e',
    2 => 'Mots cl&eacute;s',
    3 => 'Sujet',
    4 => 'Tous',
    5 => 'Type',
    6 => 'Articles',
    7 => 'Commentaires',
    8 => 'Auteurs',
    9 => 'Tous',
    10 => 'Chercher',
    11 => 'R&eacute;sultats de recherche',
    12 => 's&eacute;lections',
    13 => 'Aucun r&eacute;sultats n\'a &eacute;t&eacute; trouv&eacute;',
    14 => 'Aucun r&eacute;sultat ne correspond &agrave; vos crit&egrave;res',
    15 => 'Veuillez r&eacute;essayer.',
    16 => 'Titre',
    17 => 'Date',
    18 => 'Auteur',
    19 => "Chercher dans toute la base de donn&eacute;es de {$_CONF['site_name']} des articles anciens ou recents.",
    20 => 'Date',
    21 => '&agrave;',
    22 => '(Format des dates AAAA-MM-JJ)',
    23 => 'Actions',
    24 => 'Trouv&eacute; %d items',
    25 => 'R&eacute;sultats pour',
    26 => 'Items',
    27 => 'secondes',
    28 => 'Il n\'y a pas d\'articles ou de commentaires correspondant &agrave; vos crit&egrave;res',
    29 => 'Articles et commentaires trouv&eacute;s',
    30 => '',
    31 => 'Aucun lien trouv&eacute; pour ce plugin',
    32 => '',
    33 => 'URL',
    34 => 'Localisation',
    35 => 'Tous les jours',
    36 => 'Key Word Type',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Votre sujet de recherche devrait comporter au moins 3 caract&egrave;res.',
    42 => 'Pri&egrave;re d\'utiliser une date exprim&eacute;e comme suit: AAAA-MM-JJ (ann&eacute;e-mois-jour).',
    43 => 'phrase exacte',
    44 => 'tous ces mots',
    45 => 'n\'importe quel mot',
    46 => 'Suivant',
    47 => 'Pr&eacute;c&eacute;dant',
    48 => 'Auteur',
    49 => 'Date',
    50 => 'Clics',
    51 => '',
    52 => 'Localisation',
    53 => 'R&eacute;sultats d\'articles',
    54 => 'R&eacute;sultats de commentaires',
    55 => 'la phrase',
    56 => 'ET',
    57 => 'OU',
    58 => 'More results &gt;&gt;',
    59 => 'Results',
    60 => 'per page',
    61 => 'Refine search',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Article',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc',
    73 => 'Submit',
    74 => 'Limit Results'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Statistiques du site',
    2 => 'Nombre de clics sur le site',
    3 => 'Nombre d\'articles',
    4 => 'Site Statistic',
    5 => "Overall Site Statistics for {$_CONF['site_name']}",
    6 => '',
    7 => 'Top-10 des articles les plus regard&eacute;s',
    8 => 'Titre d\'article',
    9 => 'Pages regard&eacute;es',
    10 => 'Soit il n\'y a pas d\'article sur ce site, soit ils n\'ont pas &eacute;t&eacute; regard&eacute;s',
    11 => 'Top-10 des articles les plus comment&eacute;s',
    12 => 'Commentaires',
    13 => 'Soit il n\'y a pas d\'article sur ce site, soit aucun commentaires n\'a encore &eacute;t&eacute; fait.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Top-10 des articles les plus envoy&eacute;s par courriel',
    23 => 'Courriels',
    24 => 'Personne n\'a encore envoy&eacute; d\'article par courriel',
    25 => 'Top Ten Trackback Commented Articles',
    26 => 'No trackback comments found.',
    27 => 'Number of active users',
    28 => '',
    29 => '',
    30 => 'Hits',
    31 => '',
    32 => 'Top Ten Liked Articles',
    33 => 'No liked articles found.'
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Sujets voisins',
    2 => 'Envoyer cet article &agrave; un ami',
    3 => 'Version imprimable',
    4 => 'Option des articles',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Pour envoyer un %s vous devez vous identifier comme membre.',
    2 => 'Nom de membre',
    3 => 'Nouveau membre',
    4 => '',
    5 => '',
    6 => 'Soumettre un article',
    7 => 'Identification requise',
    8 => 'Envoyer',
    9 => 'Veuillez compl&eacute;ter tous les champs et v&eacute;rifier &agrave; deux fois TOUTES les informations.',
    10 => 'Titre',
    11 => '',
    12 => 'D&eacute;but',
    13 => 'Fin',
    14 => 'Localisation',
    15 => 'Description',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Lisez en premier',
    20 => '',
    21 => '',
    22 => 'Erreur: champs manquants',
    23 => 'Veuillez compl&eacute;ter tous les champs du formulaire. Ils sont tous obligatoires.',
    24 => 'Proposition enregistr&eacute;e',
    25 => 'Vos propositions %s ont &eacute;t&eacute; sauvegard&eacute;es avec succ&egrave;s.',
    26 => 'Vitesse limite',
    27 => 'Membre',
    28 => 'Sujet',
    29 => 'Article',
    30 => 'Votre derni&egrave;re proposition &eacute;tait il y a',
    31 => " secondes. Vous devez attendre au moins {$_CONF['speedlimit']} secondes entre chaque propositions",
    32 => 'Aper&ccedil;u',
    33 => 'Aper&ccedil;u de l\'article',
    34 => 'Se d&eacute;connecter',
    35 => 'Les balises HTML ne sont pas accept&eacute;es',
    36 => 'Format',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Adresse (ligne 1)',
    45 => 'Adresse (ligne 2)',
    46 => 'Ville',
    47 => 'R&eacute;gion',
    48 => 'Code postal',
    49 => '',
    50 => '',
    51 => 'Localisation',
    52 => 'Supprimer',
    53 => 'Cr&eacute;er un compte',
    54 => 'Article Introduction',
    55 => 'Article Body'
);

###############################################################################
# LIKES feature since Geeklog 2.2.1

$LANG_LIKES = array(
    'like' => 'Like',
    'unlike' => 'Unlike',
    'dislike' => 'Dislike',
    'undislike' => 'Undislike',
    'likes' => 'Likes',
    'unlikes' => 'Unlikes',
    'dislikes' => 'Dislikes',
    'undislikes' => 'Undislikes',
    'i_like_this' => 'I like this',
    'i_dislike_this' => 'I dislike this',
    'thanks_for_action' => 'Thanks for voting!',
    'likes_speedlimit' => 'You last used the Likes system on an item %s seconds ago. This site requires at least %s seconds between using the Likes system',
    'likes_ip_error' => 'Your IP address has already performed this Likes action.',
    'likes_uid_error' => 'Your User account has already performed this Likes action.',
    'own_item_error' => 'Either you own the item or do not have permission to Like/Dislike it.',
    'liked_by' => 'Liked by:',
    'disliked_by' => 'Disliked by:',
    'num_anon_users' => '<br' . XHTML . '>%s Anonymous Users',
    'one_anon_users' => '<br' . XHTML . '>1 Anonymous User',
    'num_more_users' => '<br' . XHTML . '>+%s more Users',
    'username_in_likes_list' => '<br' . XHTML . '>%s',
    'autotag_desc_likes_block' => "[likes_block:aid action:aid wrapper:wid class:likes-autotag type: subtype: time:604800 max:10 cache:3600 line:1 length:20]
\n	- Displays the Likes block. No attributes are required. If attribute not specified then default in configuration used. 
\n	- action = 1 (likes only), 2 (dislikes only), or 3 (both) 
\n	- wrapper = 0 (no wrapper), 1 (block wrapper with title), div wrapper with css class), or both
\n	- class = Specifies the css class used by the div wrapper if enabled else default likes-autotag will be used 
\n	- type = Either empty (for all types) or include 1 supported like type. For example 'article' or 'comment'
\n	- subtype = Specify a sub type of type if needed
\n	- time = Display items that are this many seconds old. 0 will display all items
\n	- max = Maximum number of items to display
\n	- cache = Cached for no longer than this many seconds. If 0 caching is disabled
\n	- line = Display likes icons on new line
\n	- length = Trim item title length to this many characters",
    'num_likes_in_time_limit' => 'The last number of Likes this item received within the time specified.',
    'num_dislikes_in_time_limit' => 'The last number of Dislikes this item received within the time specified.',
    'num_likes_total' => 'The total number of Likes this item has received.',
    'num_dislikes_total' => 'The total number of Dislikes this item has received.',
    'likes_time_span' => 'Most Likes in the last %t %s',
    'dislikes_time_span' => 'Most Dislikes in the last %t %s',
    'all_time_span' => 'Most engaging in the last %t %s',
    'whats_liked' => 'Whats Liked',
    'whats_recently_liked' => 'Whats Recently Liked',
    'whats_disliked' => 'Whats Disliked',
    'whats_recently_disliked' => 'Whats Recently Disliked',
    'whats_popular' => 'Whats Popular',
    'whats_recently_popular' => 'Whats Recently Popular',
    'whats_liked_type' => 'Liked %s',
    'whats_recently_liked_type' => 'Recently Liked %s',
    'whats_disliked_type' => 'Disliked %s',
    'whats_recently_disliked_type' => 'Recently Disliked %s',
    'whats_popular_type' => 'Popular %s',
    'whats_recently_popular_type' => 'Recently Popular %s',
    'no_liked_items_in_time_limit' => 'There have been no Likes during the time specified.',
    'no_disliked_items_in_time_limit' => 'There have been no Dislikes during the time specified.',
    'no_action_items_in_time_limit' => 'There have been no Likes or Dislikes during the time specified.',
    'no_liked_items' => 'There are no Liked items.',
    'no_disliked_items' => 'There are no Disliked items.',
    'no_action_items' => 'There are no Liked or Disliked items.',
    'last_num_likes_by' => 'Last %s Likes and Dislikes by %s',
    'msg_no_likes' => 'No likes or dislikes found by user.',
    'total_num_likes' => 'Total number of likes and dislikes:',
    'title_liked' => '%s Liked on ',
    'title_disliked' => '%s Disliked on ',
    'articles' => 'Articles',
    'comments' => 'Comments'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'Log Viewer',
    'info' => 'Geeklog log file administration.',
    'logs' => 'Logs',
    'view' => 'View Log File',
    'clear' => 'Clear Log File',
    'log_file' => 'Log File'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => 'Please correct the issues identified below. Once they have been corrected, use the <b>Recheck</b> button to validate the environment.',
    'current' => 'Current',
    'current_php_settings' => 'Current PHP Settings',
    'directory_permissions' => 'Directory Permissions',
    'enabled' => 'Enabled',
    'env_check' => 'Environment Check',
    'file_permissions' => 'File Permissions',
    'file_uploads' => 'Many features of Geeklog require the ability to upload files, this should be enabled.',
    'filesystem_check' => 'Directory / File Permissions',
    'gd_lib' => 'GD Libraries',
    'gd_not_found' => 'Unable to locate the GD library functions.  Please ensure that the GD libraries were compiled into PHP or select an alternate graphics library.',
    'gd_ok' => 'GD Libraries v2 are installed.',
    'gd_v1' => 'GD Libraries v1 is installed - This version does not fully support JPG image processing so there may be some quality issues.',
    'graphics' => 'Graphics Library',
    'libraries' => 'Libraries',
    'hosting_env' => 'Hosting Environment Check',
    'imagemagick' => 'ImageMagick Programs',
    'im_not_found' => 'Unable to locate the <strong>convert</strong> executable for ImageMagick.',
    'im_ok' => 'The <strong>convert</strong> executable appears to be valid.',
    'memory_limit' => 'It is recommended that you have at least 48M of memory enabled on your site.',
    'not_writable' => 'NOT WRITABLE',
    'notes' => 'Notes',
    'not_found' => 'Not Found',
    'netpbm' => 'NetPBM Library',
    'np_ok' => 'The NetPBM library is installed',
    'np_not_found' => 'The NetPBM executables were not found.',
    'fileinfo_library' => 'Fileinfo Library',
    'fileinfo_ok' => 'The Fileinfo library is loaded. This library is required when uploading images for articles. It is used to get the mime type of the file being uploaded when creating a thumbnail of the image.',
    'fileinfo_not_found' => 'The Fileinfo library is not loaded. This is required <strong>only</strong> when uploading images in the article editor.',
    'openssl_library' => 'OpenSSL Library',
    'openssl_ok' => 'The OpenSSL library is loaded. This library is required if you wish to use the OAuth user login method with Geeklog.',
    'openssl_not_found' => 'The OpenSSL library is not loaded. This is required <strong>only</strong> if you wish to use the OAuth user login method with Geeklog.',
    'off' => 'Off',
    'ok' => 'OK',
    'on' => 'On',
    'open_basedir' => 'If <strong>open_basedir</strong> restrictions are enabled on your site, it may cause permission problems during the install. The File System Check below should point out any issues.',
    'database_settings' => 'Database Settings',
    'database_mysql_version' => 'MySQL Version',
    'database_mysql_req_version' => 'Geeklog requires MySQL version 4.1.2 or newer (MySQL 5 recommended).',
    'database_pgsql_version' => 'Postgresql Version',
    'database_pgsql_req_version' => 'Geeklog requires Postgresql version 9.1.7 or newer.',
    'database_dms' => 'Database Management System',
    'database_dms_notes' => 'Failed to determine Database Management System. Geeklog requires either MySQL or Postgresql',
    'php_req_version' => 'Geeklog requires PHP version 5.6.4 or newer.',
    'php_settings' => 'PHP Settings',
    'php_version' => 'PHP Version',
    'php_warning' => 'If any of the items below are marked in <span class="no">red</span>, you may encounter problems with your Geeklog site.  Check with your hosting provider for information on changing any of these PHP settings.',
    'post_max_size' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the maximum post size.',
    'recheck' => 'Recheck Environment',
    'recommended' => 'Recommended',
    'setting' => 'Setting',
    'unable_mkdir' => 'Unable to create directory',
    'upload_max_filesize' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the upload size.',
    'not_checked' => 'Skipped',
    'bypass_note' => 'Since either Safe Mode or open_basedir restrictions were detected, the check for graphic libraries were skipped.',
    'not_used_note' => 'No graphic libraries are set to be used by Geeklog.',
    'location' => 'Location',
    'status' => 'Status',
    'item' => 'Item',
    'jhead' => 'jhead Program',
    'jhead_not_found' => 'Unable to locate the jhead executable.',
    'jhead_ok' => 'The jhead executable is installed.',
    'jpegtran' => 'jpegtran Program',
    'jpegtran_not_found' => 'Unable to locate the jpegtran executable.',
    'jpegtran_ok' => 'The jpegtran executable is installed.',
    'showhide_phpinfo' => 'Show/Hide Full PHP Info',
    'view_online' => 'Click here %s to view online',
    'no_new_items' => 'No New Items',
    'max_execution_time' => 'Geeklog recommends the PHP default value of 30 seconds as a minimum, but plugin uploads and other operations may take longer than this depending upon your hosting environment.  If safe_mode (above) is Off, you may be able to increase this by modifying the value of <b>max_execution_time</b> in your php.ini file.',
    'phpinfo_disabled' => 'In order to view the current php settings, you will have to contact your host and enable access to the phpinfo() function.'
);

###############################################################################
# For Demo Mode (since v2.2.1)

$LANG_DEMO = array(
    'header' => 'Header',
    'subject' => 'Subject:',
    'to' => 'To:',
    'from' => 'From:',
    'priority' => 'Priority:',
    'body' => 'Body',
    'notice' => 'Notice',
    'emails_disabled_msg' => 'Please note sending emails is disabled in Demo mode. An email which would have been sent was:'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Identification requise',
    2 => 'Utilisateur ou mot de passe incorrect',
    3 => 'Mot de passe incorrect',
    4 => 'Nom du membre:',
    5 => 'Mot de passe:',
    6 => 'Toutes tentatives d\'acc&egrave;s &agrave; cette portion du site est enregistr&eacute;e et analys&eacute;e.<br' . XHTML . '>Cette page est r&eacute;serv&eacute;e aux personnes autoris&eacute;es.',
    7 => 'Connexion',
    8 => 'Login',
    9 => 'This page is for the use of authorized personnel only. Please note all access to administrative portions of this web site are logged and reviewed.'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Droits insuffisants',
    2 => 'Vous n\'avez pas les droits n&eacute;cessaires pour modifier ce cadre',
    3 => 'Editeur de cadre',
    4 => 'CNT 4',
    5 => 'Yes',
    6 => 'No',
    7 => 'tous',
    8 => 'niveau de s&eacute;curit&eacute; du cadre',
    9 => 'Ordre du cadre',
    10 => '',
    11 => 'Cadre Portail',
    12 => 'Cadre Normal',
    13 => 'Cadre portail d\'option',
    14 => 'URL RDF',
    15 => 'Derni&egrave;re MAJ RDF',
    16 => 'Cadre normal d\'option',
    17 => 'Contenu du cadre',
    18 => 'Veuillez remplir les champs: titre, niveau de s&eacute;curit&eacute; et contenu du cadre',
    19 => 'Contr&ocirc;leur de cadre',
    20 => 'Regular Blocks',
    21 => 'Cadre niv. sec.',
    22 => 'Dynamic Blocks',
    23 => 'Cadre ordre',
    24 => 'Dynamic',
    25 => 'Cliquez sur le lien ci-dessous pour modifier ou supprimer un cadre.  Cliquez sur le lien nouveau cadre pour cr&eacute;er un nouveau cadre.',
    26 => 'Cadre d\'affichage',
    27 => 'Cadre PHP',
    28 => 'Option du cadre PHP',
    29 => 'Cadre fonction',
    30 => 'Si vous voulez que l\'un de vos cadres utilise du PHP, saisissez le nom de la fonction &agrave; utiliser.  Le nom de la fonction doit commencer par \'phpblock_\' (ex: phpblock_getweather).  Si ce n\'est pas le cas, votre fonction NE SERA PAS appell&eacute;e, ceci pour des raisons de s&eacute;curit&eacute;.  Ne mettez pas de parenth&egrave;ses vides \'()\' apr&egrave;s le nom de votre fonction.  Enfin, nous vous recommandons de mettre tout le code des cadre PHP dans /path/to/geeklog/system/lib-custom.php.  Cela permettera de garder votre code même apr&egrave;s une mise &agrave; jour de geeklog.',
    31 => 'Erreur dans le cadre PHP.  La fonction, %s, n\'existe pas.',
    32 => 'Erreur: champs manquant',
    33 => 'Vous devez mettre l\'URL dans le fichier .rdf pour le cadre portail.',
    34 => 'Vous devez renseigner le titre et la fonction du cadre PHP.',
    35 => 'Vous devez entrer le titre et le contenu du cadre normal.',
    36 => 'Vous devez entrer le contenu pour le cadre d\'affichage.',
    37 => 'Nom erron&eacute; dans la fonction du cadre PHP',
    38 => 'Les fonctions des cadres PHP doivent commencer par "phpblock_" (ex: phpblock_getweather).  Le pr&eacute;fixe "phpblock_" est n&eacute;cessaire pour des raisons de s&eacute;curit&eacute; qui empêche l\'ex&eacute;cution de code arbitraire.',
    39 => 'C&ocirc;t&eacute;',
    40 => 'Gauche',
    41 => 'Droit',
    42 => 'Vous devez saisir l\'ordre et le niveau de s&eacute;curit&eacute; pour les cadres par d&eacute;faut de geeklog',
    43 => 'Accueil seulement',
    44 => 'Multiple',
    45 => "Vous essayez d'acc&eacute;der &agrave; un cadre auquel vous n'avez pas droit.  Cette tentative est enregistr&eacute;e. Veuillez <a href=\'{$_CONF['site_admin_url']}/block.php\'>retourner &agrave; la page de controle des cadres</a>.",
    46 => 'Nouveau Cadre',
    47 => 'None',
    48 => 'Nom du cadre',
    49 => ' (pas d\'espace et doit être unique)',
    50 => 'The Block Name can not be empty',
    51 => 'inclure http:// ',
    52 => 'Laisser vide pour ne pas afficher l\'icone d\'aide',
    53 => 'Activ&eacute;',
    54 => 'enregistrer',
    55 => 'annuler',
    56 => 'supprimer',
    57 => 'Move Block Down',
    58 => 'Move Block Up',
    59 => 'Move block to the right side',
    60 => 'Move block to the left side',
    61 => 'No Title',
    62 => 'Article Limit',
    63 => 'Bad Block Title',
    64 => 'Your Title must not be empty and cannot contain HTML!',
    65 => 'Order',
    66 => 'Autotags',
    67 => 'Check to allow autotags',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.',
    69 => 'Plugin Name',
    70 => 'CSS ID',
    71 => 'This field is optional',
    72 => 'CSS Classes',
    73 => 'This field is optional.  You can specify multiple classes separated by space',
    'autotag_desc_block' => '[block:name class:block-autotag] - Displays a block. Class not required. Class specifies the css class and will wrap the block in a div. The class block-autotag will always be included with the div.',
    'newlines' => 'Newlines',
    'convert_newlines' => 'Check to convert newlines (EOL) into line break HTML element',
    'position' => 'Position',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This block will be cached for no longer than this many seconds. If 0 caching is disabled. (3600 = 1 hour,  86400 = 1 day)',
    'block_type_gldefault' => 'System',
    'block_type_normal' => 'Normal',
    'block_type_phpblock' => 'PHP',
    'block_type_portal' => 'Portal',
    'block_type_dynamic' => 'Dynamic'
);

###############################################################################
# Block Locations

$LANG23 = array(
    'blocks_article_footer_name' => 'Article Footer',
    'blocks_article_footer_desc' => 'Display Blocks in article Footer',
    'blocks_article_topic_list_name' => 'Article Topic List',
    'blocks_article_topic_list_desc' => 'Displays Blocks right after every X number of articles in topics.'
);

###############################################################################
# admin/article.php

$LANG24 = array(
    1 => 'Articles pr&eacute;c&eacute;dents',
    2 => 'Articles suivants',
    3 => 'Mode',
    4 => 'Format',
    5 => 'Editeur d\'articles',
    6 => 'Il n\'y a pas d\'articles dans le syst&egrave;me',
    7 => 'Auteur',
    8 => 'Enregistrer',
    9 => 'Aper&ccedil;u',
    10 => 'Annuler',
    11 => 'Supprimer',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Date',
    16 => 'Texte d\'intro',
    17 => 'Texte int&eacute;gral',
    18 => 'Clics',
    19 => 'Commentaires',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Liste des articles',
    23 => 'Pour modifier ou supprimer un article, cliquez sur son num&eacute;ro. Pour visionner un article, cliquez sur le titre de l\'article. Pour cr&eacute;er un nouvel article, cliquez sur le bouton &eacute;crire un article.',
    24 => 'The ID you chose for this article is already in use. Please use another ID.',
    25 => 'Error when saving article',
    26 => 'Aper&ccedil;u de l\'article',
    27 => 'If you use [unscaledX] instead of [imageX], the image will be inserted at its original dimensions.',
    28 => '<p><b>PREVIEWING</b>: Previewing an article with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    29 => 'Trackbacks',
    30 => 'File Upload Errors',
    31 => 'Veuillez inscrire le titre et le texte d\'introduction.',
    32 => 'Tête d\'affiche',
    33 => 'Il ne peut y avoir qu\'un seul article en tête d\'affiche',
    34 => 'Brouillon',
    35 => 'Oui',
    36 => 'Non',
    37 => 'Plus sur',
    38 => 'Plus de',
    39 => 'Emails',
    40 => '',
    41 => "Vous essayez d'acc&eacute;der &agrave; un article auqule vous n'avez pas droit.  Cette tentative est enregistr&eacute;e.  Vous pouvez voir cet article en lecture seule uniquement. Veuillez <a href=\'{$_CONF['site_admin_url']}/article.php\'>retourner sur la page de contr&ocirc;le des article</a> lorsque vous aurez fini.",
    42 => "Vous essayez d'acc&eacute;der &agrave; un article auquel vous n'avez pas droit.  Cette tentative est enregistr&eacute;e.  Veuillez <a href=\'{$_CONF['site_admin_url']}/article.php\'>retourner &agrave; la page de contr&ocirc;le des articles</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>REMARQUE:</b> si vous indiquez une date future, cet article n\'appara&icirc;tra qu\'&agrave; partir de cette date. Cela signifie aussi que l\'article sera ignor&eacute; des recherches et des statistiques.',
    47 => 'Images',
    48 => 'image',
    49 => 'droite',
    50 => 'gauche',
    51 => 'Pour ajouter une des images que vous avez fournies vous devez ins&eacute;rer un texte sp&eacute;cial dans votre article. Vous devez ins&eacute;rer [imageX], [imageX_right] ou [imageX_left] o&ugrave; X est le num&eacute;ro de l\'image que vous avez fournie.  REMARQUE: vous devez utiliser toutes les images fournies.  Si vous ne le faites pas vous ne pourrez pas enregistrer votre article.<BR><P><B>APERCU</B>: lors de l\'utilisation d\'images il est pr&eacute;f&eacute;rables de faire un brouillon plut&ocirc;t que d\'utiliser la fonction d\'apercu.  Utilisez le bouton d\'apercu uniquement lorsqu\'il n\'y a pas d\'image.',
    52 => '',
    53 => 'n\'est pas utilis&eacute;e.  Vous devez ins&eacute;rer l\'image dans le texte de votre article avant de l\'enregistrer.',
    54 => 'Image fournie non utilis&eacute;e',
    55 => 'L\'erreur suivante est apparue lors de l\'enregistrement de votre article.  Veuillez corriger ces erreurs et r&eacute;essayer',
    56 => 'Montrer l\'ic&ocirc;ne',
    57 => 'Montrer l\'image originale',
    58 => 'Article Management',
    59 => 'Option',
    60 => '',
    61 => 'Auto Archive',
    62 => 'Auto Delete',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Expand the Content Edit Area size',
    68 => 'Reduce the Content Edit Area size',
    69 => 'Publish Article Date',
    70 => 'Toolbar Selection',
    71 => 'Basic Toolbar',
    72 => 'Common Toolbar',
    73 => 'Advanced Toolbar',
    74 => 'Advanced II Toolbar',
    75 => 'Full Featured',
    76 => 'Publish Options',
    77 => 'Javascript needs to be enabled for Advanced Editor. Option can be disabled in the main site config.php',
    78 => 'Click <a href="%s/article.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> to use default editor',
    79 => 'Preview',
    80 => 'Editor',
    81 => 'Publish Options',
    82 => 'Images',
    83 => 'Archive Options',
    84 => 'Permissions',
    85 => 'Show All',
    86 => 'Advanced Editor',
    87 => 'Article Stats',
    88 => 'Wiki-style format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.',
    92 => 'You might also like',
    93 => '#',
    94 => 'Resized',
    95 => 'Original',
    96 => 'Upload | Replace',
    97 => 'No Image',
    'autotag_desc_story' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'autotag_desc_article' => '[article: id alternate title] - Displays a link to an article using the Article Title as the title. An alternate title may be specified but is not required.',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This article will be cached for no longer than this many seconds. If 0 caching is disabled. If -1 cached until article is edited again. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Editeur de sujet',
    2 => 'Num&eacute;ro',
    3 => 'Nom',
    4 => 'Image',
    5 => '(ne pas utiliser d\'espaces)',
    6 => 'Supprimer un sujet supprimera tous les articles et cadres en relations avec celui-ci',
    7 => 'Veuillez renseigner le num&eacute;ro et le nom du sujet.',
    8 => 'Contr&ocirc;leur de sujet',
    9 => 'Cliquez sur un sujet pour le modifier ou le supprimer.  Cliquez sur le bouton &laquo;Nouveau Sujet&raquo; &agrave; gauche pour cr&eacute;er un sujet. Vos droits d\'acc&egrave;s concernent tout sujet apparaissant entre parenth&egrave;ses.',
    10 => 'Ordre de tri',
    11 => 'Articles/Page',
    12 => 'Acc&egrave;s interdit',
    13 => "vous essayez d'acc&eacute;der &agrave; un sujet auquel vous n'avez pas droit.  Cette tentative est enregistr&eacute;e. Veuillez <a href=\'{$_CONF['site_admin_url']}/topic.php\'>retourner &agrave; la page de contr&ocirc;le des sujets</a>.",
    14 => 'M&eacute;thode de tri',
    15 => 'alphab&eacute;tique',
    16 => 'par d&eacute;faut:',
    17 => 'Nouveau Sujet',
    18 => 'Accueil Admin',
    19 => 'Enregistrer',
    20 => 'Annuler',
    21 => 'Supprimer',
    22 => 'Par d&eacute;faut',
    23 => 'Faites de ce sujet le choix par d&eacute;faut pour la cr&eacute;ation de nouveaux articles',
    24 => '(*)',
    25 => 'Archive Topic',
    26 => 'make this the default topic for archived articles. Only one topic allowed.',
    27 => 'Or Upload Topic Icon',
    28 => 'Maximum',
    29 => 'File Upload Errors',
    30 => 'Articles in Topic',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Parent Topic',
    33 => 'Inherit',
    34 => 'Items of child topic are inherited',
    35 => 'Hidden',
    36 => 'Topic will be hidden and cannot be viewed directly, only inherited',
    37 => 'Root',
    38 => 'All',
    39 => 'Homepage Only',
    40 => 'Assign one or more topics. ',
    41 => 'If "All" is selected then the item will appear for all topics. If "Homepage Only" is selected then item will appear just on the homepage. Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics' => 'Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics_disabled' => 'Else you must select at least one topic you have edit access for, to assign the item to (text is darker). ',
    'topic_control_no_topics' => 'Unfortunately you do not have edit access to any topics so none can be selected. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Inherit',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Yes',
    51 => 'No',
    52 => 'Article',
    53 => 'Image',
    54 => 'Selected',
    55 => 'Assigned',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home',
    'autotag_desc_topic' => '[topic: id alternate title] - Displays a link to a topic using the ID as the title. An alternate title may be specified but is not required.',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - Creates a clickable horizontal list of related topics based on the item id and type.',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - Create a clickable list of related items based on the item id and type.',
    'no_related_items' => 'No related items found.',
    'topics:' => 'Topics:',
    'filed_under:' => 'Filed under:',
    'topic_title' => 'Topic Title',
    'topic_title_desc' => 'Used as the page title for the topic. If empty the topic name will be used.',
    'move_topic_up' => 'Move topic up the sort order',
    'move_topic_down' => 'Move topic down in the sort order',
    'topics_edit_access_select' => 'You can only select topics you have Edit access to you (text is darker).',
    'topics_edit_access_listed' => 'Only topics with Edit access are listed.'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Editeur du membre',
    2 => 'Num&eacute;ro',
    3 => 'Nom de connexion',
    4 => 'Nom complet',
    5 => 'Mot de passe',
    6 => 'Niveau de s&eacute;curit&eacute;',
    7 => 'Adresse courriel',
    8 => 'Page d\'accueil',
    9 => '(ne pas utiliser d\'espaces)',
    10 => 'Veuillez renseigner le nom de connexion, le nom complet, le nom complet et l\'adresse courriel.',
    11 => 'Contr&ocirc;leur des membres',
    12 => 'Cliquez sur un membre pour le modifier ou le supprimer.  Cliquez sur le bouton Nouveau membre &agrave; gauche pour cr&eacute;er un compte. Vous pouvez faire des recherches simple en entrant une partie du nom de connexion, du nom complet ou de l\'adresse courriel (ex:*son* ou *.edu) dans le formulaire ci-dessous.',
    13 => 'Niv. Sec.',
    14 => 'Date d\'enregistrement',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'Enregistrer',
    21 => 'Le nom de connexion est d&eacute;j&agrave; utilis&eacute;.',
    22 => 'Erreur',
    23 => 'Ajout par lot',
    24 => 'Importation par lot d\'utilisateurs',
    25 => 'Vous pouvez importer un lot d\'utilisateur dans le syst&egrave;me.  Les champ du fichier d\'import doivent être s&eacute;par&eacute;s par une tabulation. Ils doivent appara&icirc;tre dans l\'ordre suivant: Nom complet, nom de connexion, adresse courriel.  Chaque utilisateur import&eacute; sera averti par courriel et aura un mot de passe auto-g&eacute;n&eacute;r&eacute;.  Il ne doit y avoir qu\'un seul utilisateur par ligne.  Ne pas respecter ces consignes peut entra&icirc;ner des d&eacute;gat qui ne seront r&eacute;parables que manuellement, alors redoublez de vigilance!',
    26 => '',
    27 => '',
    28 => 'Coche la case pour supprimer la photo',
    29 => 'Chemin',
    30 => 'Importer',
    31 => 'Nouveaux membres',
    32 => 'Traitement termin&eacute;. %d membres ont &eacute;t&eacute; import&eacute;s et il y a %d erreurs',
    33 => 'envoyer',
    34 => 'Erreur: Vous devez pr&eacute;ciser un fichier &agrave; t&eacute;l&eacute;charger.',
    35 => 'Dernier acc&egrave;s',
    36 => '(jamais)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    'user_status_desc' => "An explanation of all possible user statuses: <ul>\n\n        <li><strong>Awaiting Activation</strong> - New account awaiting user to login. Email has been sent but not verified. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Awaiting Authorization</strong> - New account awaiting moderator approval in the User Submission Queue. When User Submission approved, user will be sent email with password. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>\n\n        <li><strong>Active</strong> - This is an Active account.</li>\n\n        <li><strong>Banned</strong> -  This Account is banned/disabled. Username is crossed out on the site for any content they have submitted, User cannot login, emails to account is disabled, and profile cannot be viewed by any user except Admins.</li>\n\n        <li><strong>Locked</strong> - This Account is locked. User cannot login, emails to account is disabled, but profile can still be viewed by all.</li>\n\n        <li><strong>New Email Required</strong> - Emails to account is disabled. When user logs in again they must submit new email address and verify before access to rest of the website (under this user account). Status stays the same until email is verified. If \"Require User Email\" config option true then any users who login (includes remote accounts) that do not have an email address will automatically switch to this status.</li>\n\n        <li><strong>New Password Required</strong> -  When the user logs in they must submit a new password before access to rest of website (under this user account). This is only for regular accounts and not remote accounts.</li>\n\n        </ul>\n\n    ",
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts',
    91 => 'Send password to user',
    92 => 'Only for new users or when changing password for existing user.',
    'convert_remote' => 'Check here to convert from remote to a local account',
    'convert_remote_desc' => 'When a remote account is converted to a local account, a password will be automatically generated. If the account does not have a confirmed email address, the account will be locked after it is converted since the user will have no way of retrieving the password. Once converted and if the account is active and has an email address the user will be emailed the password or they can request the password by using the forget password link from the Login page. For user accounts that do not have an active status and valid email you will have to manually notify the user of the account change and how to login.',
    'contributed' => 'Contributed',
    'na' => 'NA',
    'nothing' => 'Nothing',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.',
    'USER_ACCOUNT_LOCKED' => 'Locked',
    'USER_ACCOUNT_NEW_EMAIL' => 'New Email Required',
    'USER_ACCOUNT_NEW_PASSWORD' => 'New Password Required'
);

###############################################################################
# admin/moderation.php
# admin/index.php

$LANG29 = array(
    1 => 'Valider',
    2 => 'Supprimer',
    3 => 'Modifier',
    4 => 'Profil',
    10 => 'Titre',
    11 => 'D&eacute;but',
    12 => 'URL',
    13 => 'Cat&eacute;gorie',
    14 => 'Date',
    15 => 'Sujet',
    16 => 'Membre',
    17 => 'Nom Complet',
    18 => 'Courriel',
    34 => 'Commandes et Contr&ocirc;les',
    35 => 'Soumissions d\'articles',
    36 => 'Parent or Comment',
    37 => 'Author',
    38 => 'Envoyer',
    39 => 'Il n\'y a aucune soumission &agrave; administrer pour le moment',
    40 => 'Soumissions des membres',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?',
    44 => 'Results of your moderation',
    45 => 'Approved %1$d items and deleted %2$d items of user submissions.',
    46 => 'User Profile Updated',
    'core' => 'Core',
    'plugins' => 'Plugins',
    'tools' => 'Tools',
    'users' => 'Users',
    'submissions_desc' => 'To modify or delete a user submssion, click on that item\'s edit icon below. To approve and delete multiple submissions use the radio options in the lists and then click submit.',
    'max_invalid_login' => 'Max Invalid Logins Reached for User',
    'max_invalid_login_msg' => 'This user has reached the maximum number of invalid login attempts () within the specified time limit ( seconds). The last IP to make an invalid login attempt is %s. Either the real user has forgotten the password for their account, or someone else is attempting to guess the password for this user account.'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "Envoyer un mail aux membres de {$_CONF['site_name']}",
    2 => 'De',
    3 => 'Adresse de r&eacute;ponse',
    4 => 'Sujet',
    5 => 'Message',
    6 => '&agrave;:',
    7 => 'Tous les membres',
    8 => 'Admin',
    9 => 'Options',
    10 => 'HTML',
    11 => 'message urgent!',
    12 => 'Envoyer',
    13 => 'Effacer',
    14 => 'Ignorer les pr&eacute;f&eacute;rences membre',
    15 => 'Erreur lors de l\'envoi d\'un message &agrave;: ',
    16 => 'Message envoy&eacute; avec succ&egrave;s &agrave;: ',
    17 => "<a href=\"{$_CONF['site_admin_url']}/mail.php\">Envoyer un autre message</a>",
    18 => '&agrave;',
    19 => 'Remarque: si vous voulez envoyer un message &agrave; tous les membres, utilisez le groupe Logged-in dans le champ A.',
    20 => "<successcount> messages ont &eacute;t&eacute; envoy&eacute;s avec succ&egrave;s et <failcount> n'ont pas pu être envoy&eacute;s.  Vous trouverez le d&eacute;tail de chaque tentative ci-dessous.  Vous pouvez &eacute;galement <a href=\"{$_CONF['site_admin_url']}/mail.php\">envoyer un autre message</a> ou <a href=\"{$_CONF['site_admin_url']}/moderation.php\">revenir &agrave; la page d'administration</a>.",
    21 => '&eacute;checs',
    22 => 'Succ&egrave;s',
    23 => 'Pas d\'&eacute;checs',
    24 => 'Pas de succ&egrave;s',
    25 => '-- Choisir un groupe --',
    26 => 'Remplissez tous les champs et choisissez un groupe parmi la liste.',
    27 => 'The following template variables are available in <strong>Subject</strong> and <strong>Message</strong>: {uid}, {username}, {fullname}, {email}, {homepage}, {theme}, {language}, {location}, {lastgranted}, {lastlogin}, {site_url}, {site_name}, {site_slogan}, {owner_name}, {copyrightyear}, {site_mail}, {noreply_mail}',
    'email_divider' => '------------------------------------------------------------',
    'email_divider_html' => '<hr' . XHTML . '>',
    'sig_divider' => '---',
    'sig_divider_html' => '---<br' . XHTML . '>',
    'email_footer_msg_noreply' => 'The address used to send this email is not monitored. Please do not reply to this email.',
    'email_footer_msg_content' => 'If content from the website is displayed in this email, there may be layout changes which result in formatting issues.',
    'ip_address_email' => 'IP address that initiated email:'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'L\'installation de plugins peut endommager le syst&egrave;me.  Il est important de n\'installer que des plugins approuv&eacute;s par <a href=\'https://www.geeklog.net\' target=\'_blank\'>Geeklog</a> car nous les testons sur plusieurs syst&egrave;mes. Installer des plugins requiert l\'ex&eacute;cution de plusieurs commandes syst&egrave;mes qui peuvent poser des probl&egrave;mes de s&eacute;curit&eacute;, particuli&egrave;rement si vous utilisez des plugins de provenances inconnues. Vous êtes averti des domages que peut causer l\'installation d\'un plugin. En d\'autres termes, vous installez des plugins &agrave; vos propres risques. Les instructions d\'installation des plugins sont incluses dans chaque plugin.',
    2 => 'Instructions d\'installation d\'un plugin',
    3 => 'Formulaire d\'installation d\'un plugin',
    4 => 'Fichier du plugin',
    5 => 'Liste des plugins',
    6 => 'Attention: plugin d&eacute;j&agrave; install&eacute;!',
    7 => 'Le plugin que vous essayez d\'installer existe d&eacute;j&agrave;.  Veuillez supprimer le plugin avant de le r&eacute;installer.',
    8 => 'Test de compatibilit&eacute; du plugin &eacute;chou&eacute;',
    9 => 'Ce plugin requiert une version plus r&eacute;cente du syst&egrave;me. Vous pouvez mettre &agrave; jour votre <a href=\'https://www.geeklog.net\'>Geeklog</a> ou obtenir une autre version du plugin.',
    10 => '<br' . XHTML . '><b>Aucun plugin n\'est actuellement install&eacute;.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Cliquez sur le num&eacute;ro du plugin pour le modifier ou le supprimer. Pour en savoir d\'avantage sur les plugins, cliquez sur le nom du plugin et vous serez redirig&eacute; vers le site web du plugin. Pour installer ou mettre &agrave; jour un plugin veuillez vous r&eacute;f&eacute;rer &agrave; la documentation du plugin.',
    12 => 'Aucun nom de plugin n\'a &eacute;t&eacute; pass&eacute; &agrave; plugineditor()',
    13 => 'Editeur de plugin',
    14 => 'Nouveau plugin',
    'installed_plugins' => 'Installed Plugins',
    15 => 'Accueil Admin',
    16 => 'Nom du plugin',
    17 => 'Version du plugin',
    18 => 'Version de Geeklog',
    19 => 'Activ&eacute;',
    20 => 'Oui',
    21 => 'Non',
    22 => 'Installer',
    23 => 'Enregistrer',
    24 => 'Annuler',
    25 => 'Supprimer',
    26 => 'Nom du plugin',
    27 => 'Site web du plugin',
    28 => 'Version du plugin',
    29 => 'Version de Geeklog',
    30 => 'Supprimer le plugin ?',
    31 => 'Etes-vous s&ucircr de vouloir supprimer ce plugin? Toutes les donn&eacute;es, fiches et structures utilis&eacute;s par ce plugin seront d&eacute;truites.  Si vous êtes certain de vouloir supprimer le plugin, cliquez sur le bouton &laquo;Supprimer&raquo;.',
    32 => '<p><b>Error AutoLink tag not correct format</b></p>',
    33 => 'Code Version',
    34 => 'Update',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    'delete' => 'Delete',
    'delete_plugin' => 'Delete Plugin and all of its files?',
    'click_to_delete_msg' => 'Click to Delete this Plugin files',
    'really_delete_msg' => 'Really Delete %s Plugin files?',
    99 => 'An unknown error occurred',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'create feed',
    2 => 'save',
    3 => 'delete',
    4 => 'cancel',
    10 => 'Content Syndication',
    11 => 'New Feed',
    12 => 'Admin Home',
    13 => 'To modify or delete a feed, click on the feed\'s title below. To create a new feed, click on New Feed above.',
    14 => 'Title',
    15 => 'Type',
    16 => 'Filename',
    17 => 'Format',
    18 => 'last updated',
    19 => 'Enabled',
    20 => 'Yes',
    21 => 'No',
    22 => '<i>(no feeds)</i>',
    23 => 'all Articles',
    24 => 'Feed Editor',
    25 => 'Feed Title',
    26 => 'Limit',
    27 => 'Length of entries',
    28 => '(0 = no text, 1 = full text, other = limit to that number of chars.)',
    29 => 'Description',
    30 => 'Last Update',
    31 => 'Character Set',
    32 => 'Language',
    33 => 'Contents',
    34 => 'Entries',
    35 => 'Hours',
    36 => 'Select type of feed',
    37 => '',
    38 => 'Error: Missing Fields',
    39 => 'Please fill in the Feed Title, Description, and Filename.',
    40 => 'Please enter a  number of entries or number of hours.',
    41 => 'Links',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Articles',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles',
    'num_articles' => '%s Article(s)'
);

###############################################################################
# admin/language.php (since v2.1.2)

$LANG_LANG = array(
    'language_admin_title' => 'Language Overrides',
    'language_manager' => 'Language Manager',
    'new_language_msg' => 'To modify or delete a language item, click on that item\'s edit icon below. To create a new item, click on "Create New" above.',
    'language_editor' => 'Language Editor',
    'id' => 'ID',
    'language' => 'Language',
    'name' => 'Name',
    'var_name' => 'Var Name',
    'name_tip' => 'Required just for language arrays.',
    'var_name_tip' => 'Can be a regular variable or array. Do not include the dollar sign at the beginning of the variable/array name.',
    'value' => 'Value'
);

###############################################################################
# admin/router.php

$LANG_ROUTER = array(
    1 => 'URL routing',
    2 => 'Routing Manager',
    3 => 'ID',
    4 => 'method',
    5 => 'rule',
    6 => 'route',
    7 => 'priority',
    8 => 'Increase priority',
    9 => 'Decrease priority',
    10 => 'Edit routing',
    11 => 'To modify or delete a route, click on the route\'s edit icon below. To create a new route, click on "Create New" above.  When you use placeholders (@), you must define the same placeholders in a rule and its route.',
    12 => 'Bad request method',
    13 => 'Rule is a mandatory item.',
    14 => 'Route is a mandatory item.',
    15 => 'Placeholders (@) in a rule and those in a route must be the same.',
    16 => 'Route must not start with "/index.php/".',
    17 => 'Database error occurred.',
    18 => '<strong>To enable URL routing, you have to enable URL rewrite in the Configuration.</strong>',
    19 => '<strong>To enable URL routing, you have to enable URL routing in the Configuration.</strong>',
    20 => '<ul><li>Placeholders (@) must be the same both in a rule and its route.</li><li>A placeholder starts with "@", followed by an alphabet, optionally followed by any length of alphabet or digit.</li><li>Placeholders are case-sensitive.</li></ul>',
    21 => 'Status Code',
    22 => 'Enabled',
    23 => 'Yes',
    24 => 'No'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Votre mot de passe a &eacute;t&eacute; envoy&eacute; par courriel et devrait vous parvenir sous peu. Suivez les instructions incluses dans le message et encore merci d'utiliser {$_CONF['site_name']}",
    2 => "Merci de proposer un article &agrave; {$_CONF['site_name']}.  Il a &eacute;t&eacute; envoy&eacute; &agrave; notre &eacute;quipe qui en disposera. Votre article sera publi&eacute; s'il est retenu.",
    3 => '',
    4 => '',
    5 => 'Vos informations ont &eacute;t&eacute; mises &agrave; jour avec succ&egrave;s.',
    6 => 'Vos pr&eacute;f&eacute;rences d\'affichage ont &eacute;t&eacute; mises &agrave; jour avec succ&egrave;s.',
    7 => 'Vos pr&eacute;f&eacute;rences de commentaire ont &eacute;t&eacute; mises &agrave; jour avec succ&egrave;s.',
    8 => 'Vous avez &eacute;t&eacute; d&eacute;connect&eacute; avec succ&egrave;s.',
    9 => 'Votre article a &eacute;t&eacute; enregistr&eacute; avec succ&egrave;s.',
    10 => 'L\'article a &eacute;t&eacute; supprim&eacute; avec succ&egrave;s.',
    11 => 'Votre cadre a &eacute;t&eacute; enregistr&eacute; avec succ&egrave;s.',
    12 => 'Le cadre a &eacute;t&eacute; supprim&eacute; avec succ&egrave;s.',
    13 => 'Votre sujet a &eacute;t&eacute; enregistr&eacute; avec succ&egrave;s.',
    14 => 'Le sujet et tous ses articles ainsi que ses cadres ont &eacute;t&eacute; supprim&eacute;s avec succ&egrave;s.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => 'Your user account has been locked and access to it has been disabled. For more information please contact the Admin.',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Le nouveau membre a &eacute;t&eacute; enregistr&eacute; avec succ&egrave;s.',
    22 => 'L\'utilisateur a &eacute;t&eacute; supprim&eacute; avec succ&egrave;s.',
    23 => 'Your passwords must match, please try again. Passwords are case sensitive.',
    24 => 'Your emails must match, please try again.',
    25 => 'You have not entered a valid email address, please try again.',
    26 => 'That email address is already being used by an account, please try again.',
    27 => 'Message envoy&eacute; avec succ&egrave;s.',
    28 => 'Le plugin a &eacute;t&eacute; supprim&eacute; avec succ&egrave;s.',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Acc&egrave;s interdit',
    31 => 'Sorry, This feature is not supported by the  database server this website is using.  Please note that all attempts to access unsupported features are logged.',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Message syst&egrave;me',
    41 => '',
    42 => '',
    43 => 'Account does not exist.',
    44 => 'Le plugin a &eacute;t&eacute; install&eacute; avec succ&egrave;s!',
    45 => 'Le plugin a &eacute;t&eacute; supprim&eacute; avec succ&egrave;s.',
    46 => 'Your username or email address was not found, please try again.',
    47 => 'Sorry you cannot currently request the password for your account. For more information please contact the Admin.',
    48 => "Merci d'avoir demand&eacute; un compte membre sur {$_CONF['site_name']}. La demande a &eacute;t&eacute; envoy&eacute;e &agrave; notre &eacute;quipe qui en disposera. Lorsque la demande sera accept&eacute;e, votre mot de passe vous sera envoy&eacute; par courriel &agrave; l'adresse que vous avez fournie.",
    49 => 'Votre groupe a &eacute;t&eacute; enregistr&eacute; avec succ&egrave;s.',
    50 => 'Le groupe a &eacute;t&eacute; supprim&eacute; avec succ&egrave;s.',
    51 => 'Ce nom de membre existe d&eacute;j&agrave;. Pri&egrave;re d\'en choisir un nouveau.',
    52 => 'Le courriel fourni ne para&icirc;t pas être valide.',
    53 => 'Votre nouveau mot de passe &agrave; &eacute;t&eacute; accept&eacute;. Pri&egrave;re de l\'inscrire ci-dessous pour acc&eacute;der au site.',
    54 => 'Votre requête pour l\'obtention d\'un nouveau mot de passe est expir&eacute;e. Pri&egrave;re d\'essayer de nouveau ci-dessous.',
    55 => 'Un courriel qui vient de vous être envoy&eacute; devrait vous parvenir sous peu. Pri&egrave;re de suivre les instructions du message et de proc&eacute;der &agrave; l\'enregistrement de votre nouveau mot de passe.',
    56 => 'L\'adresse courriel fournie est d&eacute;j&agrave; utilis&eacute;e par un autre compte.',
    57 => 'Votre compte &agrave; &eacute;t&eacute; effac&eacute; avec succ&egrave;s.',
    58 => 'Your feed has been successfully saved.',
    59 => 'The feed has been successfully deleted.',
    60 => 'The plugin was successfully updated',
    61 => 'Plugin %s: Unknown message placeholder',
    62 => 'The trackback comment has been deleted.',
    63 => 'An error occurred when deleting the trackback comment.',
    64 => 'Your trackback comment has been successfully sent.',
    65 => 'Weblog directory service successfully saved.',
    66 => 'The weblog directory service has been deleted.',
    67 => 'The new password does not match the confirmation password!',
    68 => 'You have to enter the correct current password.',
    69 => 'Your account has been blocked!',
    70 => 'Your account is awaiting administrator approval.',
    71 => 'Your account has now been confirmed and is awaiting administrator approval.',
    72 => 'An error occurred while attempting to install the plugin. See error.log for details.',
    73 => 'An error occurred while attempting to uninstall the plugin. See error.log for details.',
    74 => 'The pingback has been successfully sent.',
    75 => 'Trackbacks must be sent using a POST request.',
    76 => 'Do you really want to delete this item?',
    77 => 'WARNING:<br' . XHTML . '>You have set your default encoding to UTF-8. However, your server does not support multibyte encodings. Please install mbstring functions for PHP or choose a different character set/language.',
    78 => 'Please make sure that the email address and the confirmation email address are the same.',
    79 => 'The page you have been trying to open refers to a function that no longer exists on this site.',
    80 => 'The plugin that created this feed is currently disabled. You will not be able to edit this feed until you re-enable the parent plugin.',
    81 => 'You may have mistyped your login credentials.  Please try logging in again below.',
    82 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    83 => 'To change your password, email address, or for how long to remember you, please enter your current password.',
    84 => 'To delete your account, please enter your current password.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit articles.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    116 => 'Loading...',
    117 => 'Help page is not found.',
    118 => 'Click to select a date',
    119 => 'More..',
    120 => 'Send this?',
    121 => 'Saved a URL routing item.',
    122 => 'Could not save a URL routing item.',
    123 => 'Deleted a URL routing item.',
    130 => 'Your language item has been successfully deleted.',
    131 => 'Your language item has been successfully saved.',
    140 => 'Deleted comment(s).',
    141 => 'Failed to delete a comment.',
    142 => 'Approved comment(s).',
    143 => 'Banned user(s).',
    144 => 'Banned IP addresses with the Spamx plugin.',
    145 => 'Banned IP addresses with the Ban plugin.',
    150 => 'Successfully deleted all the files and directories used during the installation.',
    151 => 'Failed to delete some files and directories used during the installation.  Please remove them manually.',
    152 => 'All the files and directories used during the installation are left as they are.  It is dangerous to keep them on the server, so please don\'t forget to remove them manually.',
    153 => 'You last emailed an article %1$d seconds ago.  This site requires at least %2$d seconds between emailing articles.',
    160 => 'The plugin files was successfully deleted.',
    161 => 'The archive includes a file whose name includes an unsafe character.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname',
    500 => 'The Template Cache has been successfully cleared.',
    501 => 'A verification message has been sent to your email address. Please click on the link in the email to confirm your email address and update your account. If you log into your account again before you verify your email address you will be asked again for a email address.<br' . XHTML . '><br' . XHTML . '>Please note you have now been successfully logged out so you can complete this verification.',
    502 => 'Your request for a new email has expired. Please try again below.',
    503 => 'Your email has been successfully verified.',
    504 => 'Passwords must have a minimum of 8 characters and contain at least 1 number and 1 letter. Passwords are case sensitive.',
    505 => "Warning - The current theme {$_CONF['theme']} v{$_CONF['theme_gl_version']} is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}.",
    506 => "Warning - The current theme {$_CONF['theme']} (version not known) is not 100% compatible with this version of Geeklog (v2.2.1) and you will have issues using this site. The required minimum theme Geeklog version is v{$_CONF['min_theme_gl_version']}."
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Acc&egrave;s',
    'ownerroot' => 'Propri&eacute;taire/Admin',
    'group' => 'Groupe',
    'readonly' => 'Lecture seule',
    'accessrights' => 'Droits d\'acc&egrave;s',
    'owner' => 'Propri&eacute;taire',
    'grantgrouplabel' => 'Autorisation au del&agrave; du groupe d\'&eacute;dition',
    'permmsg' => 'REMARQUE: les membres sont tous les utilisateurs identifi&eacute;s et les anonymes sont tous les autres.',
    'securitygroups' => 'Groupe de s&eacute;curit&eacute;',
    'editrootmsg' => "Except&eacute; si vous êtes administrateur, vous ne pouvez pas modifier un autre administrateur. Vous pouvez modifier tous les utilisateurs except&eacute;s les administrateurs. Toutes tentatives de modifications d\'un administrateur sont enregistr&eacute;es. Retournez sur la <a href=\'{$_CONF['site_admin_url']}/user.php\'>page d'administration</a>.",
    'securitygroupsmsg' => 'S&eacute;lectionner les cases des groupes auxquels l\'utilisateur appartient',
    'groupeditor' => 'Editeur de groupe',
    'description' => 'Description',
    'name' => 'Nom',
    'rights' => 'Droits',
    'missingfields' => 'Champs manquants',
    'missingfieldsmsg' => 'Vous devez saisir un nom et une description',
    'groupmanager' => 'Administrateur de groupe',
    'newgroupmsg' => 'Pour modifier ou supprimer un groupe, cliquez sur le groupe ci-dessous. Pour cr&eacute;er un nouveu groupe, cliquez sur Nouveau Groupe. Les groupes natifs ne peuvent pas être supprim&eacute;s car ils sont utilis&eacute;s par le syst&egrave;me.',
    'groupname' => 'Nom du groupe',
    'coregroup' => 'Groupe syst&egrave;me',
    'yes' => 'Oui',
    'no' => 'Non',
    'corerightsdescr' => "Ce groupe est un groupe syst&egrave;me de {$_CONF['site_name']}.  Les droits de ce groupe ne peuvent pas être modifi&eacute;s.  La liste ci-dessous des droits d'acc&egrave;s du groupe n'est pas modifiable.",
    'groupmsg' => 'Les droits des groupes sont hi&eacute;rarchiques.  En ajoutant un groupe &agrave; un autre vous ajoutez tous les droits de ce groupe &agrave; l\'autre.  Lorsque c\'est possible, utilisez les groupes d&eacute;ja d&eacute;finis.  Si vous avez besoin de droits sp&eacute;cifiques, vous pouvez les choisir dans la liste ci-dessous.  Pour Ajouter un groupe &agrave; celui-ci cliquez sur la case du groupe &agrave; ajouter.',
    'coregroupmsg' => "Ce groupe est un groupe syst&egrave;me de {$_CONF['site_name']}.  Les droits de ce groupe ne peuvent pas être modifi&eacute;s. La liste ci-dessous des groupes inclus de ce groupe n'est pas modifiable.",
    'rightsdescr' => 'Les droits suivants peuvent être donn&eacute;s directement au groupe OU provenir d\'un groupe inclus. Les droits sans case &agrave; cocher proviennent de groupe inclus. Les droits qui ont des cases &agrave; cocher sont donn&eacute;s directement au groupe.',
    'lock' => 'Bloquer',
    'members' => 'Membres',
    'anonymous' => 'Anonymes',
    'permissions' => 'Permissions',
    'permissionskey' => 'R = lecture, E = modification, le droit de modification implique le droit de lecture',
    'edit' => 'Modifier',
    'none' => 'Rien',
    'accessdenied' => 'Acc&egrave;s interdit',
    'storydenialmsg' => "vous n'avez pas le droit de lire cette article. Peut-être que vous n'êtes pas membre de {$_CONF['site_name']}.  Vous pouvez <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">vous enregistrer</a> sur {$_CONF['site_name']} pour obtenir un compte membre!",
    'nogroupsforcoregroup' => 'Le groupe n\'inclue aucun autre groupe',
    'grouphasnorights' => 'Le groupe n\'a pas acc&egrave;s aux fonctions administratives',
    'newgroup' => 'Nouveau Groupe',
    'adminhome' => 'Accueil Admin',
    'save' => 'enregistrer',
    'cancel' => 'annuler',
    'delete' => 'supprimer',
    'canteditroot' => 'Vous avez essay&eacute; de modifier le groupe administrateur mais vous n\'en faites pas partie. Vous n\'avez pas acc&egrave;s &agrave; ce groupe. Veuillez contacter l\'administrateur si vous pensez que c\'est une erreur.',
    'listusers' => 'List Users',
    'listthem' => 'list',
    'usersingroup' => 'Users in group "%s"',
    'usersingroupmsg' => 'A list of users that belong to the group. Users lists here may belong directly to the group or are inherited from another group that has been added to this group.',
    'usergroupadmin' => 'User Group Administration',
    'add' => 'Add',
    'remove' => 'Remove',
    'availmembers' => 'Available Members',
    'groupmembers' => 'Group Members',
    'inheritmembers' => 'Inherited Group Members',
    'canteditgroup' => 'To edit this group, you have to be a member of the group. Please contact the system administrator if you feel this is an error.',
    'cantlistgroup' => 'To see the members of this group, you have to be a member yourself. Please contact the system administrator if you feel this is an error.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Search',
    'submit' => 'Submit',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'You are illegally trying access a plugin administration page.  Please note that all attempts to illegally access this page are logged.',
    'groupexists' => 'Group name already exists',
    'groupexistsmsg' => 'There is already a group with this name. Group names must be unique.',
    'demo_mode_denied_msg' => 'This feature is currently disabled while the site is in Demo Mode.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'database_admin' => 'Database Administration',
    'last_ten_backups' => '10 dernieres sauvegardes',
    'site_db_backup' => "{$_CONF['site_name']} Database Backup",
    'create_backup' => 'Backup Database',
    'do_backup' => 'Faire une sauvegarde',
    'backup_successful' => 'Sauvegarde de la base de donn&eacute;e effectu&eacute;e avec succ&egrave;s',
    'backup_error' => 'Error performing database backup.',
    'db_explanation' => 'Cliquez sur le bouton ci-dessous pour effectuer une sauvegarde de votre syst&egrave;me Geeklog',
    'backup_instructions' => 'To create a new backup of your site database, select the "Do Backup" button below. This will backup all current Geeklog tables. You can download a copy of the backup from the main Database Administration Screen.',
    'zero_size' => 'Sauvegarde &eacute;chou&eacute;e: la taille du fichier &eacute;tait de 0 octets.',
    'path_not_found' => "{$_CONF['backup_path']} n'existe pas ou n'est pas un r&eacute;pertoire.",
    'no_access' => "Erreur: le r&eacute;pertoire {$_CONF['backup_path']} n'est pas accessible.",
    'backup_file' => 'Fichier de sauvegarde',
    'size' => 'Taille',
    'bytes' => 'Octets',
    'total_number' => 'Total number of backups: %d',
    'download' => 'Click to download this file',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_myisam_menu' => 'Convert to MyISAM',
    'convert_myisam_title' => 'Convert to MyISAM tables',
    'convert_button' => 'Convert',
    'converting' => 'Converting',
    'no_innodb' => 'Your version of MySQL does not support InnoDB tables.',
    'no_myisam' => 'Your version of MySQL does not support MyISAM tables.',
    'innodb_instructions' => 'InnoDB tables can provide better performance on large databases. Please <a href="http://dev.mysql.com/doc/refman/5.7/en/converting-tables-to-innodb.html" target="_blank">read up</a> on the benefits and drawbacks of InnoDB tables before you perform a conversion.',
    'myisam_instructions' => 'MyISAM tables can provide better performance on smaller databases.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'already_converted_myisam' => 'It appears that all of the tables have already been converted to MyISAM.',
    'conversion_message' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'myisam_success' => 'Successfully converted tables to MyISAM.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimizing' => 'Optimizing',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_message' => 'Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.',
    'conversion_status' => 'Conversion Status',
    'optimization_status' => 'Optimization Status',
    'backup_status' => 'Backup Status',
    'backingup' => 'Performing Backup',
    'backup_title' => 'Backup the Geeklog Database',
    'backup_warning' => 'Note: The configuration is set to only backup database structures. No data will be backed up.',
    'latest_backup' => 'Latest Backup',
    'tables_to_backup' => 'Tables to Backup',
    'include' => 'Include',
    'exclude' => 'Exclude',
    'options' => 'Options',
    'struct_only' => 'Only Backup Table Structure (no data)',
    'max_files' => 'Maximum Backup Files to Keep',
    'disable_purge' => '("0" to disable purging.)',
    'use_gzip' => 'Use GZip if available',
    'configure' => 'Configure',
    'config_instructions' => 'Select any tables you wish to exclude from the backup. Other options can be found in the Geeklog Configuration under the Database tab.',
    'config_successful' => 'Tables to Backup list was saved successfully.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Entr&eacute;e',
    2 => 'Contacts',
    3 => 'Ecrire un article',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Statistiques du site',
    8 => 'Personnaliser',
    9 => 'Chercher',
    10 => 'Recherche avanc&eacute;e',
    11 => 'Directory'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Erreur 404',
    2 => 'Le syst&egrave;me ne trouve pas <b>http://</b>.',
    3 => "<p>Le fichier que vous demandez n'existe pas. Allez &agrave; la <a href=\'{$_CONF['site_url']}\'>page principale</a> ou la <a href=\'{$_CONF['site_url']}/search.php\'>page de recherche</a> afin de retrouver ce que vous avez perdu.",
    4 => "<p>We're sorry, but the page you have requested does not exist. We recommend going back to this <a href=\"%s\">related page</a>, or you may want to check the <a href=\"{$_CONF['site_url']}/\">home page</a>, or the <a href=\"{$_CONF['site_url']}/search.php\">search page</a> to see if you can find what you lost."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Vous devez vous connecter',
    2 => 'Vous devez vous identifier &agrave; l\'aide de l\'espace membre pour acc&eacute;der &agrave; cette partie du site.',
    3 => 'Accueil',
    4 => 'Nouveau membre'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for an article, go to the list of articles and click on "Send Ping" for the article. To send a trackback that is not related to an article, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'This site\'s URL',
    'pingback_note' => 'To send a pingback for an article, go to the list of articles and click on "Send Ping" for the article. To send a pingback that is not related to an article, <a href="%s">click here</a>.',
    'pbtarget_missing' => 'No Pingback URL',
    'pbtarget_required' => 'Please enter a pingback URL',
    'pb_error_details' => 'Error when sending the pingback:',
    'delete_trackback' => 'To delete this Trackback click: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Article Directory',
    'title_year' => 'Article Directory for %d',
    'title_month_year' => 'Article Directory for %s %d',
    'nav_top' => 'Back to Article Directory',
    'no_articles' => 'No articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# This here determines the order of the sentence "No new articles in 2 hrs"
# order it so it makes sense in your language:
# %i    item, "Articles"
# %n    amount, "2", "20" etc
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n new %i in the last %t %s',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'hours',
    'days' => 'days',
    'weeks' => 'weeks',
    'months' => 'months',
    'years' => 'years',
    'minute' => 'minute',
    'hour' => 'hour',
    'day' => 'day',
    'week' => 'week',
    'month' => 'month',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Janvier',
    2 => 'F&eacute;vrier',
    3 => 'Mars',
    4 => 'Avril',
    5 => 'Mai',
    6 => 'Juin',
    7 => 'Juillet',
    8 => 'Ao&ucirct',
    9 => 'Septembre',
    10 => 'Octobre',
    11 => 'Novembre',
    12 => 'D&eacute;cembre'
);

###############################################################################
# Short Month names

$LANG_MONTH_SHORT = array(
    1 => 'Jan',
    2 => 'Feb',
    3 => 'Mar',
    4 => 'Apr',
    5 => 'May',
    6 => 'Jun',
    7 => 'Jul',
    8 => 'Aug',
    9 => 'Sep',
    10 => 'Oct',
    11 => 'Nov',
    12 => 'Decr'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Dimanche',
    2 => 'Lundi',
    3 => 'Mardi',
    4 => 'Mercredi',
    5 => 'Jeudi',
    6 => 'Vendredi',
    7 => 'Samedi'
);

###############################################################################
# Short Weekday Names

$LANG_WEEK_SHORT = array(
    1 => 'Sun',
    2 => 'Mon',
    3 => 'Tue',
    4 => 'Wed',
    5 => 'Thu',
    6 => 'Fri',
    7 => 'Sat'
);

###############################################################################
# AM/PM

$LANG_AMPM = array(
    'am_pm' => array('am' => 'am', 'pm' => 'pm'),
    'AM_PM' => array('am' => 'AM', 'pm' => 'PM')
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Search',
    'limit_results' => 'Limit Results',
    'submit' => 'Submit',
    'edit' => 'Edit',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Admin Home',
    'create_new' => 'Create New',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Enabled',
    'disabled' => 'Disabled',
    'title' => 'Title',
    'page_title' => 'Page Title',
    'type' => 'Type',
    'topic' => 'Topic',
    'info' => 'Info',
    'help_url' => 'Help File URL',
    'save' => 'Save',
    'cancel' => 'Cancel',
    'install' => 'Install',
    'delete' => 'Delete',
    'deleteitem' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copy',
    'no_results' => '- No entries found -',
    'data_error' => 'There was an error processing the subscription data. Please check the data source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'token_expired_remote_user' => 'The security token for this operation has expired. Since you are a remote user you cannot re-authenticate, so you have lost your changes.',
    'token_re_authentication_error' => 'There was an error after your account was re-authenticated. It is unclear if the operation you were performing was executed or not.',
    'authenticate' => 'Authenticate',
    'approve' => 'Approve',
    'device' => 'Device',
    'device_desc' => 'For what device do you want this item to display for?',
    'for_all' => 'All',
    'for_mobile' => 'For Mobile',
    'for_computer' => 'For Computer',
    'all' => 'All',
    'mobile' => 'Mobile',
    'computer' => 'Computer',
    'edit_access_only' => 'Edit Access Only'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Comments Enabled',
    -1 => 'Comments Disabled',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Flat',
    'nested' => 'Nested',
    'threaded' => 'Threaded',
    'nocomment' => 'No Comments'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 Hour',
    7200 => '2 Hours',
    10800 => '3 Hours',
    28800 => '8 Hours',
    86400 => '1 Day',
    604800 => '1 Week',
    2678400 => '1 Month'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Not Featured',
    1 => 'Featured'
);

$LANG_frontpagecodes = array(
    0 => 'Show Only in Topic',
    1 => 'Show on Front Page'
);

$LANG_postmodes = array(
    'plaintext' => 'Plain Old Text',
    'html' => 'HTML Formatted'
);

$LANG_sortcodes = array(
    'ASC' => 'Oldest First',
    'DESC' => 'Newest First'
);

$LANG_statuscodes = array(
    0 => 'Normal',
    1 => 'Refreshing',
    10 => 'Archive'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Enabled',
    -1 => 'Trackback Disabled'
);

$LANG_structureddatatypes = array(
    'none' => 'None',
    'core-webpage' => 'WebPage',
    'core-article' => 'Article',
    'core-newsarticle' => 'NewsArticle',
    'core-blogposting' => 'BlogPosting'
);

$LANG_STRUCT_DATA = array(
    'lang_structured_data_type' => 'Structured Data Type',
    'autotag_desc_structureddata' => '[structureddata:schema_property]Property Value[/structureddata] - Adds a property to the structured data of the content that the autotag is embedded in.'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'mail_charset' => 'Email Character Set',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'path_site_logo' => 'Site Logo',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_editors' => 'Advanced Editors',
    'mail_settings' => 'Mail Settings',
    'dbdump_filename_prefix' => 'Backup File Name Prefix',
    'dbdump_tables_only' => 'Only Backup Table Structure',
    'dbdump_gzip' => 'Use GZip if available',
    'dbdump_max_files' => 'Maximum Backup Files to Keep',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'cache_templates' => 'Cache Templates?',
    'cache_mobile' => 'Cache Mobile Devices Separately?',
    'cache_resource' => 'Combine, Minify and Cache CSS and JavaScript Files?',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'switchlang_homepage' => 'Switch Language Block Redirects to Homepage',
    'new_item_set_current_lang' => 'Add Current Language Id to New Item',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'require_user_email' => 'Require User Email',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'Enable OAuth Login Method Google',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'Enable OAuth Login Method Microsoft',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'Enable OAuth Login Method Yahoo',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'github_login' => 'Enable OAuth Login Method GitHub',
    'github_consumer_key' => 'GitHub OAuth Consumer Key',
    'github_consumer_secret' => 'GitHub OAuth Consumer Secret',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Article Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Article Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Articles?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'advanced_editor_name' => 'Advanced Editor Name?',
    'wikitext_editor' => 'Wikitext Editor?',
    'remove_4byte_chars' => 'Remove 4-byte utf-8 characters?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Article Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Articles',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Articles Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Articles',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'whatsnew_cache_time' => 'Max Cache Time',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Articles per Page',
    'minnews' => 'Min. Articles per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'structured_data_type_default' => 'Structured Data Type Default',
    'structured_data_article_topic' => 'Structured Data of Articles in Topics',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Article',
    'related_topics' => 'Related Topics',
    'related_topics_max' => 'Max Related Topics to Display',
    'whats_related' => 'What\'s Related',
    'whats_related_max' => 'Max What\'s Related to Display',
    'whats_related_trim' => 'What\'s Related Title Length',
    'default_cache_time_article' => 'Default Article Cache Time',
    'blocks_article_topic_list_repeat_after' => 'Article Topic List Blocks Location Repeat',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Article as Featured?',
    'template_comments' => 'Template Comments in Output?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Articles in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'generate_user_icon' => 'Generate User Icon automatically?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating',
    'gravatar_identicon' => 'Gravatar Identicon',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_order' => 'Comment Order',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'likes_enabled' => 'Likes Enabled',
    'likes_articles' => 'Article Likes',
    'likes_comments' => 'Comment Likes',
    'likes_speedlimit' => 'Likes Speed Limit',
    'likes_users_listed' => 'User Listed',
    'likes_block_cache_time' => 'Cache Time',
    'likes_block_include_time' => 'Include Time',
    'likes_block_max_items' => 'Max Items Listed',
    'likes_block_displayed_actions' => 'Displayed Actions',
    'likes_block_title_trim_length' => 'Title Trim Length',
    'likes_block_likes_new_line' => 'Likes on New Line',
    'likes_block_type' => 'Type',
    'likes_block_subtype' => 'Sub Type',
    'likes_block_enable' => 'Enabled',
    'likes_block_isleft' => 'Display Block on Left',
    'likes_block_order' => 'Block Order',
    'likes_block_topic_option' => 'Topic Options',
    'likes_block_topic' => 'Topic',
    'likes_block_group_id' => 'Group',
    'likes_block_permissions' => 'Permissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'invalidloginattempts' => 'Max. Invalid Login Attempts',
    'invalidloginmaxtime' => 'Invalid Login Max Time',
    'enable_twofactorauth' => 'Enable Two Factor Authentication?',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'page_navigation_mobile_max_pages' => 'Max Pages for Navigation with Mobile Devices',
    'default_cache_time_block' => 'Default Block Cache Time',
    'titletoid' => 'Enable Title To Id?',
    '404_log' => 'Log 404 Errors',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'url_routing' => 'Enable URL Routing',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Article Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Articles in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent articles enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order',
    'search_use_topic' => 'Use Current Topic',
    'autotag_permissions_story' => '[article: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions',
    'autotag_permissions_topic' => '[topic: ] Permissions',
    'autotag_permissions_related_topics' => '[related_topics: ] Permissions',
    'autotag_permissions_related_items' => '[related_items: ] Permissions',
    'autotag_permissions_block' => '[block: ] Permissions',
    'autotag_permissions_structureddata' => '[structureddata: ] Permissions',
    'autotag_permissions_likes_block' => '[likes_block: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?',
    'filemanager_disabled' => 'Disable Filemanager?',
    'filemanager_browse_only' => 'Browse only mode?',
    'filemanager_default_view_mode' => 'Default view mode',
    'filemanager_show_confirmation' => 'Show confirmation?',
    'filemanager_search_box' => 'Show search box?',
    'filemanager_file_sorting' => 'File sorting',
    'filemanager_chars_only_latin' => 'Allow only latin chars?',
    'filemanager_date_format' => 'Date time format',
    'filemanager_logger' => 'Enable logger?',
    'filemanager_show_thumbs' => 'Show thumbnails?',
    'filemanager_generate_thumbnails' => 'Generate thumbnails?',
    'filemanager_upload_overwrite' => 'Overwrite existing file?',
    'filemanager_upload_file_size_limit' => 'Upload file size limit (MiB)',
    'filemanager_images_ext' => 'Image file extensions',
    'filemanager_show_video_player' => 'Show video player?',
    'filemanager_videos_ext' => 'Video file extensions',
    'filemanager_videos_player_width' => 'Video player width (px)',
    'filemanager_videos_player_height' => 'Video player height (px)',
    'filemanager_show_audio_player' => 'Show audio player?',
    'filemanager_audios_ext' => 'Audio file extensions',
    'cookie_consent' => 'Enable Cookie Consent',
    'terms_of_use_link' => 'Terms of Use Link',
    'privacy_policy_link' => 'Privacy Policy Link',
    'about_cookies_link' => 'About Cookies Consent Link',
    'ip_anonymization' => 'IP Anonymization'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Articles and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous',
    'sg_filemanager' => 'Filemanager'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_database_backup' => 'Database Backup',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_multilanguage' => 'Multi-Language Content',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Article',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_likes' => 'Likes',
    'fs_likes_block_settings' => 'Block Settings',
    'fs_likes_block_permissions' => 'Block Permissions',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Article Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings',
    'fs_filemanager_general' => 'General Settings',
    'fs_filemanager_upload' => 'Upload',
    'fs_filemanager_images' => 'Images',
    'fs_filemanager_videos' => 'Videos',
    'fs_filemanager_audios' => 'Audios'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_database' => 'Database',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Article',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_likes' => 'Likes',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics',
    'tab_filemanager_general' => 'General Settings',
    'tab_filemanager_upload' => 'Upload',
    'tab_filemanager_images' => 'Images',
    'tab_filemanager_videos' => 'Videos',
    'tab_filemanager_audios' => 'Audios'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html', 'Wiki-style Format' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'Login' => 'login', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Articles' => 'article', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user', 'User Updates' => 'user_update'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none'),
    31 => array('Newest First' => 'DESC', 'Oldest First' => 'ASC'),
    32 => array('Disabled' => 0, 'Just Article Pages' => 1, 'Articles and Topics' => 2),
    33 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (No Links)' => 2, 'Enabled (No Outbound Links)' => 3),
    34 => array('grid' => 'grid', 'list' => 'list'),
    35 => array('default' => 'default', 'Name (asc)' => 'NAME_ASC', 'Name (desc)' => 'NAME_DESC', 'Type (asc)' => 'TYPE_ASC', 'Type (desc)' => 'TYPE_DESC', 'Modified (asc)' => 'MODIFIED_ASC', 'Modified (desc)' => 'MODIFIED_DESC'),
    36 => array('False' => 'false', 'Frontpage only' => 'frontpage', 'Frontpage and Topics' => 'frontpage_topics'),
    37 => array('Disabled' => 0, 'Enabled (with "index.php")' => 1, 'Enabled (without "index.php")' => 2),
    38 => array('Mystery Man' => 'mm', 'Identicon' => 'identicon', 'MonsterId' => 'monsterid', 'WAvatar' => 'wavatar', 'Retro' => 'retro'),
    39 => array('None' => '', 'WebPage' => 'core-webpage', 'Article' => 'core-article', 'NewsArticle' => 'core-newsarticle', 'BlogPosting' => 'core-blogposting'),
    40 => array('False' => 0, 'Users and Anonymous' => 1, 'Users Only' => 2),
    41 => array('False' => 0, 'Likes and Dislikes' => 1, 'Likes Only' => 2),
    42 => array('None' => 0, 'Use individual Article Settings' => 1),
    43 => array('All' => 'all', 'Homepage Only' => 'homeonly', 'Select Topics' => 'selectedtopics'),
    44 => array('No access' => 0, 'Read-Only' => 2),
    46 => array('Likes and Dislikes' => 3, 'Likes Only' => 1, 'Dislikes Only' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'alphaNumericOrEmpty' => 'This field must be alpha numeric or empty',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'fileName' => 'This field must be a proper file name',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP',
    'config_setting_lang_array' => 'Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value',
    'config_setting_lang_array_element_req' => 'Requires at least one element. Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value'
);

