<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class VideoTopicDetails extends \Google\Collection
{
  protected $collection_key = 'topicIds';
  public $relevantTopicIds;
  public $topicCategories;
  public $topicIds;

  public function setRelevantTopicIds($relevantTopicIds)
  {
    $this->relevantTopicIds = $relevantTopicIds;
  }
  public function getRelevantTopicIds()
  {
    return $this->relevantTopicIds;
  }
  public function setTopicCategories($topicCategories)
  {
    $this->topicCategories = $topicCategories;
  }
  public function getTopicCategories()
  {
    return $this->topicCategories;
  }
  public function setTopicIds($topicIds)
  {
    $this->topicIds = $topicIds;
  }
  public function getTopicIds()
  {
    return $this->topicIds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VideoTopicDetails::class, 'Google_Service_YouTube_VideoTopicDetails');
