/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;

public final class DateHelper {
    public static final Date FIRST_DATE = DateHelper.getTimestampFromLong(441763200000L);
    public static final Date LAST_DATE = DateHelper.getTimestampFromLong(2524607946000L);
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;
    private static final int DEFAULT_DST_SAVINGS = 3600000;
    private static boolean HAS_DST_SAVINGS;

    private DateHelper() {
    }

    public static Date getDayStartDate(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            date = calendar.getTime();
        }
        return date;
    }

    public static Date getDayEndDate(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(14, 999);
            calendar.set(13, 59);
            calendar.set(12, 59);
            calendar.set(11, 23);
            date = calendar.getTime();
        }
        return date;
    }

    public static Date getCanonicalTime(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(6, 1);
            calendar.set(1, 1);
            calendar.set(14, 0);
            date = calendar.getTime();
        }
        return date;
    }

    public static int compare(Date date, Date date2, Date date3) {
        return DateHelper.compare(date, date2, date3.getTime());
    }

    public static int compare(Date date, Date date2, long l) {
        int n = 0;
        if (l < date.getTime()) {
            n = -1;
        } else if (l > date2.getTime()) {
            n = 1;
        }
        return n;
    }

    public static int compare(Date date, Date date2) {
        long l;
        int n = date == null || date2 == null ? (date == date2 ? 0 : (date == null ? 1 : -1)) : ((l = date.getTime() - date2.getTime()) == 0L ? 0 : (l > 0L ? 1 : -1));
        return n;
    }

    public static Date min(Date date, Date date2) {
        Date date3 = date == null ? date2 : (date2 == null ? date : (date.compareTo(date2) < 0 ? date : date2));
        return date3;
    }

    public static Date max(Date date, Date date2) {
        Date date3 = date == null ? date2 : (date2 == null ? date : (date.compareTo(date2) > 0 ? date : date2));
        return date3;
    }

    public static Duration getVariance(Task task, Date date, Date date2, TimeUnit timeUnit) {
        ProjectCalendar projectCalendar;
        Duration duration = null;
        if (date != null && date2 != null && (projectCalendar = task.getEffectiveCalendar()) != null) {
            duration = projectCalendar.getWork(date, date2, timeUnit);
        }
        if (duration == null) {
            duration = Duration.getInstance(0, timeUnit);
        }
        return duration;
    }

    public static Date getDateFromLong(long l) {
        TimeZone timeZone = TimeZone.getDefault();
        return new Date(l - (long)timeZone.getRawOffset());
    }

    public static Date getTimestampFromLong(long l) {
        Date date;
        TimeZone timeZone = TimeZone.getDefault();
        if (timeZone.inDaylightTime(date = new Date(l - (long)timeZone.getRawOffset()))) {
            int n = HAS_DST_SAVINGS ? timeZone.getDSTSavings() : 3600000;
            date = new Date(date.getTime() - (long)n);
        }
        return date;
    }

    public static Date getTime(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static void setTime(Calendar calendar, Date date) {
        if (date != null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            calendar.set(11, calendar2.get(11));
            calendar.set(12, calendar2.get(12));
            calendar.set(13, calendar2.get(13));
        }
    }

    public static Date setTime(Date date, Date date2) {
        Date date3;
        if (date2 == null) {
            date3 = date;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date2);
            int n = calendar.get(6) - 1;
            int n2 = calendar.get(11);
            int n3 = calendar.get(12);
            int n4 = calendar.get(13);
            int n5 = calendar.get(14);
            calendar.setTime(date);
            if (n != 0) {
                calendar.add(6, n);
            }
            calendar.set(14, n5);
            calendar.set(13, n4);
            calendar.set(12, n3);
            calendar.set(11, n2);
            date3 = calendar.getTime();
        }
        return date3;
    }

    public static Date getTimeFromMinutesPastMidnight(Integer n) {
        Date date = null;
        if (n != null) {
            int n2 = n;
            int n3 = n2 / 60;
            Calendar calendar = Calendar.getInstance();
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, n2 -= n3 * 60);
            calendar.set(11, n3);
            date = calendar.getTime();
        }
        return date;
    }

    static {
        Class<TimeZone> clazz = TimeZone.class;
        try {
            clazz.getMethod("getDSTSavings", null);
            HAS_DST_SAVINGS = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            HAS_DST_SAVINGS = false;
        }
    }
}

