=begin
= WebUnit::assert
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: assert.rb,v 1.1.1.1 2003/01/21 11:50:39 yuichi Exp $
=end

require 'webunit/converter'

module WebUnit

  include WebUnit::Utils

=begin
--- WebUnit#assert_urls(expected,actual,message='')
      compare two URLs. raise AssertionFailedError, when these are diferent.
=end

  def assert_urls( expected, actual, message='' )
    setup_assert
    message << " " unless message == ""
    if expected == nil || actual == nil
      message << "expected:<nil> but was:<#{actual}>" if expected == nil
      message << "expected:<#{expected}> but was:<nil>" if actual == nil
      raise_assertion_error( message )
    end

    some_expected = [expected, $URLBASE + expected]
    patterns = [actual, orthop_url(actual)]
    for exp in some_expected
      for e in [exp, orthop_url(exp)]
        for pattern in patterns
          return if e == pattern
        end
      end
    end

    message << "expected:<#{expected}> but was:<#{actual}>"
    raise_assertion_error( message )
  end

=begin
--- WebUnit#assert_input( name, type, value, actual, message="" )
      check attribute of input field.


=end

  def assert_input( name, type, value, actual, message="" )
    setup_assert
    message << " " unless message == ""
    unless name == actual.name
      message << "expected:<name:#{name}> but was:<name:#{actual.name}>"
      raise_assertion_error( message )
    end
    unless type == actual.type
      message << "expected:<type:#{type}> but was:<type:#{actual.type}>"
      raise_assertion_error( message )
    end
    unless value == actual.value
      message << "expected:<value:#{value}> but was:<value:#{actual.value}>"
      raise_assertion_error( message )
    end
  end

=begin
--- WebUnit#assert_select_option( value, data, selected, actual, message="" )


=end

  def assert_select_option( value, data, selected, actual, message="" )
    setup_assert
    message << " " unless message == ""
    unless value == actual.value
      message << "expected:<value:#{value}> but was:<value:#{actual.value}>"
      raise_assertion_error( message )
    end
    data = value if data == nil
    unless data == actual.data
      message << "expected:<data:#{data}> but was:<data:#{actual.data}>"
      raise_assertion_error( message )
    end
    unless selected == ( actual.stat == 'on' )
    #unless selected == ( '' == actual.attrs['selected'] )
      if selected
        message << "expected:<selected> but was:<unselected>"
      else
        message << "expected:<unselected> but was:<selected>"
      end
      raise_assertion_error( message )
    end
  end

=begin
--- WebUnit#assert_attrs( expected, actual, message="" )
      check attribute of input field.


=end

  def assert_attrs( expected, actual, message="" )
    setup_assert
    message << " " unless message == ""
    expected.each do |k,v|
      av = nil
      if actual.respond_to?( "#{k}" )
        av = actual.send( "#{k}" )
      else
        av = actual.attrs[k] if actual.attrs.key?( k )
      end
      unless av == v
        message << "expected:<#{k}:#{v}> but was:<#{k}:#{av}>"
        raise_assertion_error( message )
      end
    end
  end

=begin
--- WebUnit#assert_include( expected, actual, message="" )
      check ((|actual|)) has HtmlElems, which have ((|expected|)) as data


=end

  def assert_include( expected, actual, message="" )
    setup_assert
    message << " " unless message == ""
    unless actual.has?( expected ) then
      if actual.search( expected ) == []
        message << "expected:<#{expected.inspect}> but not exist in <#{actual.inspect}>."
        raise_assertion_error( message )
      end
    end
  end

=begin
--- WebUnit#assert_title( expected, actual, message="" )
      check title of ((|actual|)) and ((|expected|)) as string,
      append formatted body to message, when both differ.
=end

  def assert_title( expected, actual, message="" )
    setup_assert
    message << " " unless message == ""
    unless actual.title == expected then
      message << "expected:<#{expected}> but not exist in <#{actual.title}>."
      message << "\n#{'='*72}#{actual.format}\n#{'='*72}\n"
      raise_assertion_error( message )
    end
  end

end
