# This file was auto-generated by lib/generators/tasks/generate.rb

module Slack
  module Endpoint
    module Apps
      #
      # Returns list of permissions this app has on a team.
      #
      # @see https://api.slack.com/methods/apps.permissions.info
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/apps.permissions.info.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/apps.permissions.info.json
      def apps_permissions_info(options={})
        post("apps.permissions.info", options)
      end

      #
      # Allows an app to request additional scopes
      #
      # @option options [Object] :scopes
      #   A comma separated list of scopes to request for
      # @option options [Object] :trigger_id
      #   Token used to trigger the permissions API
      # @see https://api.slack.com/methods/apps.permissions.request
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/apps.permissions.request.md
      # @see https://github.com/aki017/slack-api-docs/blob/master/methods/apps.permissions.request.json
      def apps_permissions_request(options={})
        throw ArgumentError.new("Required arguments :scopes missing") if options[:scopes].nil?
        throw ArgumentError.new("Required arguments :trigger_id missing") if options[:trigger_id].nil?
        post("apps.permissions.request", options)
      end

    end
  end
end
