/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.OggCrc;

public class OggSpeexWriter
extends AudioFileWriter {
    private OutputStream out;
    private int mode;
    private int sampleRate;
    private int channels;
    private int nframes;
    private boolean vbr;
    private int size;
    private int streamSerialNumber;
    private byte[] dataBuffer;
    private int dataBufferPtr;
    private byte[] headerBuffer;
    private int headerBufferPtr;
    private int pageCount;
    private int packetCount;
    private long granulepos;

    public OggSpeexWriter() {
        if (this.streamSerialNumber == 0) {
            this.streamSerialNumber = new Random().nextInt();
        }
        this.dataBuffer = new byte[65565];
        this.dataBufferPtr = 0;
        this.headerBuffer = new byte[255];
        this.headerBufferPtr = 0;
        this.pageCount = 0;
        this.packetCount = 0;
        this.granulepos = 0L;
    }

    public OggSpeexWriter(int n, int n2, int n3, int n4, boolean bl) {
        this();
        this.setFormat(n, n2, n3, n4, bl);
    }

    private void setFormat(int n, int n2, int n3, int n4, boolean bl) {
        this.mode = n;
        this.sampleRate = n2;
        this.channels = n3;
        this.nframes = n4;
        this.vbr = bl;
    }

    public void setSerialNumber(int n) {
        this.streamSerialNumber = n;
    }

    public void close() throws IOException {
        this.flush(true);
        this.out.close();
    }

    public void open(String string) throws IOException {
        new File(string).delete();
        this.out = new FileOutputStream(string);
        this.size = 0;
    }

    public void writeHeader(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(108);
        byteArrayOutputStream.write("OggS".getBytes(), 0, 4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(2);
        OggSpeexWriter.writeLong(byteArrayOutputStream, 0L);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.streamSerialNumber);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.pageCount++);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(80);
        byteArrayOutputStream.write("Speex   ".getBytes(), 0, 8);
        byteArrayOutputStream.write("speex-1.0".getBytes(), 0, 9);
        byteArrayOutputStream.write(new byte[11], 0, 11);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 1);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 80);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.sampleRate);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.mode);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 4);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.channels);
        OggSpeexWriter.writeInt(byteArrayOutputStream, -1);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.mode == 0 ? 160 : (this.mode == 1 ? 320 : 640));
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.vbr ? 1 : 0);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.nframes);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = OggCrc.checksum(0, byArray, 0, byArray.length);
        byArray[22] = (byte)(0xFF & n);
        byArray[23] = (byte)(0xFF & n >>> 8);
        byArray[24] = (byte)(0xFF & n >>> 16);
        byArray[25] = (byte)(0xFF & n >>> 24);
        this.out.write(byArray);
        byteArrayOutputStream = new ByteArrayOutputStream(64);
        byteArrayOutputStream.write("OggS".getBytes(), 0, 4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        OggSpeexWriter.writeLong(byteArrayOutputStream, 0L);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.streamSerialNumber);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.pageCount++);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(0xFF & string.length() + 8);
        OggSpeexWriter.writeInt(byteArrayOutputStream, string.length());
        byteArrayOutputStream.write(string.getBytes(), 0, string.length());
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byArray = byteArrayOutputStream.toByteArray();
        n = OggCrc.checksum(0, byArray, 0, byArray.length);
        byArray[22] = (byte)(0xFF & n);
        byArray[23] = (byte)(0xFF & n >>> 8);
        byArray[24] = (byte)(0xFF & n >>> 16);
        byArray[25] = (byte)(0xFF & n >>> 24);
        this.out.write(byArray);
    }

    public void writePacket(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.packetCount > 250) {
            this.flush(false);
        }
        System.arraycopy(byArray, n, this.dataBuffer, this.dataBufferPtr, n2);
        this.dataBufferPtr += n2;
        this.headerBuffer[this.headerBufferPtr++] = (byte)n2;
        ++this.packetCount;
        this.granulepos += (long)(this.mode == 0 ? 160 : 320);
    }

    private void flush(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(284);
        byteArrayOutputStream.write("OggS".getBytes(), 0, 4);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0xFF & (bl ? 4 : 0));
        OggSpeexWriter.writeLong(byteArrayOutputStream, this.granulepos);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.streamSerialNumber);
        OggSpeexWriter.writeInt(byteArrayOutputStream, this.pageCount++);
        OggSpeexWriter.writeInt(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(0xFF & this.packetCount);
        byteArrayOutputStream.write(this.headerBuffer, 0, this.packetCount);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = OggCrc.checksum(0, byArray, 0, byArray.length);
        n = OggCrc.checksum(n, this.dataBuffer, 0, this.dataBufferPtr);
        byArray[22] = (byte)(0xFF & n);
        byArray[23] = (byte)(0xFF & n >>> 8);
        byArray[24] = (byte)(0xFF & n >>> 16);
        byArray[25] = (byte)(0xFF & n >>> 24);
        this.out.write(byArray);
        this.out.write(this.dataBuffer, 0, this.dataBufferPtr);
        this.dataBufferPtr = 0;
        this.headerBufferPtr = 0;
        this.packetCount = 0;
    }
}

