/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import java.nio.ByteBuffer;

final class RANSDecodingSymbol {
    int start;
    int freq;

    RANSDecodingSymbol() {
    }

    public void set(int start, int freq) {
        this.start = start;
        this.freq = freq;
    }

    public int advanceSymbolStep(int r, int scaleBits) {
        int mask = (1 << scaleBits) - 1;
        return this.freq * (r >> scaleBits) + (r & mask) - this.start;
    }

    public int advanceSymbol(int rIn, ByteBuffer byteBuffer, int scaleBits) {
        int mask = (1 << scaleBits) - 1;
        int r = rIn;
        if ((r = this.freq * (r >> scaleBits) + (r & mask) - this.start) < 0x800000) {
            int b;
            while ((r = r << 8 | (b = 0xFF & byteBuffer.get())) < 0x800000) {
            }
        }
        return r;
    }
}

