/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.ContactList;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Address;
import javax.sip.header.ContactHeader;

public final class Contact
extends AddressParametersHeader
implements ContactHeader {
    private static final long serialVersionUID = 1677294871695706288L;
    public static final String ACTION = "action";
    public static final String PROXY = "proxy";
    public static final String REDIRECT = "redirect";
    public static final String EXPIRES = "expires";
    public static final String Q = "q";
    private ContactList contactList;
    protected boolean wildCardFlag;

    public Contact() {
        super("Contact");
    }

    @Override
    public void setParameter(String name, String value2) throws ParseException {
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValueAsObject(value2);
        } else {
            nv = new NameValue(name, value2);
            if (name.equalsIgnoreCase("methods")) {
                nv.setQuotedValue();
            }
            this.parameters.set(nv);
        }
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.wildCardFlag) {
            buffer.append('*');
        } else {
            if (this.address.getAddressType() == 1) {
                this.address.encode(buffer);
            } else {
                buffer.append('<');
                this.address.encode(buffer);
                buffer.append('>');
            }
            if (!this.parameters.isEmpty()) {
                buffer.append(";");
                this.parameters.encode(buffer);
            }
        }
        return buffer;
    }

    public ContactList getContactList() {
        return this.contactList;
    }

    public boolean getWildCardFlag() {
        return this.wildCardFlag;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public NameValueList getContactParms() {
        return this.parameters;
    }

    public int getExpires() {
        return this.getParameterAsInt(EXPIRES);
    }

    public void setExpires(int expiryDeltaSeconds) {
        Integer deltaSeconds = expiryDeltaSeconds;
        this.parameters.set(EXPIRES, deltaSeconds);
    }

    public float getQValue() {
        return this.getParameterAsFloat(Q);
    }

    public void setContactList(ContactList cl) {
        this.contactList = cl;
    }

    public void setWildCardFlag(boolean w) {
        this.wildCardFlag = true;
        this.address = new AddressImpl();
        this.address.setWildCardFlag();
    }

    @Override
    public void setAddress(Address address) {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        this.address = (AddressImpl)address;
        this.wildCardFlag = false;
    }

    public void setQValue(float qValue) throws InvalidArgumentException {
        if (qValue != -1.0f && (qValue < 0.0f || qValue > 1.0f)) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Contact, setQValue(), the qValue is not between 0 and 1");
        }
        this.parameters.set(Q, Float.valueOf(qValue));
    }

    @Override
    public Object clone() {
        Contact retval = (Contact)super.clone();
        if (this.contactList != null) {
            retval.contactList = (ContactList)this.contactList.clone();
        }
        return retval;
    }

    public void setWildCard() {
        this.setWildCardFlag(true);
    }

    public boolean isWildCard() {
        return this.address.isWildcard();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ContactHeader && super.equals(other);
    }

    public void removeSipInstanceParam() {
        if (this.parameters != null) {
            this.parameters.delete("+sip.instance");
        }
    }

    public String getSipInstanceParam() {
        return (String)this.parameters.getValue("+sip.instance");
    }

    public void setSipInstanceParam(String value2) {
        this.parameters.set("+sip.instance", value2);
    }

    public void removePubGruuParam() {
        if (this.parameters != null) {
            this.parameters.delete("pub-gruu");
        }
    }

    public String getPubGruuParam() {
        return (String)this.parameters.getValue("pub-gruu");
    }

    public void setPubGruuParam(String value2) {
        this.parameters.set("pub-gruu", value2);
    }

    public void removeTempGruuParam() {
        if (this.parameters != null) {
            this.parameters.delete("temp-gruu");
        }
    }

    public String getTempGruuParam() {
        return (String)this.parameters.getValue("temp-gruu");
    }

    public void setTempGruuParam(String value2) {
        this.parameters.set("temp-gruu", value2);
    }
}

