/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRedirector;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    public static final String NAME = "redirect";
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response2) {
        return this.redirector.isRedirect(response2) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public boolean onHeader(Response response2, HttpField field) {
        return field.getHeader() != HttpHeader.CONTENT_ENCODING;
    }

    @Override
    public void onComplete(Result result2) {
        Request request = result2.getRequest();
        Response response2 = result2.getResponse();
        if (result2.isSucceeded()) {
            this.redirector.redirect(request, response2, null);
        } else {
            this.redirector.fail(request, response2, result2.getFailure());
        }
    }
}

