/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.rtp.rtcp.RtcpPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/SentRtcpStats;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "()V", "sentRtcpCounts", "", "", "", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class SentRtcpStats
extends ObserverNode {
    @NotNull
    private Map<String, Integer> sentRtcpCounts = new ConcurrentHashMap();

    public SentRtcpStats() {
        super("Sent RTCP stats");
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        RtcpPacket rtcpPacket = (RtcpPacket)packetInfo.packetAs();
        String string = Reflection.getOrCreateKotlinClass(rtcpPacket.getClass()).getSimpleName();
        Intrinsics.checkNotNull(string);
        this.sentRtcpCounts.merge(string, 1, (n, p1$other) -> n + p1$other);
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d1 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        Map<String, Integer> $this$forEach$iv = this.sentRtcpCounts;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Integer> element$iv;
            Map.Entry<String, Integer> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String rtcpType = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            $this$getNodeStats_u24lambda_u2d1.addNumber("num_" + rtcpType + "_tx", count);
        }
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

