/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.Transceiver;
import org.jitsi.nlj.TransceiverEventHandler;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.RemoteSsrcAssociation;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.UnparsedPacket;
import org.jitsi.rtp.extensions.PacketExtensionsKt;
import org.jitsi.rtp.rtcp.CompoundRtcpPacket;
import org.jitsi.rtp.rtcp.RtcpByePacket;
import org.jitsi.rtp.rtcp.RtcpHeader;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.rtcp.RtcpSdesPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.SdesChunk;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtp.RtpHeader;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.TransportConfig;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.SourceVideoTypeMessage;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayEndpointSender;
import org.jitsi.videobridge.relay.RelayMessageTransport;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.relay.RelayedPacketInfo;
import org.jitsi.videobridge.rest.root.debug.EndpointDebugFeatures;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.transport.dtls.DtlsTransport;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.PacketUtils;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u0000 \u009c\u00012\u00020\u00012\u00020\u0002:\b\u009c\u0001\u009d\u0001\u009e\u0001\u009f\u0001BC\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010Q\u001a\u00020\u000b2\u0006\u0010R\u001a\u00020\u0004J\u000e\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020=J4\u0010V\u001a\u00020T2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010W\u001a\u0004\u0018\u00010\u00042\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0YJ\u000e\u0010]\u001a\u00020T2\u0006\u0010^\u001a\u00020@J\u0006\u0010_\u001a\u00020`J.\u0010a\u001a\u00020T2\u0006\u0010b\u001a\u00020c2\b\u0010d\u001a\u0004\u0018\u00010\u00042\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u00020T0fH\u0002J\u000e\u0010h\u001a\u00020\u000b2\u0006\u0010i\u001a\u00020jJ\u000e\u0010k\u001a\u00020T2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010l\u001a\u00020TJ\u0010\u0010m\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010n\u001a\u0004\u0018\u00010\u001e2\u0006\u0010o\u001a\u00020\u001dJ\u0006\u0010p\u001a\u000204J\u0010\u0010q\u001a\u00020E2\u0006\u0010d\u001a\u00020\u0004H\u0002J\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020\u001d0Y2\u0006\u0010b\u001a\u00020cH\u0002J\u000e\u0010s\u001a\u00020T2\u0006\u0010i\u001a\u00020jJ\u0010\u0010t\u001a\u00020T2\u0006\u0010i\u001a\u00020uH\u0002J\u000e\u0010v\u001a\u00020\u000b2\u0006\u0010w\u001a\u00020xJ\b\u0010y\u001a\u00020\u000bH\u0002J(\u0010z\u001a\u00020T2\u0006\u0010d\u001a\u00020\u00042\u0006\u0010{\u001a\u00020\u001d2\u0006\u0010|\u001a\u00020\u001d2\u0006\u0010}\u001a\u00020~H\u0016J\u0006\u0010\u007f\u001a\u00020TJ\u000f\u0010\u0080\u0001\u001a\u00020T2\u0006\u0010\u0003\u001a\u00020\u0004J%\u0010\u0081\u0001\u001a\u00020T2\u0006\u0010b\u001a\u00020c2\n\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u00012\b\u0010d\u001a\u0004\u0018\u00010\u0004J\u0019\u0010\u0084\u0001\u001a\u00020T2\u0006\u0010b\u001a\u00020c2\b\u0010d\u001a\u0004\u0018\u00010\u0004J\u0007\u0010\u0085\u0001\u001a\u00020TJ\u0011\u0010\u0086\u0001\u001a\u00020T2\u0006\u0010b\u001a\u00020jH\u0016J\u0011\u0010\u0087\u0001\u001a\u00020T2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001J.\u0010\u008a\u0001\u001a\u00020T2\u0007\u0010\u008b\u0001\u001a\u00020\u001e2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0YH\u0002J\u0018\u0010\u008c\u0001\u001a\u00020T2\u0006\u0010w\u001a\u00020x2\u0007\u0010\u008d\u0001\u001a\u00020\u000bJ'\u0010\u008e\u0001\u001a\u00020T2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0002J\u0010\u0010\u0095\u0001\u001a\u00020T2\u0007\u0010\u0096\u0001\u001a\u00020`J\t\u0010\u0097\u0001\u001a\u00020TH\u0002J\t\u0010\u0098\u0001\u001a\u00020TH\u0002J+\u0010\u0099\u0001\u001a\u00020T2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0YJ\t\u0010\u009a\u0001\u001a\u00020TH\u0002J\u0011\u0010\u009b\u0001\u001a\u00020\u000b2\u0006\u0010b\u001a\u00020jH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cj\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010)R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010-R\u0011\u00107\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b8\u00100R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010>\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\u001cj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020@0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020E0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010H\u001a\u00020I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0016\u0010L\u001a\n \u0018*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010M\u001a\u00020N\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010P\u00a8\u0006\u00a0\u0001"}, d2={"Lorg/jitsi/videobridge/relay/Relay;", "Lorg/jitsi/videobridge/EncodingsManager$EncodingsUpdateListener;", "Lorg/jitsi/videobridge/PotentialPacketHandler;", "id", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "meshId", "iceControlling", "", "useUniquePort", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;ZZLjava/time/Clock;)V", "getConference", "()Lorg/jitsi/videobridge/Conference;", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "kotlin.jvm.PlatformType", "dtlsTransport", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport;", "endpointsBySsrc", "Ljava/util/HashMap;", "", "Lorg/jitsi/videobridge/relay/RelayedEndpoint;", "Lkotlin/collections/HashMap;", "endpointsLock", "", "eventEmitter", "Lorg/jitsi/utils/event/EventEmitter;", "Lorg/jitsi/videobridge/AbstractEndpoint$EventHandler;", "expired", "iceTransport", "Lorg/jitsi/videobridge/transport/ice/IceTransport;", "getId", "()Ljava/lang/String;", "incomingBitrateBps", "", "getIncomingBitrateBps", "()D", "incomingPacketRate", "getIncomingPacketRate", "()J", "logger", "getMeshId", "messageTransport", "Lorg/jitsi/videobridge/relay/RelayMessageTransport;", "outgoingBitrateBps", "getOutgoingBitrateBps", "outgoingPacketRate", "getOutgoingPacketRate", "outgoingSrtpPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "payloadTypes", "", "Lorg/jitsi/nlj/format/PayloadType;", "relayedEndpoints", "rtpExtensions", "Lorg/jitsi/nlj/rtp/RtpExtension;", "rttListener", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "senders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jitsi/videobridge/relay/RelayEndpointSender;", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "statistics", "Lorg/jitsi/videobridge/relay/Relay$Statistics;", "getStatistics", "()Lorg/jitsi/videobridge/relay/Relay$Statistics;", "timelineLogger", "transceiver", "Lorg/jitsi/nlj/Transceiver;", "getTransceiver", "()Lorg/jitsi/nlj/Transceiver;", "acceptWebSocket", "password", "addPayloadType", "", "payloadType", "addRemoteEndpoint", "statsId", "audioSources", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "videoSources", "Lorg/jitsi/nlj/MediaSourceDesc;", "addRtpExtension", "rtpExtension", "describeTransport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "doRtcpCallbacks", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "endpointId", "callback", "Lkotlin/Function1;", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "doSendSrtp", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "endpointExpired", "expire", "getEndpoint", "getEndpointBySsrc", "ssrc", "getMessageTransport", "getOrCreateRelaySender", "getRtcpSsrcs", "handleIncomingPacket", "handleMediaPacket", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "isFeatureEnabled", "feature", "Lorg/jitsi/videobridge/rest/root/debug/EndpointDebugFeatures;", "isTransportConnected", "onNewSsrcAssociation", "primarySsrc", "secondarySsrc", "type", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "relayMessageTransportConnected", "removeRemoteEndpoint", "rtcpPacketReceived", "receivedTime", "Ljava/time/Instant;", "rtcpPacketSent", "scheduleRelayMessageTransportTimeout", "send", "sendMessage", "msg", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "setEndpointMediaSources", "ep", "setFeature", "enabled", "setSrtpInformation", "chosenSrtpProtectionProfile", "", "tlsRole", "Lorg/jitsi/nlj/srtp/TlsRole;", "keyingMaterial", "", "setTransportInfo", "transportInfo", "setupDtlsTransport", "setupIceTransport", "updateRemoteEndpoint", "updateStatsOnExpire", "wants", "Companion", "IncomingRelayPacketHandler", "Statistics", "TransceiverEventHandlerImpl", "jitsi-videobridge"})
public final class Relay
implements EncodingsManager.EncodingsUpdateListener,
PotentialPacketHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Conference conference;
    @Nullable
    private final String meshId;
    @NotNull
    private final EventEmitter<AbstractEndpoint.EventHandler> eventEmitter;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<PayloadType> payloadTypes;
    @NotNull
    private final List<RtpExtension> rtpExtensions;
    private boolean expired;
    @NotNull
    private final IceTransport iceTransport;
    @NotNull
    private final DtlsTransport dtlsTransport;
    private final DiagnosticContext diagnosticContext;
    private final Logger timelineLogger;
    @NotNull
    private final HashMap<String, RelayedEndpoint> relayedEndpoints;
    @NotNull
    private final HashMap<Long, RelayedEndpoint> endpointsBySsrc;
    @NotNull
    private final Object endpointsLock;
    @NotNull
    private final ConcurrentHashMap<String, RelayEndpointSender> senders;
    @NotNull
    private final Statistics statistics;
    @NotNull
    private final EndpointConnectionStats.EndpointConnectionStatsListener rttListener;
    @NotNull
    private final Transceiver transceiver;
    @NotNull
    private final RelayMessageTransport messageTransport;
    @NotNull
    private final PacketInfoQueue outgoingSrtpPacketQueue;
    @Nullable
    private SrtpTransformers srtpTransformers;
    @JvmField
    @NotNull
    public static final CountingErrorHandler queueErrorCounter = new CountingErrorHandler();
    @NotNull
    private static final String SRTP_QUEUE_ENTRY_EVENT = "Entered Relay SRTP sender outgoing queue";
    @NotNull
    private static final String SRTP_QUEUE_EXIT_EVENT = "Exited Relay SRTP sender outgoing queue";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Relay(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, @Nullable String meshId, boolean iceControlling, boolean useUniquePort, @NotNull Clock clock) {
        void $this$outgoingSrtpPacketQueue_u24lambda_u2d4;
        Object $this$transceiver_u24lambda_u2d2;
        Object $this$diagnosticContext_u24lambda_u2d1;
        Object $this$logger_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.id = id;
        this.conference = conference;
        this.meshId = meshId;
        this.eventEmitter = new SyncEventEmitter();
        Object object = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        Logger logger = object;
        Relay relay = this;
        boolean bl = false;
        $this$logger_u24lambda_u2d0.addContext("relayId", this.id);
        relay.logger = object;
        this.payloadTypes = new ArrayList();
        this.rtpExtensions = new ArrayList();
        this.iceTransport = new IceTransport(this.id, iceControlling, useUniquePort, this.logger, clock);
        this.dtlsTransport = new DtlsTransport(this.logger);
        $this$logger_u24lambda_u2d0 = object = this.conference.newDiagnosticContext();
        relay = this;
        boolean bl2 = false;
        ((ConcurrentHashMap)$this$diagnosticContext_u24lambda_u2d1).put("relay_id", this.id);
        relay.diagnosticContext = object;
        this.timelineLogger = this.logger.createChildLogger("timeline." + this.getClass().getName());
        this.relayedEndpoints = new HashMap();
        this.endpointsBySsrc = new HashMap();
        this.endpointsLock = new Object();
        this.senders = new ConcurrentHashMap();
        this.statistics = new Statistics();
        this.rttListener = new EndpointConnectionStats.EndpointConnectionStatsListener(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRttUpdate(double newRttMs) {
                if (newRttMs > 0.0) {
                    this.this$0.getTransceiver().removeEndpointConnectionStatsListener(this);
                    Relay.access$getIceTransport$p(this.this$0).updateStatsOnInitialRtt(newRttMs);
                }
            }
        };
        ExecutorService executorService = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService, "CPU_POOL");
        ExecutorService executorService2 = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService2, "CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "SCHEDULED_POOL");
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Intrinsics.checkNotNullExpressionValue(diagnosticContext, "diagnosticContext");
        $this$diagnosticContext_u24lambda_u2d1 = object = new Transceiver(this.id, executorService, executorService2, scheduledExecutorService, diagnosticContext, this.logger, new TransceiverEventHandlerImpl(), clock);
        relay = this;
        boolean bl3 = false;
        ((Transceiver)$this$transceiver_u24lambda_u2d2).setIncomingPacketHandler(new ConsumerNode(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
                super("receiver chain handler");
            }

            protected void consume(@NotNull PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                this.this$0.handleIncomingPacket(packetInfo);
            }

            public void trace(@NotNull Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                f.invoke();
            }
        });
        ((Transceiver)$this$transceiver_u24lambda_u2d2).addEndpointConnectionStatsListener(this.rttListener);
        ((Transceiver)$this$transceiver_u24lambda_u2d2).setLocalSsrc(MediaType.AUDIO, this.conference.getLocalAudioSsrc());
        ((Transceiver)$this$transceiver_u24lambda_u2d2).setLocalSsrc(MediaType.VIDEO, this.conference.getLocalVideoSsrc());
        ((Transceiver)$this$transceiver_u24lambda_u2d2).getRtcpEventNotifier().addRtcpEventListener(new RtcpListener(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                this.this$0.rtcpPacketReceived(packet, receivedTime, null);
            }

            public void rtcpPacketSent(@NotNull RtcpPacket packet) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                this.this$0.rtcpPacketSent(packet, null);
            }
        }, true);
        relay.transceiver = object;
        this.messageTransport = new RelayMessageTransport(this, () -> Relay.messageTransport$lambda-3(this), this.conference, this.logger);
        this.conference.getEncodingsManager().subscribe(this);
        this.setupIceTransport();
        this.setupDtlsTransport();
        this.conference.getVideobridge().getStatistics().totalRelays.inc();
        String string = this.getClass().getSimpleName() + "-outgoing-packet-queue";
        ExecutorService executorService3 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService3, "IO_POOL");
        $this$transceiver_u24lambda_u2d2 = object = new PacketInfoQueue(string, executorService3, (Function1<? super PacketInfo, Boolean>)new Function1<PacketInfo, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull PacketInfo p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((Relay)this.receiver).doSendSrtp(p0);
            }
        }, TransportConfig.Companion.getQueueSize());
        relay = this;
        boolean bl4 = false;
        $this$outgoingSrtpPacketQueue_u24lambda_u2d4.setErrorHandler(queueErrorCounter);
        relay.outgoingSrtpPacketQueue = object;
    }

    public /* synthetic */ Relay(String string, Conference conference, Logger logger, String string2, boolean bl, boolean bl2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(string, conference, logger, string2, bl, bl2, clock);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Conference getConference() {
        return this.conference;
    }

    @Nullable
    public final String getMeshId() {
        return this.meshId;
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    @NotNull
    public final Transceiver getTransceiver() {
        return this.transceiver;
    }

    @NotNull
    public final RelayMessageTransport getMessageTransport() {
        return this.messageTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u2d6 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$_get_debugState__u24lambda_u2d6.put("iceTransport", this.iceTransport.getDebugState());
        $this$_get_debugState__u24lambda_u2d6.put("dtlsTransport", this.dtlsTransport.getDebugState());
        $this$_get_debugState__u24lambda_u2d6.put("transceiver", this.transceiver.getNodeStats().toJson());
        $this$_get_debugState__u24lambda_u2d6.put("messageTransport", this.messageTransport.getDebugState());
        JSONObject remoteEndpoints = new JSONObject();
        JSONObject endpointsBySsrcMap = new JSONObject();
        Iterator<RelayEndpointSender> iterator2 = this.endpointsLock;
        synchronized (iterator2) {
            boolean $i$a$-synchronized-Relay$debugState$1$232 = false;
            for (RelayedEndpoint entry : this.relayedEndpoints.values()) {
                ((Map)remoteEndpoints).put(entry.getId(), entry.getDebugState());
            }
            for (Map.Entry entry : ((Map)this.endpointsBySsrc).entrySet()) {
                long s2 = ((Number)entry.getKey()).longValue();
                RelayedEndpoint e = (RelayedEndpoint)entry.getValue();
                Long l = s2;
                ((Map)endpointsBySsrcMap).put(l, e.getId());
            }
            Unit $i$a$-synchronized-Relay$debugState$1$232 = Unit.INSTANCE;
        }
        $this$_get_debugState__u24lambda_u2d6.put("remoteEndpoints", remoteEndpoints);
        $this$_get_debugState__u24lambda_u2d6.put("endpointsBySsrc", endpointsBySsrcMap);
        JSONObject endpointSenders = new JSONObject();
        for (RelayEndpointSender s3 : this.senders.values()) {
            ((Map)endpointSenders).put(s3.getId(), s3.getDebugState());
        }
        $this$_get_debugState__u24lambda_u2d6.put("senders", endpointSenders);
        return jSONObject;
    }

    private final void setupIceTransport() {
        this.iceTransport.incomingDataHandler = new IceTransport.IncomingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataReceived(@NotNull byte[] data2, int offset, int length, @NotNull Instant receivedTime) {
                Intrinsics.checkNotNullParameter(data2, "data");
                Intrinsics.checkNotNullParameter(receivedTime, "receivedTime");
                if (PacketUtils.looksLikeDtls(data2, offset, length)) {
                    Relay.access$getDtlsTransport$p(this.this$0).dtlsDataReceived(data2, offset, length);
                } else {
                    RelayedPacketInfo relayedPacketInfo;
                    byte[] copy2 = ByteBufferPool.getBuffer(length + 10 + 20);
                    System.arraycopy(data2, offset, copy2, 10, length);
                    Intrinsics.checkNotNullExpressionValue(copy2, "copy");
                    RelayedPacketInfo $this$dataReceived_u24lambda_u2d0 = relayedPacketInfo = new RelayedPacketInfo((Packet)new UnparsedPacket(copy2, 10, length), this.this$0.getMeshId());
                    boolean bl = false;
                    $this$dataReceived_u24lambda_u2d0.setReceivedTime(receivedTime);
                    RelayedPacketInfo pktInfo = relayedPacketInfo;
                    Relay.access$handleMediaPacket(this.this$0, pktInfo);
                }
            }
        };
        this.iceTransport.eventHandler = new IceTransport.EventHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void connected() {
                Relay.access$getLogger$p(this.this$0).info("ICE connected");
                Relay.access$getEventEmitter$p(this.this$0).fireEvent(setupIceTransport.connected.1.INSTANCE);
                this.this$0.getTransceiver().setOutgoingPacketHandler(new PacketHandler(this.this$0){
                    final /* synthetic */ Relay this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void processPacket(@NotNull PacketInfo packetInfo) {
                        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                        packetInfo.addEvent("Entered Relay SRTP sender outgoing queue");
                        Relay.access$getOutgoingSrtpPacketQueue$p(this.this$0).add(packetInfo);
                    }
                });
                TaskPools.IO_POOL.execute(Relay.access$getIceTransport$p(this.this$0)::startReadingData);
                TaskPools.IO_POOL.execute(Relay.access$getDtlsTransport$p(this.this$0)::startDtlsHandshake);
            }

            public void failed() {
                Relay.access$getEventEmitter$p(this.this$0).fireEvent(setupIceTransport.failed.1.INSTANCE);
            }

            public void consentUpdated(@NotNull Instant time) {
                Intrinsics.checkNotNullParameter(time, "time");
                this.this$0.getTransceiver().getPacketIOActivity().setLastIceActivityInstant(time);
            }
        };
    }

    private final void setupDtlsTransport() {
        this.dtlsTransport.incomingDataHandler = new DtlsTransport.IncomingDataHandler(){

            public void dtlsAppDataReceived(@NotNull byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter(buf, "buf");
            }
        };
        this.dtlsTransport.outgoingDataHandler = new DtlsTransport.OutgoingDataHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendData(@NotNull byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter(buf, "buf");
                Relay.access$getIceTransport$p(this.this$0).send(buf, off, len);
            }
        };
        this.dtlsTransport.eventHandler = new DtlsTransport.EventHandler(this){
            final /* synthetic */ Relay this$0;
            {
                this.this$0 = $receiver;
            }

            public void handshakeComplete(int chosenSrtpProtectionProfile, @NotNull TlsRole tlsRole, @NotNull byte[] keyingMaterial) {
                Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), "tlsRole");
                Intrinsics.checkNotNullParameter(keyingMaterial, "keyingMaterial");
                Relay.access$getLogger$p(this.this$0).info("DTLS handshake complete");
                Relay.access$setSrtpInformation(this.this$0, chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
                this.this$0.scheduleRelayMessageTransportTimeout();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setSrtpInformation(int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
        SrtpTransformers srtpTransformers;
        SrtpProfileInformation srtpProfileInfo = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(chosenSrtpProtectionProfile);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Transceiver " + this.id + " creating transformers with:\nprofile info:\n" + srtpProfileInfo + "\ntls role: " + tlsRole);
        }
        this.srtpTransformers = srtpTransformers = SrtpUtil.Companion.initializeTransformer(srtpProfileInfo, keyingMaterial, tlsRole, this.logger);
        this.transceiver.setSrtpInformation(srtpTransformers);
        Object bl = this.endpointsLock;
        synchronized (bl) {
            boolean bl2 = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint it = (RelayedEndpoint)element$iv;
                boolean bl3 = false;
                it.setSrtpInformation(srtpTransformers);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "senders.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender it = (RelayEndpointSender)element$iv;
            boolean bl4 = false;
            it.setSrtpInformation(srtpTransformers);
        }
    }

    public final void setTransportInfo(@NotNull IceUdpTransportPacketExtension transportInfo) {
        block3: {
            Intrinsics.checkNotNullParameter(transportInfo, "transportInfo");
            Map remoteFingerprints = new LinkedHashMap();
            List<DtlsFingerprintPacketExtension> fingerprintExtensions = transportInfo.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            Intrinsics.checkNotNullExpressionValue(fingerprintExtensions, "fingerprintExtensions");
            Iterable $this$forEach$iv = fingerprintExtensions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DtlsFingerprintPacketExtension fingerprintExtension = (DtlsFingerprintPacketExtension)element$iv;
                boolean bl = false;
                if (fingerprintExtension.getHash() != null && fingerprintExtension.getFingerprint() != null) {
                    String string;
                    String string2;
                    Map map = remoteFingerprints;
                    Intrinsics.checkNotNullExpressionValue(fingerprintExtension.getHash(), "fingerprintExtension.hash");
                    Intrinsics.checkNotNullExpressionValue(fingerprintExtension.getFingerprint(), "fingerprintExtension.fingerprint");
                    map.put(string2, string);
                    continue;
                }
                this.logger.info("Ignoring empty DtlsFingerprint extension: " + transportInfo.toXML());
            }
            this.dtlsTransport.setRemoteFingerprints(remoteFingerprints);
            if (!((Collection)fingerprintExtensions).isEmpty()) {
                String setup = CollectionsKt.first(fingerprintExtensions).getSetup();
                this.dtlsTransport.setSetupAttribute(setup);
            }
            this.iceTransport.startConnectivityEstablishment(transportInfo);
            WebSocketPacketExtension websocketExtension = transportInfo.getFirstChildOfType(WebSocketPacketExtension.class);
            Object object = websocketExtension;
            if (object == null || (object = ((WebSocketPacketExtension)object).getUrl()) == null) break block3;
            Object it = object;
            boolean bl = false;
            this.messageTransport.connectTo((String)it);
        }
    }

    @NotNull
    public final IceUdpTransportPacketExtension describeTransport() {
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        this.iceTransport.describe(iceUdpTransportPacketExtension);
        this.dtlsTransport.describe(iceUdpTransportPacketExtension);
        WebSocketPacketExtension wsPacketExtension = new WebSocketPacketExtension();
        if (this.messageTransport.isActive()) {
            wsPacketExtension.setActive(true);
        } else {
            ColibriWebSocketService colibriWebSocketService = ColibriWebSocketServiceSupplierKt.getColibriWebSocketServiceSupplier().get();
            if (colibriWebSocketService != null) {
                ColibriWebSocketService colibriWebsocketService = colibriWebSocketService;
                boolean bl = false;
                String string = this.conference.getID();
                Intrinsics.checkNotNullExpressionValue(string, "conference.id");
                String string2 = colibriWebsocketService.getColibriRelayWebSocketUrl(string, this.id, this.iceTransport.getIcePassword());
                if (string2 != null) {
                    String wsUrl = string2;
                    boolean bl2 = false;
                    wsPacketExtension.setUrl(wsUrl);
                }
            }
        }
        iceUdpTransportPacketExtension.addChildExtension(wsPacketExtension);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Transport description:\n" + iceUdpTransportPacketExtension.toXML());
        }
        return iceUdpTransportPacketExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFeature(@NotNull EndpointDebugFeatures feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] == 1) {
            this.transceiver.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled2);
            Object object = this.endpointsLock;
            synchronized (object) {
                boolean bl = false;
                Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
                Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RelayedEndpoint e = (RelayedEndpoint)element$iv;
                    boolean bl2 = false;
                    e.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled2);
                }
                Unit unit = Unit.INSTANCE;
            }
            Collection<RelayEndpointSender> collection = this.senders.values();
            Intrinsics.checkNotNullExpressionValue(collection, "senders.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayEndpointSender s2 = (RelayEndpointSender)element$iv;
                boolean bl = false;
                s2.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled2);
            }
        }
    }

    public final boolean isFeatureEnabled(@NotNull EndpointDebugFeatures feature) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        if (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP);
    }

    private final void handleMediaPacket(RelayedPacketInfo packetInfo) {
        if (PacketExtensionsKt.looksLikeRtp(packetInfo.getPacket())) {
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
            long ssrc2 = RtpHeader.Companion.getSsrc(packetInfo.getPacket().buffer, packetInfo.getPacket().offset);
            RelayedEndpoint ep = this.getEndpointBySsrc(ssrc2);
            if (ep != null) {
                ep.handleIncomingPacket(packetInfo);
                return;
            }
            this.logger.warn(() -> Relay.handleMediaPacket$lambda-19(ssrc2));
            Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
            function1.invoke(packetInfo.getPacket().buffer);
        } else if (PacketExtensionsKt.looksLikeRtcp(packetInfo.getPacket())) {
            Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
            long ssrc3 = RtcpHeader.Companion.getSenderSsrc(packetInfo.getPacket().buffer, packetInfo.getPacket().offset);
            RelayedEndpoint ep = this.getEndpointBySsrc(ssrc3);
            if (ep != null) {
                ep.handleIncomingPacket(packetInfo);
                return;
            }
            this.transceiver.handleIncomingPacket(packetInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleIncomingPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Packet packet = packetInfo.getPacket();
        if (packet instanceof RtpPacket) {
            RelayedEndpoint relayedEndpoint;
            Object object = this.endpointsLock;
            synchronized (object) {
                boolean bl = false;
                relayedEndpoint = this.endpointsBySsrc.get(((RtpPacket)packet).getSsrc());
            }
            RelayedEndpoint ep = relayedEndpoint;
            if (ep != null) {
                packetInfo.setEndpointId(ep.getId());
            }
        }
        this.conference.handleIncomingPacket(packetInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewSsrcAssociation(@NotNull String endpointId, long primarySsrc, long secondarySsrc, @NotNull SsrcAssociationType type2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this.relayedEndpoints.containsKey(endpointId);
        }
        if (bl) {
            this.transceiver.addSsrcAssociation(new LocalSsrcAssociation(primarySsrc, secondarySsrc, type2));
        } else {
            this.transceiver.addSsrcAssociation(new RemoteSsrcAssociation(primarySsrc, secondarySsrc, type2));
        }
    }

    public final boolean doSendSrtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        packetInfo.addEvent(SRTP_QUEUE_EXIT_EVENT);
        PacketTransitStats.packetSent(packetInfo);
        packetInfo.sent();
        if (this.timelineLogger.isTraceEnabled() && Endpoint.Companion.logTimeline()) {
            this.timelineLogger.trace(() -> Relay.doSendSrtp$lambda-22(packetInfo));
        }
        Intrinsics.checkNotNullExpressionValue(packetInfo.getPacket().buffer, "packetInfo.packet.buffer");
        this.iceTransport.send(packetInfo.getPacket().buffer, packetInfo.getPacket().offset, packetInfo.getPacket().length);
        ByteBufferPool.returnBuffer(packetInfo.getPacket().buffer);
        return true;
    }

    public final void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        this.messageTransport.sendMessage(msg);
    }

    public final void relayMessageTransportConnected() {
        AbstractEndpoint e;
        Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
        Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            e = (RelayedEndpoint)element$iv;
            boolean bl = false;
            ((RelayedEndpoint)e).relayMessageTransportConnected();
        }
        List<AbstractEndpoint> list = this.conference.getEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, "conference.endpoints");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            e = (AbstractEndpoint)element$iv;
            boolean bl = false;
            if (!(e instanceof Endpoint) && (!(e instanceof RelayedEndpoint) || Intrinsics.areEqual(((RelayedEndpoint)e).getRelay().meshId, this.meshId))) continue;
            MediaSourceDesc[] $this$forEach$iv2 = e.getMediaSources();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv2;
                MediaSourceDesc msd = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (msd.getVideoType() == VideoType.CAMERA) continue;
                SourceVideoTypeMessage videoTypeMsg = new SourceVideoTypeMessage(msd.getVideoType(), msd.getSourceName(), e.getId());
                this.sendMessage(videoTypeMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void addRemoteEndpoint(@NotNull String id, @Nullable String statsId, @NotNull Collection<AudioSourceDesc> audioSources, @NotNull Collection<MediaSourceDesc> videoSources) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(audioSources, "audioSources");
        Intrinsics.checkNotNullParameter(videoSources, "videoSources");
        RelayedEndpoint ep = null;
        Object object = this.endpointsLock;
        synchronized (object) {
            void $this$addRemoteEndpoint_u24lambda_u2d28_u24lambda_u2d26;
            DiagnosticContext diagnosticContext;
            boolean bl = false;
            if (this.relayedEndpoints.containsKey(id)) {
                this.logger.warn("Relay already contains remote endpoint with ID " + id);
                this.updateRemoteEndpoint(id, audioSources, videoSources);
                return;
            }
            DiagnosticContext diagnosticContext2 = diagnosticContext = this.conference.newDiagnosticContext();
            Logger logger = this.logger;
            String string = id;
            Relay relay = this;
            Conference conference = this.conference;
            boolean bl2 = false;
            $this$addRemoteEndpoint_u24lambda_u2d28_u24lambda_u2d26.put("relay_id", this.id);
            $this$addRemoteEndpoint_u24lambda_u2d28_u24lambda_u2d26.put("endpoint_id", id);
            Unit unit = Unit.INSTANCE;
            DiagnosticContext diagnosticContext3 = diagnosticContext;
            Intrinsics.checkNotNullExpressionValue(diagnosticContext3, "conference.newDiagnostic\u2026d\", id)\n                }");
            DiagnosticContext diagnosticContext4 = diagnosticContext3;
            Logger logger2 = logger;
            String string2 = string;
            Relay relay2 = relay;
            Conference conference2 = conference;
            ep = new RelayedEndpoint(conference2, relay2, string2, logger2, diagnosticContext4);
            ep.setStatsId(statsId);
            Collection<Object> $this$toTypedArray$iv = audioSources;
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            AudioSourceDesc[] audioSourceDescArray = thisCollection$iv.toArray(new AudioSourceDesc[0]);
            if (audioSourceDescArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ep.setAudioSources(audioSourceDescArray);
            $this$toTypedArray$iv = videoSources;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            MediaSourceDesc[] mediaSourceDescArray = thisCollection$iv.toArray(new MediaSourceDesc[0]);
            if (mediaSourceDescArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ep.setMediaSources(mediaSourceDescArray);
            ((Map)this.relayedEndpoints).put(id, ep);
            Iterable $this$forEach$iv = ep.getSsrcs();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long ssrc2 = (Long)element$iv;
                boolean bl3 = false;
                Map map = this.endpointsBySsrc;
                Intrinsics.checkNotNullExpressionValue(ssrc2, "ssrc");
                map.put(ssrc2, ep);
            }
            Unit $i$a$-synchronized-Relay$addRemoteEndpoint$2 = Unit.INSTANCE;
        }
        this.conference.addEndpoints(SetsKt.setOf(ep));
        SrtpTransformers srtpTransformers = this.srtpTransformers;
        if (srtpTransformers != null) {
            SrtpTransformers it = srtpTransformers;
            boolean bl = false;
            ep.setSrtpInformation(it);
        }
        Iterable $this$forEach$iv = this.payloadTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PayloadType payloadType = (PayloadType)element$iv;
            boolean bl = false;
            ep.addPayloadType(payloadType);
        }
        $this$forEach$iv = this.rtpExtensions;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpExtension rtpExtension = (RtpExtension)element$iv;
            boolean bl = false;
            ep.addRtpExtension(rtpExtension);
        }
        this.setEndpointMediaSources(ep, audioSources, videoSources);
        ep.setFeature(Features.TRANSCEIVER_PCAP_DUMP, this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateRemoteEndpoint(@NotNull String id, @NotNull Collection<AudioSourceDesc> audioSources, @NotNull Collection<MediaSourceDesc> videoSources) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(audioSources, "audioSources");
        Intrinsics.checkNotNullParameter(videoSources, "videoSources");
        RelayedEndpoint ep = null;
        Object object = this.endpointsLock;
        synchronized (object) {
            RelayedEndpoint relayedEndpoint;
            boolean bl = false;
            RelayedEndpoint relayedEndpoint2 = relayedEndpoint = this.relayedEndpoints.get(id);
            if (relayedEndpoint2 == null) {
                Relay $this$updateRemoteEndpoint_u24lambda_u2d34_u24lambda_u2d32 = this;
                boolean bl2 = false;
                $this$updateRemoteEndpoint_u24lambda_u2d34_u24lambda_u2d32.logger.warn("Endpoint with ID " + id + " not found in relay");
                return;
            }
            Intrinsics.checkNotNullExpressionValue(relayedEndpoint2, "relayedEndpoints[id] ?: \u2026     return\n            }");
            ep = relayedEndpoint;
            Set oldSsrcs = ep.getSsrcs();
            Collection<Object> $this$toTypedArray$iv = audioSources;
            boolean $i$f$toTypedArray = false;
            Collection<AudioSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
            AudioSourceDesc[] audioSourceDescArray = thisCollection$iv.toArray(new AudioSourceDesc[0]);
            if (audioSourceDescArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ep.setAudioSources(audioSourceDescArray);
            $this$toTypedArray$iv = videoSources;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            MediaSourceDesc[] mediaSourceDescArray = thisCollection$iv.toArray(new MediaSourceDesc[0]);
            if (mediaSourceDescArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ep.setMediaSources(mediaSourceDescArray);
            Set newSsrcs = ep.getSsrcs();
            Set removedSsrcs = SetsKt.minus(oldSsrcs, newSsrcs);
            Set addedSsrcs = SetsKt.minus(newSsrcs, oldSsrcs);
            this.endpointsBySsrc.keySet().removeAll(removedSsrcs);
            Iterable $this$forEach$iv = addedSsrcs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long ssrc2 = (Long)element$iv;
                boolean bl3 = false;
                Map map = this.endpointsBySsrc;
                Intrinsics.checkNotNullExpressionValue(ssrc2, "ssrc");
                map.put(ssrc2, ep);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.setEndpointMediaSources(ep, audioSources, videoSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRemoteEndpoint(@NotNull String id) {
        block4: {
            Intrinsics.checkNotNullParameter(id, "id");
            RelayedEndpoint ep = null;
            Object object = this.endpointsLock;
            synchronized (object) {
                boolean bl = false;
                ep = this.relayedEndpoints.remove(id);
                if (ep != null) {
                    this.endpointsBySsrc.keySet().removeAll(ep.getSsrcs());
                }
                Unit unit = Unit.INSTANCE;
            }
            RelayedEndpoint relayedEndpoint = ep;
            if (relayedEndpoint == null) break block4;
            relayedEndpoint.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final RelayEndpointSender getOrCreateRelaySender(String endpointId) {
        ConcurrentHashMap<String, RelayEndpointSender> concurrentHashMap = this.senders;
        synchronized (concurrentHashMap) {
            void $this$getOrCreateRelaySender_u24lambda_u2d41_u24lambda_u2d37;
            DiagnosticContext it2;
            block7: {
                boolean bl = false;
                RelayEndpointSender relayEndpointSender = this.senders.get(endpointId);
                if (relayEndpointSender == null) break block7;
                RelayEndpointSender it2 = relayEndpointSender;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(it2, "it");
                RelayEndpointSender relayEndpointSender2 = it2;
                return relayEndpointSender2;
            }
            DiagnosticContext bl2 = it2 = this.conference.newDiagnosticContext();
            Logger logger = this.logger;
            String string = endpointId;
            Relay relay = this;
            boolean bl = false;
            $this$getOrCreateRelaySender_u24lambda_u2d41_u24lambda_u2d37.put("relay_id", this.id);
            $this$getOrCreateRelaySender_u24lambda_u2d41_u24lambda_u2d37.put("endpoint_id", endpointId);
            Unit unit = Unit.INSTANCE;
            DiagnosticContext diagnosticContext = it2;
            Intrinsics.checkNotNullExpressionValue(diagnosticContext, "conference.newDiagnostic\u2026ointId)\n                }");
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            Logger logger2 = logger;
            String string2 = string;
            Relay relay2 = relay;
            RelayEndpointSender s2 = new RelayEndpointSender(relay2, string2, logger2, diagnosticContext2);
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                SrtpTransformers it3 = srtpTransformers;
                boolean bl3 = false;
                s2.setSrtpInformation(it3);
            }
            Iterable $this$forEach$iv = this.payloadTypes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadType payloadType = (PayloadType)element$iv;
                boolean bl4 = false;
                s2.addPayloadType(payloadType);
            }
            $this$forEach$iv = this.rtpExtensions;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtpExtension rtpExtension = (RtpExtension)element$iv;
                boolean bl5 = false;
                s2.addRtpExtension(rtpExtension);
            }
            s2.setFeature(Features.TRANSCEIVER_PCAP_DUMP, this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP));
            ((Map)this.senders).put(endpointId, s2);
            RelayEndpointSender relayEndpointSender = s2;
            return relayEndpointSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.transceiver.addPayloadType(payloadType);
        this.payloadTypes.add(payloadType);
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.addPayloadType(payloadType);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "senders.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s2 = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s2.addPayloadType(payloadType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        if (rtpExtension.getType() == RtpExtensionType.TRANSPORT_CC || rtpExtension.getType() == RtpExtensionType.ABS_SEND_TIME) {
            return;
        }
        this.transceiver.addRtpExtension(rtpExtension);
        this.rtpExtensions.add(rtpExtension);
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint ep = (RelayedEndpoint)element$iv;
                boolean bl2 = false;
                ep.addRtpExtension(rtpExtension);
            }
            Unit unit = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "senders.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender s2 = (RelayEndpointSender)element$iv;
            boolean bl = false;
            s2.addRtpExtension(rtpExtension);
        }
    }

    private final void setEndpointMediaSources(RelayedEndpoint ep, Collection<AudioSourceDesc> audioSources, Collection<MediaSourceDesc> videoSources) {
        Collection<Object> $this$toTypedArray$iv = audioSources;
        boolean $i$f$toTypedArray = false;
        Collection<AudioSourceDesc> thisCollection$iv = $this$toTypedArray$iv;
        AudioSourceDesc[] audioSourceDescArray = thisCollection$iv.toArray(new AudioSourceDesc[0]);
        if (audioSourceDescArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ep.setAudioSources(audioSourceDescArray);
        $this$toTypedArray$iv = videoSources;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        MediaSourceDesc[] mediaSourceDescArray = thisCollection$iv.toArray(new MediaSourceDesc[0]);
        if (mediaSourceDescArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ep.setMediaSources(mediaSourceDescArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RelayedEndpoint getEndpoint(@NotNull String id) {
        RelayedEndpoint relayedEndpoint;
        Intrinsics.checkNotNullParameter(id, "id");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            relayedEndpoint = this.relayedEndpoints.get(id);
        }
        return relayedEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RelayedEndpoint getEndpointBySsrc(long ssrc2) {
        RelayedEndpoint relayedEndpoint;
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean bl = false;
            relayedEndpoint = this.endpointsBySsrc.get(ssrc2);
        }
        return relayedEndpoint;
    }

    public final void scheduleRelayMessageTransportTimeout() {
        TaskPools.SCHEDULED_POOL.schedule(() -> Relay.scheduleRelayMessageTransportTimeout$lambda-50(this), 30L, TimeUnit.SECONDS);
    }

    public final boolean acceptWebSocket(@NotNull String password) {
        Intrinsics.checkNotNullParameter(password, "password");
        if (!Intrinsics.areEqual(this.iceTransport.getIcePassword(), password)) {
            this.logger.warn("Incoming web socket request with an invalid password. Expected: " + this.iceTransport.getIcePassword() + " received " + password);
            return false;
        }
        return true;
    }

    private final Collection<Long> getRtcpSsrcs(RtcpPacket packet) {
        HashSet<Long> ssrcs2 = new HashSet<Long>();
        ssrcs2.add(packet.getSenderSsrc());
        RtcpPacket rtcpPacket = packet;
        if (rtcpPacket instanceof CompoundRtcpPacket) {
            Iterable $this$forEach$iv = ((CompoundRtcpPacket)packet).getPackets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpPacket it = (RtcpPacket)element$iv;
                boolean bl = false;
                ssrcs2.addAll(this.getRtcpSsrcs(it));
            }
        } else if (rtcpPacket instanceof RtcpFbFirPacket) {
            ssrcs2.add(((RtcpFbFirPacket)packet).getMediaSenderSsrc());
        } else if (rtcpPacket instanceof RtcpFbPacket) {
            ssrcs2.add(((RtcpFbPacket)packet).getMediaSourceSsrc());
        } else if (rtcpPacket instanceof RtcpSrPacket) {
            Iterable $this$forEach$iv = ((RtcpSrPacket)packet).getReportBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpReportBlock it = (RtcpReportBlock)element$iv;
                boolean bl = false;
                ssrcs2.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpRrPacket) {
            Iterable $this$forEach$iv = ((RtcpRrPacket)packet).getReportBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpReportBlock it = (RtcpReportBlock)element$iv;
                boolean bl = false;
                ssrcs2.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpSdesPacket) {
            Iterable $this$forEach$iv = ((RtcpSdesPacket)packet).getSdesChunks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SdesChunk it = (SdesChunk)element$iv;
                boolean bl = false;
                ssrcs2.add(it.getSsrc());
            }
        } else if (rtcpPacket instanceof RtcpByePacket) {
            ssrcs2.addAll((Collection)((RtcpByePacket)packet).getSsrcs());
        }
        return ssrcs2;
    }

    private final void doRtcpCallbacks(RtcpPacket packet, String endpointId, Function1<? super RtcpEventNotifier, Unit> callback) {
        Collection<Long> ssrcs2 = this.getRtcpSsrcs(packet);
        HashSet<String> eps = new HashSet<String>();
        Iterable $this$forEach$iv = ssrcs2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractEndpoint abstractEndpoint;
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            AbstractEndpoint abstractEndpoint2 = abstractEndpoint = this.conference.getEndpointBySsrc(it);
            if (abstractEndpoint2 == null) continue;
            Intrinsics.checkNotNullExpressionValue(abstractEndpoint2, "getEndpointBySsrc(it)");
            AbstractEndpoint it2 = abstractEndpoint;
            boolean bl2 = false;
            eps.add(it2.getId());
        }
        String string = endpointId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            eps.remove(it);
        }
        $this$forEach$iv = eps;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            String epId = (String)element$iv;
            boolean bl = false;
            if (this.getEndpoint(epId) != null) {
                boolean bl3 = false;
                callback.invoke(((RelayedEndpoint)it).getRtcpEventNotifier());
            }
            if (this.senders.get(epId) == null) continue;
            boolean bl4 = false;
            callback.invoke(((RelayEndpointSender)it).getRtcpEventNotifier());
        }
        if (endpointId != null) {
            callback.invoke(this.transceiver.getRtcpEventNotifier());
        }
    }

    public final void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime, @Nullable String endpointId) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.doRtcpCallbacks(packet, endpointId, (Function1<? super RtcpEventNotifier, Unit>)new Function1<RtcpEventNotifier, Unit>(packet, receivedTime){
            final /* synthetic */ RtcpPacket $packet;
            final /* synthetic */ Instant $receivedTime;
            {
                this.$packet = $packet;
                this.$receivedTime = $receivedTime;
                super(1);
            }

            public final void invoke(@NotNull RtcpEventNotifier it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.notifyRtcpReceived(this.$packet, this.$receivedTime, true);
            }
        });
    }

    public final void rtcpPacketSent(@NotNull RtcpPacket packet, @Nullable String endpointId) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.doRtcpCallbacks(packet, endpointId, (Function1<? super RtcpEventNotifier, Unit>)new Function1<RtcpEventNotifier, Unit>(packet){
            final /* synthetic */ RtcpPacket $packet;
            {
                this.$packet = $packet;
                super(1);
            }

            public final void invoke(@NotNull RtcpEventNotifier it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.notifyRtcpSent(this.$packet, true);
            }
        });
    }

    private final boolean isTransportConnected() {
        return this.iceTransport.isConnected() && this.dtlsTransport.isConnected();
    }

    @Override
    public boolean wants(@NotNull PacketInfo packet) {
        boolean bl;
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (!this.isTransportConnected()) {
            return false;
        }
        if (packet instanceof RelayedPacketInfo && Intrinsics.areEqual(((RelayedPacketInfo)packet).getMeshId(), this.meshId)) {
            return false;
        }
        Packet packet2 = packet.getPacket();
        if ((((packet2 instanceof VideoRtpPacket ? true : packet2 instanceof AudioRtpPacket) ? true : packet2 instanceof RtcpSrPacket) ? true : packet2 instanceof RtcpFbPliPacket) ? true : packet2 instanceof RtcpFbFirPacket) {
            bl = true;
        } else {
            this.logger.warn("Ignoring an unknown packet type:" + packet.getPacket().getClass().getSimpleName());
            bl = false;
        }
        return bl;
    }

    @Override
    public void send(@NotNull PacketInfo packet) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter(packet, "packet");
            String string = packet.getEndpointId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.getOrCreateRelaySender(it).sendPacket(packet);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            Relay $this$send_u24lambda_u2d62 = this;
            boolean bl = false;
            $this$send_u24lambda_u2d62.transceiver.sendPacket(packet);
        }
    }

    public final void endpointExpired(@NotNull String id) {
        block0: {
            RelayEndpointSender s2;
            Intrinsics.checkNotNullParameter(id, "id");
            RelayEndpointSender relayEndpointSender = s2 = this.senders.remove(id);
            if (relayEndpointSender == null) break block0;
            relayEndpointSender.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final double getIncomingBitrateBps() {
        double d;
        Object object = this.endpointsLock;
        double d2 = this.transceiver.getTransceiverStats().getRtpReceiverStats().getPacketStreamStats().getBitrateBps();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
            Iterable iterable = collection;
            double d3 = 0.0;
            for (Object t : iterable) {
                void it;
                RelayedEndpoint relayedEndpoint = (RelayedEndpoint)t;
                double d4 = d3;
                boolean bl2 = false;
                double d5 = it.getIncomingStats().getBitrateBps();
                d3 = d4 + d5;
            }
            d = d3;
        }
        double d6 = d;
        return d2 + d6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long getIncomingPacketRate() {
        long l;
        Object object = this.endpointsLock;
        long l2 = this.transceiver.getTransceiverStats().getRtpReceiverStats().getPacketStreamStats().getPacketRate();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
            Iterable iterable = collection;
            long l3 = 0L;
            for (Object t : iterable) {
                void it;
                RelayedEndpoint relayedEndpoint = (RelayedEndpoint)t;
                long l4 = l3;
                boolean bl2 = false;
                long l5 = it.getIncomingStats().getPacketRate();
                l3 = l4 + l5;
            }
            l = l3;
        }
        long l6 = l;
        return l2 + l6;
    }

    /*
     * WARNING - void declaration
     */
    public final double getOutgoingBitrateBps() {
        double d;
        double d2 = this.transceiver.getTransceiverStats().getOutgoingPacketStreamStats().getBitrateBps();
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "senders.values");
        Iterable iterable = collection;
        double d3 = d2;
        double d4 = 0.0;
        for (Object t : iterable) {
            void it;
            RelayEndpointSender relayEndpointSender = (RelayEndpointSender)t;
            d = d4;
            boolean bl = false;
            double d5 = it.getOutgoingStats().getBitrateBps();
            d4 = d + d5;
        }
        d = d4;
        return d3 + d;
    }

    /*
     * WARNING - void declaration
     */
    public final long getOutgoingPacketRate() {
        long l;
        long l2 = this.transceiver.getTransceiverStats().getOutgoingPacketStreamStats().getPacketRate();
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "senders.values");
        Iterable iterable = collection;
        long l3 = l2;
        long l4 = 0L;
        for (Object t : iterable) {
            void it;
            RelayEndpointSender relayEndpointSender = (RelayEndpointSender)t;
            l = l4;
            boolean bl = false;
            long l5 = it.getOutgoingStats().getPacketRate();
            l4 = l + l5;
        }
        l = l4;
        return l3 + l;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStatsOnExpire() {
        void $this$filterTo$iv$iv;
        Conference.Statistics conferenceStats = this.conference.getStatistics();
        TransceiverStats transceiverStats = this.transceiver.getTransceiverStats();
        PacketStreamStats.Snapshot incomingStats = transceiverStats.getRtpReceiverStats().getPacketStreamStats();
        PacketStreamStats.Snapshot outgoingStats = transceiverStats.getOutgoingPacketStreamStats();
        this.statistics.getBytesReceived().getAndAdd(incomingStats.getBytes());
        this.statistics.getPacketsReceived().getAndAdd(incomingStats.getPackets());
        this.statistics.getBytesSent().getAndAdd(outgoingStats.getBytes());
        this.statistics.getPacketsSent().getAndAdd(outgoingStats.getPackets());
        Object object = conferenceStats;
        Conference.Statistics $this$updateStatsOnExpire_u24lambda_u2d69 = object;
        boolean bl = false;
        $this$updateStatsOnExpire_u24lambda_u2d69.totalRelayBytesReceived.addAndGet(this.statistics.getBytesReceived().get());
        $this$updateStatsOnExpire_u24lambda_u2d69.totalRelayPacketsReceived.addAndGet(this.statistics.getPacketsReceived().get());
        $this$updateStatsOnExpire_u24lambda_u2d69.totalRelayBytesSent.addAndGet(this.statistics.getBytesSent().get());
        $this$updateStatsOnExpire_u24lambda_u2d69.totalRelayPacketsSent.addAndGet(this.statistics.getPacketsSent().get());
        Object $this$updateStatsOnExpire_u24lambda_u2d71 = object = this.conference.getVideobridge().getStatistics();
        boolean bl2 = false;
        ((Videobridge.Statistics)$this$updateStatsOnExpire_u24lambda_u2d71).keyframesReceived.addAndGet(transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumKeyframes());
        ((Videobridge.Statistics)$this$updateStatsOnExpire_u24lambda_u2d71).layeringChangesReceived.addAndGet(transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumLayeringChanges());
        Iterable $this$filter$iv = transceiverStats.getRtpReceiverStats().getIncomingStats().getSsrcStats().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncomingSsrcStats.Snapshot it = (IncomingSsrcStats.Snapshot)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getMediaType() == MediaType.VIDEO)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Duration durationActiveVideo2 = ClockUtils.sumOf((List)destination$iv$iv, updateStatsOnExpire.2.durationActiveVideo.2.INSTANCE);
        ((Videobridge.Statistics)$this$updateStatsOnExpire_u24lambda_u2d71).totalVideoStreamMillisecondsReceived.addAndGet(durationActiveVideo2.toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expire() {
        this.expired = true;
        this.logger.info("Expiring.");
        Object object = this.endpointsLock;
        synchronized (object) {
            boolean $i$a$-synchronized-Relay$expire$22 = false;
            Collection<RelayedEndpoint> collection = this.relayedEndpoints.values();
            Intrinsics.checkNotNullExpressionValue(collection, "relayedEndpoints.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelayedEndpoint it = (RelayedEndpoint)element$iv;
                boolean bl = false;
                it.expire();
            }
            Unit $i$a$-synchronized-Relay$expire$22 = Unit.INSTANCE;
        }
        Collection<RelayEndpointSender> collection = this.senders.values();
        Intrinsics.checkNotNullExpressionValue(collection, "senders.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelayEndpointSender it = (RelayEndpointSender)element$iv;
            boolean bl = false;
            it.expire();
        }
        this.conference.relayExpired(this);
        try {
            Logger logger;
            this.updateStatsOnExpire();
            this.transceiver.stop();
            SrtpTransformers srtpTransformers = this.srtpTransformers;
            if (srtpTransformers != null) {
                srtpTransformers.close();
            }
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.transceiver.getNodeStats().prettyPrint(0));
            }
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.iceTransport.getDebugState().toJSONString());
            }
            $this$cdebug$iv = this.logger;
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.dtlsTransport.getDebugState().toJSONString());
            }
            this.transceiver.teardown();
            this.messageTransport.close();
        }
        catch (Throwable t) {
            this.logger.error("Exception while expiring: ", t);
        }
        this.conference.getEncodingsManager().unsubscribe(this);
        this.dtlsTransport.stop();
        this.iceTransport.stop();
        this.outgoingSrtpPacketQueue.close();
        this.logger.info("Expired.");
    }

    @JvmOverloads
    public Relay(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, @Nullable String meshId, boolean iceControlling, boolean useUniquePort) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(id, conference, parentLogger, meshId, iceControlling, useUniquePort, null, 64, null);
    }

    private static final Videobridge.Statistics messageTransport$lambda-3(Relay this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.conference.getVideobridge().getStatistics();
    }

    private static final String handleMediaPacket$lambda-19(long $ssrc) {
        return "RTP Packet received for unknown endpoint SSRC " + $ssrc;
    }

    private static final String doSendSrtp$lambda-22(PacketInfo $packetInfo) {
        Intrinsics.checkNotNullParameter($packetInfo, "$packetInfo");
        return $packetInfo.getTimeline().toString();
    }

    private static final void scheduleRelayMessageTransportTimeout$lambda-50(Relay this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (!this$0.expired && !this$0.messageTransport.isConnected()) {
            this$0.logger.error("RelayMessageTransport still not connected.");
            this$0.conference.getVideobridge().getStatistics().numRelaysNoMessageTransportAfterDelay.inc();
        }
    }

    public static final /* synthetic */ DtlsTransport access$getDtlsTransport$p(Relay $this) {
        return $this.dtlsTransport;
    }

    public static final /* synthetic */ void access$handleMediaPacket(Relay $this, RelayedPacketInfo packetInfo) {
        $this.handleMediaPacket(packetInfo);
    }

    public static final /* synthetic */ EventEmitter access$getEventEmitter$p(Relay $this) {
        return $this.eventEmitter;
    }

    public static final /* synthetic */ PacketInfoQueue access$getOutgoingSrtpPacketQueue$p(Relay $this) {
        return $this.outgoingSrtpPacketQueue;
    }

    public static final /* synthetic */ IceTransport access$getIceTransport$p(Relay $this) {
        return $this.iceTransport;
    }

    public static final /* synthetic */ void access$setSrtpInformation(Relay $this, int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
        $this.setSrtpInformation(chosenSrtpProtectionProfile, tlsRole, keyingMaterial);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/relay/Relay$Companion;", "", "()V", "SRTP_QUEUE_ENTRY_EVENT", "", "SRTP_QUEUE_EXIT_EVENT", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/relay/Relay$Statistics;", "", "()V", "bytesReceived", "Ljava/util/concurrent/atomic/AtomicLong;", "getBytesReceived", "()Ljava/util/concurrent/atomic/AtomicLong;", "bytesSent", "getBytesSent", "packetsReceived", "getPacketsReceived", "packetsSent", "getPacketsSent", "getJson", "Lorg/json/simple/JSONObject;", "jitsi-videobridge"})
    public static final class Statistics {
        @NotNull
        private final AtomicLong bytesReceived = new AtomicLong(0L);
        @NotNull
        private final AtomicLong packetsReceived = new AtomicLong(0L);
        @NotNull
        private final AtomicLong bytesSent = new AtomicLong(0L);
        @NotNull
        private final AtomicLong packetsSent = new AtomicLong(0L);

        @NotNull
        public final AtomicLong getBytesReceived() {
            return this.bytesReceived;
        }

        @NotNull
        public final AtomicLong getPacketsReceived() {
            return this.packetsReceived;
        }

        @NotNull
        public final AtomicLong getBytesSent() {
            return this.bytesSent;
        }

        @NotNull
        public final AtomicLong getPacketsSent() {
            return this.packetsSent;
        }

        private final JSONObject getJson() {
            JSONObject jsonObject = new JSONObject();
            ((Map)jsonObject).put("bytes_received", this.bytesReceived.get());
            ((Map)jsonObject).put("bytes_sent", this.bytesSent.get());
            ((Map)jsonObject).put("packets_received", this.packetsReceived.get());
            ((Map)jsonObject).put("packets_sent", this.packetsSent.get());
            return jsonObject;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\r\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/videobridge/relay/Relay$TransceiverEventHandlerImpl;", "Lorg/jitsi/nlj/TransceiverEventHandler;", "(Lorg/jitsi/videobridge/relay/Relay;)V", "audioLevelReceived", "", "sourceSsrc", "", "level", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "jitsi-videobridge"})
    private final class TransceiverEventHandlerImpl
    implements TransceiverEventHandler {
        @Override
        public boolean audioLevelReceived(long sourceSsrc, long level) {
            Relay.this.logger.warn(() -> TransceiverEventHandlerImpl.audioLevelReceived$lambda-0(sourceSsrc));
            return false;
        }

        @Override
        public void bandwidthEstimationChanged-_2icLw0(double newValue) {
            Logger $this$cdebug$iv = Relay.this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Estimated bandwidth is now " + Bandwidth.toString-impl(newValue));
            }
        }

        private static final String audioLevelReceived$lambda-0(long $sourceSsrc) {
            return "Audio level reported by relay transceiver for source " + $sourceSsrc;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/relay/Relay$IncomingRelayPacketHandler;", "", "handleIncomingPacket", "", "packetInfo", "Lorg/jitsi/videobridge/relay/RelayedPacketInfo;", "jitsi-videobridge"})
    public static interface IncomingRelayPacketHandler {
        public void handleIncomingPacket(@NotNull RelayedPacketInfo var1);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EndpointDebugFeatures.values().length];
            nArray[EndpointDebugFeatures.PCAP_DUMP.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

