/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class MUCParserUtils {
    /*
     * Enabled aggressive block sorting
     */
    public static MUCItem parseItem(XmlPullParser parser2) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        MUCAffiliation affiliation = MUCAffiliation.fromString(parser2.getAttributeValue("", "affiliation"));
        Resourcepart nick = ParserUtils.getResourcepartAttribute(parser2, "nick");
        MUCRole role = MUCRole.fromString(parser2.getAttributeValue("", "role"));
        Jid jid = ParserUtils.getJidAttribute(parser2);
        Jid actor = null;
        Resourcepart actorNick = null;
        String reason2 = null;
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "actor": {
                            actor = ParserUtils.getJidAttribute(parser2);
                            String actorNickString = parser2.getAttributeValue("", "nick");
                            if (actorNickString != null) {
                                actorNick = Resourcepart.from(actorNickString);
                                break;
                            }
                            break block0;
                        }
                        case "reason": {
                            reason2 = parser2.nextText();
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return new MUCItem(affiliation, role, actor, reason2, jid, nick, actorNick);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Destroy parseDestroy(XmlPullParser parser2) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        EntityBareJid jid = ParserUtils.getBareJidAttribute(parser2);
        String reason2 = null;
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "reason": {
                            reason2 = parser2.nextText();
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (initialDepth != parser2.getDepth()) break;
                    return new Destroy(jid, reason2);
                }
            }
        }
    }
}

